/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.csm.api.CommonFormDataApi;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormConfigQueryReqBO;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormDataQueryReqBO;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormDataSaveReqBO;
import com.tydic.nicc.csm.api.bo.formdata.CsEvalQueryReqBO;
import com.tydic.nicc.csm.api.bo.formdata.FormDataSyncReqBO;
import com.tydic.nicc.csm.busi.ServiceSyncService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center"})
public class CommonFormDataController {
    private static final Logger log = LoggerFactory.getLogger(CommonFormDataController.class);
    @Resource
    private CommonFormDataApi commonFormDataApi;
    @Resource
    private ServiceSyncService serviceSyncService;

    @PostMapping(value={"/common/formData/list"})
    public RspList getCommonFormDataList(@RequestBody CommonFormDataQueryReqBO queryReqBO) {
        return this.commonFormDataApi.getCommonFormDataCondition(queryReqBO);
    }

    @PostMapping(value={"/common/formData/save"})
    public Rsp saveCommonFormData(@RequestBody CommonFormDataSaveReqBO saveReqBO) {
        return this.commonFormDataApi.saveCommonFormData(saveReqBO);
    }

    @PostMapping(value={"/common/formData/config/get"})
    public Rsp getCommonFormConfig(@RequestBody CommonFormConfigQueryReqBO queryReqBO) {
        return this.commonFormDataApi.getCommonFormConfig(queryReqBO);
    }

    @PostMapping(value={"/common/formData/sync"})
    public Rsp doServiceSync(@RequestBody FormDataSyncReqBO reqBO) {
        return this.serviceSyncService.doServiceSync(reqBO.getTenantCode(), reqBO.getFormCode(), reqBO.getFormData());
    }

    @PostMapping(value={"/common/cs/eval/get"})
    public Rsp getCsEval(@RequestBody CsEvalQueryReqBO reqBO) {
        return this.commonFormDataApi.getLeastCsEval(reqBO);
    }
}

