/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.csm.api.CsChannelManageApi;
import com.tydic.nicc.csm.api.bo.channel.CsBindChannelSkillReqBO;
import com.tydic.nicc.csm.api.bo.channel.CsChannelQueryReqBO;
import com.tydic.nicc.csm.api.bo.channel.CsChannelSaveReqBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center/channel"})
public class CsmChannelController {
    private static final Logger log = LoggerFactory.getLogger(CsmChannelController.class);
    @Resource
    private CsChannelManageApi csChannelManageApi;
    @Autowired
    private CsmCommonService csmCommonService;

    @PostMapping(value={"/query"})
    public RspList getChannelList(@RequestBody CsChannelQueryReqBO req) {
        if (StringUtils.isNotEmpty((String)req.getTenantCode_in())) {
            req.setTenantCode(req.getTenantCode_in());
        }
        return this.csmCommonService.getChannelList(req);
    }

    @PostMapping(value={"/save"})
    public Rsp channelSave(@RequestBody CsChannelSaveReqBO saveReqBO) {
        return this.csChannelManageApi.saveChannel(saveReqBO);
    }

    @PostMapping(value={"/delete"})
    public Rsp delChannel(@RequestBody CsChannelSaveReqBO saveReqBO) {
        return this.csChannelManageApi.deleteChannel(saveReqBO);
    }

    @PostMapping(value={"/list"})
    public RspList listChannel(@RequestBody CsChannelQueryReqBO reqBO) {
        return this.csChannelManageApi.getChannelList(reqBO);
    }

    @PostMapping(value={"/skill/bind"})
    public Rsp bindSkillChannel(@RequestBody CsBindChannelSkillReqBO reqBO) {
        return this.csChannelManageApi.bindSkillChannel(reqBO);
    }

    @PostMapping(value={"/skill/list"})
    public RspList getSkillByChannel(@RequestBody CsChannelQueryReqBO reqBO) {
        return this.csChannelManageApi.getSkillsByChannel(reqBO);
    }

    @PostMapping(value={"/skill/remove"})
    public Rsp removeSkillChannel(@RequestBody CsBindChannelSkillReqBO reqBO) {
        return this.csChannelManageApi.removeSkillChannel(reqBO);
    }
}

