/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.csm.CsmForceOfflineAndTransferReqBO;
import com.tydic.nicc.common.bo.csm.CsmTransferReqBO;
import com.tydic.nicc.common.bo.csm.CsmUserQueueContext;
import com.tydic.nicc.common.bo.csm.CsmUserQueueReqBO;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotNewReqContext;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.eums.csm.CsOnlineStatus;
import com.tydic.nicc.common.eums.csm.CsQueueExitType;
import com.tydic.nicc.csm.api.CsEvaluationApi;
import com.tydic.nicc.csm.api.CsInfoApi;
import com.tydic.nicc.csm.api.CsLabelApi;
import com.tydic.nicc.csm.api.CsWorkScheduleApi;
import com.tydic.nicc.csm.api.bo.cs.CsAllotStrategyBO;
import com.tydic.nicc.csm.api.bo.cs.CsFriendsReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsFriendsSkill;
import com.tydic.nicc.csm.api.bo.cs.CsInfoDenyAllowReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoImportReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoSaveReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsReceiveLimitUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsStatusExtendReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsStrategyReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleCheck;
import com.tydic.nicc.csm.api.bo.evaluation.CsEvaluationConfigQueryReqBO;
import com.tydic.nicc.csm.api.bo.evaluation.CsEvaluationSaveReqBO;
import com.tydic.nicc.csm.api.bo.evaluation.InviteUserEvaluationReqBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelQueryReqBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.service.CsmCsAllotProcessService;
import com.tydic.nicc.csm.service.CsmCsTransferProcessService;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/csm-center"})
public class CsmCsController {
    private static final Logger log = LoggerFactory.getLogger(CsmCsController.class);
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmCsAllotProcessService csmCsAllotProcessService;
    @Resource
    private CsmCsTransferProcessService csmCsTransferProcessService;
    @Resource
    private CsInfoApi csInfoApi;
    @Resource
    private CsLabelApi csLabelApi;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private CsEvaluationApi csEvaluationApi;
    @Resource
    private CsWorkScheduleApi csWorkScheduleApi;

    @PostMapping(value={"/user/queue/info"})
    public Rsp userQueueInfo(@RequestBody CsmUserQueueReqBO userQueueReq) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{userQueueReq})) {
            CsmUserQueueContext queueContext = this.csmCsAllotHelper.getUserQueueInfo(userQueueReq.getUserId());
            return BaseRspUtils.createSuccessRsp((Object)queueContext);
        }
        return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u6392\u961f\u4fe1\u606f\u5931\u8d25,\u53c2\u6570\u5f02\u5e38!");
    }

    @PostMapping(value={"/user/queue/cancel"})
    public Rsp userQueueCancel(@RequestBody CsmUserQueueReqBO userQueueReq) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{userQueueReq})) {
            boolean result = this.csmCsAllotHelper.cancelQueue(userQueueReq.getUserId(), CsQueueExitType.USER_EXIT.getCode());
            return BaseRspUtils.createSuccessRsp((Object)result);
        }
        return BaseRspUtils.createErrorRsp((String)"\u53d6\u6d88\u6392\u5bf9\u5931\u8d25,\u53c2\u6570\u5f02\u5e38!");
    }

    @PostMapping(value={"/cs/workSchedule/check"})
    public Rsp checkCsWorkSchedule(@RequestBody CsWorkScheduleCheck csWorkScheduleCheck) {
        return this.csWorkScheduleApi.checkCsWorkSchedule(csWorkScheduleCheck);
    }

    @PostMapping(value={"/cs/skill/friends"})
    public RspList<CsFriendsSkill> getSkillFriends(@RequestBody CsFriendsReqBO friendsReqBO) {
        return this.csInfoApi.getCsSkillFriends(friendsReqBO);
    }

    @PostMapping(value={"/cs/info"})
    public Rsp getCsInfo(@RequestBody CsInfoQueryReqBO infoReqBO) {
        return this.csInfoApi.getCsInfo(infoReqBO);
    }

    @PostMapping(value={"/cs/setReceiveLimit"})
    public Rsp updateCsReceiveLimit(@RequestBody CsReceiveLimitUpdateReqBO updateReqBO) {
        return this.csInfoApi.updateCsReceiveLimit(updateReqBO);
    }

    @PostMapping(value={"/cs/info/import"})
    public Rsp csImport(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        if (file == null) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6!");
        }
        String tenantCode = request.getParameter("tenantCode");
        String uploadUser = request.getParameter("uploadUser");
        CsInfoImportReqBO importReqBO = new CsInfoImportReqBO();
        importReqBO.setTenantCode(tenantCode);
        importReqBO.setUploadUser(uploadUser);
        try {
            importReqBO.setInputStream(file.getInputStream());
            return this.csInfoApi.importCsInfo(importReqBO);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:{}", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/cs/denyAllow"})
    public Rsp csDenyAllow(@RequestBody CsInfoDenyAllowReqBO reqBO) {
        return this.csInfoApi.setCsDenyAllow(reqBO);
    }

    @PostMapping(value={"/evaluation/config"})
    public Rsp getEvaluationTemplate(@RequestBody CsEvaluationConfigQueryReqBO queryReqBO) {
        return BaseRspUtils.createSuccessRsp((Object)JSONObject.parse((String)"{\"totalStar\":5,\"starDesc\":{\"1\":\"\u975e\u5e38\u4e0d\u6ee1\u610f\",\"2\":\"\u4e0d\u6ee1\u610f\",\"3\":\"\u4e00\u822c\",\"4\":\"\u6ee1\u610f\",\"5\":\"\u975e\u5e38\u6ee1\u610f\"}}"));
    }

    @PostMapping(value={"/cs/evaluation/save"})
    public Rsp saveCsEvaluation(@RequestBody CsEvaluationSaveReqBO saveReqBO) {
        return this.csEvaluationApi.saveEvaluation(saveReqBO);
    }

    @PostMapping(value={"/cs/evaluation/invite"})
    public Rsp inviteUserEvaluation(@RequestBody InviteUserEvaluationReqBO reqBO) {
        return this.csEvaluationApi.inviteUserEvaluation(reqBO);
    }

    @PostMapping(value={"/cs/online/list"})
    public RspList getCsOnlineList(@RequestBody CsInfoQueryReqBO infoReqBO) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{infoReqBO})) {
            infoReqBO.setLiveOnlineStatus(CsOnlineStatus.CS_SIGN_IN.getCode());
            infoReqBO.setTenantCodeList(new ArrayList());
            return this.csInfoApi.getCsList(infoReqBO);
        }
        return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5728\u7ebf\u72b6\u6001\u5ba2\u670d\u5217\u8868\u5931\u8d25:\u53c2\u6570\u9519\u8bef!");
    }

    @PostMapping(value={"/cs/info/save"})
    public Rsp saveCsInfo(@RequestBody CsInfoSaveReqBO saveReqBO) {
        return this.csInfoApi.saveCsInfo(saveReqBO);
    }

    @PostMapping(value={"/cs/list"})
    public RspList getCsList(@RequestBody CsInfoQueryReqBO csInfoReqBO) {
        return this.csInfoApi.getCsList(csInfoReqBO);
    }

    @PostMapping(value={"/cs/list/simple"})
    public RspList getCsListSimple(@RequestBody CsInfoQueryReqBO csInfoReqBO) {
        return this.csInfoApi.getCsSimpleList(csInfoReqBO);
    }

    @PostMapping(value={"/cs/status/list"})
    public RspList getCsStatusList(@RequestBody CsStatusExtendReqBO extendReqBO) {
        return this.csmCommonService.getCsStatusList(extendReqBO.getTenantCode());
    }

    @PostMapping(value={"/cs/status/update"})
    public Rsp updateCsStatus(@RequestBody CsInfoUpdateReqBO updateReqBO) {
        return this.csInfoApi.updateCsStatus(updateReqBO);
    }

    @PostMapping(value={"/cs/allot"})
    public Rsp allotCs(@RequestBody CsmCsAllotReqContext csmCsAllotContext) {
        return this.csmCsAllotProcessService.processCsmAllot(csmCsAllotContext);
    }

    @PostMapping(value={"/cs/allotByRequestAndClose"})
    public Rsp allotByRequestAndClose(@RequestBody CsmCsAllotNewReqContext csmCsAllotContext) {
        return this.csmCsAllotProcessService.processAllotByRequestAndClose(csmCsAllotContext);
    }

    @PostMapping(value={"/cs/allot/transfer"})
    public Rsp allotCsTransfer(@RequestBody CsmTransferReqBO csmTransferReqBO) {
        return this.csmCsTransferProcessService.processCsmTransfer(csmTransferReqBO);
    }

    @PostMapping(value={"/cs/offline/transfer"})
    public Rsp offlineCsAndTransfer(@RequestBody CsmForceOfflineAndTransferReqBO transferReqBO) {
        return this.csmCsTransferProcessService.processForceOfflineAndTransfer(transferReqBO);
    }

    @PostMapping(value={"/cs/strategy/list"})
    public RspList getCsAllotStrategyList(@RequestBody CsStrategyReqBO csStrategyReqBO) {
        List<CsAllotStrategyBO> strategyBOS = this.csmCommonService.getCsAllotStrategyList(csStrategyReqBO);
        return BaseRspUtils.createSuccessRspList(strategyBOS);
    }

    @GetMapping(value={"/cs/skill/{skillGid}"})
    public Rsp getSkillGroupInfo(@PathVariable(value="skillGid") String skillGid) {
        CsSkillGroupBO groupBO = this.csmCommonService.getSkillGroupInfo(skillGid);
        return BaseRspUtils.createSuccessRsp((Object)groupBO);
    }

    @PostMapping(value={"/cs/label/list"})
    public RspList getCsLabels(@RequestBody CsLabelQueryReqBO queryReqBO) {
        return this.csLabelApi.getCsLabels(queryReqBO);
    }

    @PostMapping(value={"/cs/label/save"})
    public Rsp saveCsLabel(@RequestBody CsLabelSaveReqBO saveReqBO) {
        return this.csLabelApi.saveCsLabel(saveReqBO);
    }
}

