/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.csm.api.bo.cs.CsmOnlineItemsReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsmWorkItemsReqBO;
import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.csm.task.CsmItemCountTimer;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center/item"})
public class CsmItemController {
    private static final Logger log = LoggerFactory.getLogger(CsmItemController.class);
    @Resource
    private CsmItemCountTimer csmItemCountTimer;
    @Resource
    private CsmItemCountService csmItemCountService;

    @PostMapping(value={"/run/task"})
    public Rsp runTask() {
        this.csmItemCountTimer.doTaskTimer();
        return BaseRspUtils.createSuccessRsp((Object)"ok");
    }

    @GetMapping(value={"/cs/reload"})
    public Rsp csItemReload(@RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="csIds") @Nullable List<String> csIds) {
        this.csmItemCountService.countAllCsAllotItems(tenantCode, csIds, true);
        return BaseRspUtils.createSuccessRsp(csIds);
    }

    @GetMapping(value={"/receiving/cs/reload"})
    public Rsp csReceivingReload(@RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="csIds") @Nullable List<String> csIds) {
        Iterable<String> ids = this.csmItemCountService.reloadCsReceivingCache(tenantCode, csIds);
        return BaseRspUtils.createSuccessRsp(ids);
    }

    @GetMapping(value={"/received/skill/reload"})
    public Rsp skillReceivedReload(@RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="skillGids") @Nullable List<String> skillGids) {
        Iterable<String> skills = this.csmItemCountService.reloadSkillReceivedTodayCache(tenantCode, skillGids);
        return BaseRspUtils.createSuccessRsp(skills);
    }

    @GetMapping(value={"/receiving/skill/reload"})
    public Rsp skillReceivingReload(@RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="skillGids") @Nullable List<String> skillGids) {
        Iterable<String> skills = this.csmItemCountService.reloadSkillReceivingCache(tenantCode, skillGids);
        return BaseRspUtils.createSuccessRsp(skills);
    }

    @PostMapping(value={"/work-items"})
    public Rsp getCsWorkItems(@RequestBody CsmWorkItemsReqBO itemsReqBO) {
        return this.csmItemCountService.getCsWorkItems(itemsReqBO);
    }

    @PostMapping(value={"/online-items"})
    public Rsp getOnlineItems(@RequestBody CsmOnlineItemsReqBO itemsReqBO) {
        return this.csmItemCountService.getOnlineItems(itemsReqBO);
    }
}

