/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.csm.api.CsmMonitorApi;
import com.tydic.nicc.csm.api.bo.monitor.MonitorCsInfoReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorCsStateLogReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorServiceRecordReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorSkillQueueReqBO;
import com.tydic.nicc.csm.api.bo.monitor.SessionDetailsCountResult;
import com.tydic.nicc.csm.busi.CsmReportCommonService;
import com.tydic.nicc.csm.test.TestRedisThread;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center"})
public class CsmMonitorController {
    private static final Logger log = LoggerFactory.getLogger(CsmMonitorController.class);
    @Resource
    private CsmMonitorApi csmMonitorApi;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private CsmReportCommonService csmReportCommonService;

    @GetMapping(value={"/thread"})
    public Rsp runTest() {
        TestRedisThread redisThread = new TestRedisThread("thread-1", this.redisHelper);
        Thread t1 = new Thread(redisThread);
        t1.start();
        TestRedisThread redisThread2 = new TestRedisThread("thread-2", this.redisHelper);
        Thread t2 = new Thread(redisThread2);
        t2.start();
        return BaseRspUtils.createSuccessRsp((Object)"ok");
    }

    @PostMapping(value={"/monitor/skillGroups"})
    public RspList skillQueueAndServiceList(@RequestBody MonitorSkillQueueReqBO reqBO) {
        return this.csmMonitorApi.skillQueueAndServiceMonitor(reqBO);
    }

    @PostMapping(value={"/monitor/cs/base"})
    public RspList csInfoMonitor(@RequestBody MonitorCsInfoReqBO reqBO) {
        return this.csmMonitorApi.csInfoMonitor(reqBO);
    }

    @PostMapping(value={"/monitor/cs/log"})
    public RspList csStateChangeLogMonitor(@RequestBody MonitorCsStateLogReqBO reqBO) {
        return this.csmMonitorApi.csStateChangeLogMonitor(reqBO);
    }

    @PostMapping(value={"/monitor/service/log"})
    public RspList serviceRecordMonitor(@RequestBody MonitorServiceRecordReqBO reqBO) {
        return this.csmMonitorApi.serviceRecordMonitor(reqBO);
    }

    @PostMapping(value={"/monitor/service/log/export"})
    public RspList serviceRecordMonitorExport(@RequestBody MonitorServiceRecordReqBO reqBO, HttpServletResponse response) {
        return this.csmReportCommonService.serviceRecordMonitorExport(reqBO, response);
    }

    @PostMapping(value={"/service/history/day"})
    public Rsp<SessionDetailsCountResult> serviceHistoryDay(@RequestBody MonitorServiceRecordReqBO reqBO) {
        return this.csmMonitorApi.serviceRecordHistoryByDay(reqBO);
    }
}

