/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.common.bo.csm.CsmQueueCountReqBO;
import com.tydic.nicc.common.bo.csm.CsmUserQueueContext;
import com.tydic.nicc.csm.api.CsSkillGroupApi;
import com.tydic.nicc.csm.api.bo.skill.BaseSkillGType;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupItemsReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.SkillCsListSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.SkillGTypeBO;
import com.tydic.nicc.csm.api.bo.skill.SkillMemberSaveReqBO;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center"})
public class CsmSkillController {
    private static final Logger log = LoggerFactory.getLogger(CsmSkillController.class);
    @Resource
    private CsSkillGroupApi csSkillGroupApi;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private RedisHelper redisHelper;

    @PostMapping(value={"/skill/group/types"})
    public RspList getSkillGTypeList(@RequestBody BaseSkillGType req) {
        if (StringUtils.isEmpty((String)req.getTenantCode())) {
            return BaseRspUtils.createErrorRspList((String)"tenantCode \u4e0d\u5f97\u4e3a\u7a7a");
        }
        ArrayList<SkillGTypeBO> res = new ArrayList<SkillGTypeBO>();
        res.add(new SkillGTypeBO("\u8ba2\u5355\u7ec4", "ORDER_" + req.getTenantCode()));
        res.add(new SkillGTypeBO("\u5546\u54c1\u7ec4", "GOODS_" + req.getTenantCode()));
        res.add(new SkillGTypeBO("\u7ed3\u7b97\u7ec4", "SETTLE_" + req.getTenantCode()));
        return BaseRspUtils.createSuccessRspList(res);
    }

    @GetMapping(value={"/skill/queue/list/{queueKey}"})
    public RspList getQueueList(@PathVariable(value="queueKey") String queueKey) {
        long size = this.redisHelper.lGetListSize(queueKey);
        List<Object> list = this.csmCsAllotHelper.getQueueList(queueKey);
        return BaseRspUtils.createSuccessRspList(list, (long)size);
    }

    @GetMapping(value={"/system/queue/list"})
    public RspList getSysQueueList() {
        List<CsmUserQueueContext> list = this.csmCsAllotHelper.getSystemQueueList();
        return BaseRspUtils.createSuccessRspList(list);
    }

    @PostMapping(value={"/skill/queue/count"})
    public Rsp queueCount(@RequestBody CsmQueueCountReqBO csmQueueCountReqBO) {
        return this.csSkillGroupApi.getRtQueueCount(csmQueueCountReqBO);
    }

    @PostMapping(value={"/skill/group/info"})
    public Rsp getSkillGroupsByTag(@RequestBody CsSkillGroupReqBO groupReqBO) {
        return this.csSkillGroupApi.getSkillByTag(groupReqBO);
    }

    @PostMapping(value={"/skill/group/items"})
    public Rsp getSkillGroupsByTag(@RequestBody CsSkillGroupItemsReqBO reqBO) {
        return this.csSkillGroupApi.getSkillItems(reqBO);
    }

    @PostMapping(value={"/skill/group/saveMembers"})
    public Rsp saveSkillMembers(@RequestBody SkillMemberSaveReqBO saveReqBO) {
        return this.csSkillGroupApi.saveSkillMembers(saveReqBO);
    }

    @PostMapping(value={"/skill/groups"})
    public RspList getSkillGroups(@RequestBody CsSkillGroupReqBO groupReqBO) {
        return this.csSkillGroupApi.getCsSkillGroupList(groupReqBO);
    }

    @PostMapping(value={"/skill/groups/simple"})
    public RspList getSkillSimpleGroups(@RequestBody CsSkillGroupReqBO groupReqBO) {
        return this.csSkillGroupApi.getSimpleSkillGroupList(groupReqBO);
    }

    @PostMapping(value={"/skill/group/save"})
    public Rsp saveSkillGroup(@RequestBody CsSkillGroupSaveReqBO groupReqBO) {
        return this.csSkillGroupApi.saveSkillGroup(groupReqBO);
    }

    @PostMapping(value={"/skill/cs/save"})
    public Rsp saveSkillGroup(@RequestBody SkillCsListSaveReqBO csListSaveReqBO) {
        return this.csSkillGroupApi.saveSkillCsList(csListSaveReqBO);
    }
}

