/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.framework.utils.FileManagerHelper;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center"})
public class FileProxyController {
    private static final Logger log = LoggerFactory.getLogger(FileProxyController.class);
    private final FileManagerHelper fileManagerHelper;

    public FileProxyController(FileManagerHelper fileManagerHelper) {
        this.fileManagerHelper = fileManagerHelper;
    }

    @GetMapping(value={"/proxy/**"})
    public ResponseEntity<InputStreamResource> proxyFile(HttpServletRequest request) {
        try {
            String requestURI = request.getRequestURI();
            String filePath = requestURI.substring(requestURI.indexOf("/proxy/") + 7);
            String decodedFileName = URLDecoder.decode(filePath, "UTF-8");
            InputStream inputStream = this.fileManagerHelper.downloadFile(decodedFileName);
            InputStreamResource resource = new InputStreamResource(inputStream);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "inline; filename=" + Paths.get(decodedFileName, new String[0]).getFileName().toString());
            MediaType contentType = this.determineContentType(decodedFileName);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(contentType).body((Object)resource);
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    private MediaType determineContentType(String fileName) {
        try {
            String mimeType = Files.probeContentType(Paths.get(fileName, new String[0]));
            return mimeType != null ? MediaType.parseMediaType((String)mimeType) : MediaType.APPLICATION_OCTET_STREAM;
        }
        catch (Exception e) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }
}

