/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.common.bo.user.UserAccessLogQueryReqBO;
import com.tydic.nicc.csm.utils.LocalCacheSyncHelper;
import com.tydic.nicc.csm.utils.LocalCacheUtil;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.user.api.UserAccessLogService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center/cache"})
public class LocalCacheController {
    private static final Logger log = LoggerFactory.getLogger(LocalCacheController.class);
    @Resource
    private LocalCacheSyncHelper localCacheSyncHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserAccessLogService userAccessLogService;

    @PostMapping(value={"/accessLog/get"})
    public Rsp getAccessLog(@RequestBody UserAccessLogQueryReqBO queryReqBO) {
        return this.userAccessLogService.getAccessLog(queryReqBO);
    }

    @GetMapping(value={"/autoReply/remove/{key}"})
    public Rsp removeAutoReply(@PathVariable(value="key") String key) {
        this.localCacheSyncHelper.clearAutoReplyCache("", key);
        return BaseRspUtils.createSuccessRsp((Object)key);
    }

    @GetMapping(value={"/autoReply/get/{key}"})
    public Rsp getAutoReply(@PathVariable(value="key") String key) {
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            return BaseRspUtils.createSuccessRsp(LocalCacheUtil.AUTO_REPLY.get(key));
        }
        return BaseRspUtils.createSuccessRsp(LocalCacheUtil.AUTO_REPLY);
    }

    @GetMapping(value={"/robotQa/remove/{key}"})
    public Rsp removeRobotQa(@PathVariable(value="key") String key) {
        this.localCacheSyncHelper.clearRobotQaCache("", key);
        return BaseRspUtils.createSuccessRsp((Object)key);
    }

    @GetMapping(value={"/robotQa/get/{key}"})
    public Rsp getRobotQa(@PathVariable(value="key") String key) {
        if ("0".equals(key)) {
            return BaseRspUtils.createSuccessRsp(LocalCacheUtil.ROBOT_QA.get(key));
        }
        return BaseRspUtils.createSuccessRsp(LocalCacheUtil.ROBOT_QA);
    }
}

