/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.common.bo.robot.RobotMessage;
import com.tydic.nicc.common.robot.NiccRobotApi;
import com.tydic.nicc.csm.api.AutoReplyApi;
import com.tydic.nicc.csm.api.bo.autoReply.AutoReplyReqBO;
import com.tydic.nicc.csm.api.bo.autoReply.UpdateAutoReplyReqBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center/robot"})
public class RobotController {
    private static final Logger log = LoggerFactory.getLogger(RobotController.class);
    @Resource
    private NiccRobotApi niccRobotApi;
    @Resource
    private AutoReplyApi autoReplyApi;

    @PostMapping(value={"/message"})
    public Rsp robotMessage(@RequestBody RobotMessage message) {
        return this.niccRobotApi.sendToRobot(message);
    }

    @PostMapping(value={"/message/welcome"})
    public Rsp robotWelcome(@RequestBody RobotMessage message) {
        return this.niccRobotApi.getRobotWelcome(message.getTenantCode(), message.getChannelCode());
    }

    @PostMapping(value={"/autoReply/query"})
    public RspList autoReply(@RequestBody AutoReplyReqBO reqBO) {
        return this.autoReplyApi.autoReply(reqBO);
    }

    @PostMapping(value={"/autoReply/update"})
    public Rsp autoReplyUpdate(@RequestBody UpdateAutoReplyReqBO reqBO) {
        return this.autoReplyApi.updateAutoReply(reqBO);
    }

    @PostMapping(value={"/autoReply/save"})
    public Rsp autoReplySave(@RequestBody AutoReplyReqBO reqBO) {
        return this.autoReplyApi.saveAutoReply(reqBO);
    }

    @PostMapping(value={"/autoReply/del"})
    public Rsp autoReplyDel(@RequestBody AutoReplyReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getId())) {
            return BaseRspUtils.createErrorRsp((String)"id\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getTenantCode())) {
            return BaseRspUtils.createErrorRsp((String)"tenantCode\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getReplyType())) {
            return BaseRspUtils.createErrorRsp((String)"replyType\u4e0d\u5f97\u4e3a\u7a7a");
        }
        return this.autoReplyApi.delAutoReply(reqBO);
    }
}

