/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.csm.utils.SysConfigHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.im.bo.ImSysConfigReqBO;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center/sys"})
public class SysConfigController {
    private static final Logger log = LoggerFactory.getLogger(SysConfigController.class);
    @Resource
    private SysConfigHelper sysConfigHelper;

    @GetMapping(value={"/id/info"})
    public Rsp idInfo() {
        return BaseRspUtils.createSuccessRsp((Object)IdWorker.info());
    }

    @GetMapping(value={"/id/init/{wordId}/{dataId}"})
    public Rsp idInit(@PathVariable(value="wordId") Long workId, @PathVariable(value="dataId") Long dataId) {
        IdWorker.init((long)workId, (long)dataId);
        return BaseRspUtils.createSuccessRsp((Object)IdWorker.info());
    }

    @PostMapping(value={"/configs"})
    public Rsp sysConfig(@RequestBody ImSysConfigReqBO reqBO) {
        Map<String, Object> configs = this.sysConfigHelper.getSysConfig(reqBO.getType());
        return BaseRspUtils.createSuccessRsp(configs);
    }

    @PostMapping(value={"/config/set"})
    public Rsp sysConfigSet(@RequestBody ImSysConfigReqBO reqBO) {
        try {
            Map<String, Object> rspConfigs = this.sysConfigHelper.setSysConfig(reqBO.getType(), reqBO.getProperties());
            return BaseRspUtils.createSuccessRsp(rspConfigs);
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u53c2\u6570\u4fee\u6539\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u7cfb\u7edf\u53c2\u6570\u4fee\u6539\u5f02\u5e38:" + e.getMessage()));
        }
    }
}

