/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.tydic.nicc.common.eums.csm.CsState;
import com.tydic.nicc.csm.api.CsInfoApi;
import com.tydic.nicc.csm.api.bo.cs.CsAccountCreateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoSaveReqBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center/test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private CsInfoApi csInfoApi;

    @PostMapping(value={"/account/gene"})
    private Rsp geneCsAdmin(@RequestBody CsAccountCreateReqBO reqBO) {
        ArrayList<String> csIds = new ArrayList<String>();
        log.info("\u521b\u5efa\u6d4b\u8bd5\u8d26\u53f7-\u5f00\u59cb:{}", (Object)reqBO);
        long start = System.currentTimeMillis();
        for (int i = 100000; i <= 100000 + reqBO.getCount(); ++i) {
            String csCode = reqBO.getCodePrefix() + "_" + i;
            String csName = reqBO.getNamePrefix() + "_" + i;
            CsInfoSaveReqBO csInfoSave = new CsInfoSaveReqBO();
            csInfoSave.setCreateTime(new Date());
            csInfoSave.setCsCode(csCode);
            csInfoSave.setCsName(csName);
            csInfoSave.setNickName(csName);
            csInfoSave.setLoginName(csCode);
            csInfoSave.setTenantCode(reqBO.getTenantCode());
            csInfoSave.setCsState(CsState.NORMAL.getCode());
            csInfoSave.setUpdateTime(new Date());
            csInfoSave.setUpdateUser("admin_test");
            csInfoSave.setCsSkillGroups(reqBO.getCsSkillGroups());
            csInfoSave.setCsLabels(reqBO.getCsLabels());
            csInfoSave.setCsAvatar("http://10.242.37.202:8891/im-files/202201/91287071720869888.jpg");
            Rsp rsp = this.csInfoApi.saveCsInfo(csInfoSave);
            if (!rsp.isSuccess()) continue;
            csIds.add(((CsInfoSaveReqBO)rsp.getData()).getCsId());
        }
        long end = System.currentTimeMillis();
        log.info("\u521b\u5efa\u6d4b\u8bd5\u8d26\u53f7-\u5b8c\u6210:{} \u6761", (Object)csIds.size());
        return BaseRspUtils.createSuccessRsp(csIds, (String)("\u8d26\u53f7\u521b\u5efa\u5b8c\u6210,\u8017\u65f6 " + (end - start) + " ms"));
    }
}

