/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.router.cs;

import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.eums.csm.CsAllotStrategyType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.router.CsAllotRouteService;
import com.tydic.nicc.framework.utils.NiccLinkedList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PollAllotCsRouter
implements CsAllotRouteService {
    private static final Logger log = LoggerFactory.getLogger(PollAllotCsRouter.class);
    private static final Map<String, String> SKILL_LAST_CS_MAP = new HashMap<String, String>();

    public int order() {
        return 1;
    }

    public String strategy() {
        return CsAllotStrategyType.POLL.getCode();
    }

    public RouteAllotRsp handleCsAllotRoute(RouteAllotReq routeAllot, List<CsInfoBO> csInfos) {
        RouteAllotRsp allotRsp = null;
        String lastCsId = this.getLastCs(routeAllot.getAllotSkillGid());
        if (ObjectUtils.anyNotNull((Object[])new Object[]{csInfos}) && !csInfos.isEmpty()) {
            if (csInfos.size() > 1) {
                CsInfoBO csInfo;
                int i;
                NiccLinkedList linkedList = new NiccLinkedList();
                for (i = 0; i < csInfos.size(); ++i) {
                    csInfo = csInfos.get(i);
                    linkedList.add(i, (Object)csInfo);
                }
                for (i = 0; i < csInfos.size(); ++i) {
                    CsInfoBO nextCs;
                    csInfo = csInfos.get(i);
                    if (!csInfo.getCsId().equals(lastCsId)) continue;
                    if (i == csInfos.size() - 1) {
                        nextCs = csInfos.get(0);
                        this.putLastCs(routeAllot.getAllotSkillGid(), nextCs.getCsId());
                        allotRsp = this.processOne(nextCs);
                        continue;
                    }
                    nextCs = csInfos.get(i + 1);
                    this.putLastCs(routeAllot.getAllotSkillGid(), nextCs.getCsId());
                    allotRsp = this.processOne(nextCs);
                }
            } else {
                CsInfoBO nextCs = csInfos.get(0);
                this.putLastCs(routeAllot.getAllotSkillGid(), nextCs.getCsId());
                allotRsp = this.processOne(nextCs);
            }
            if (ObjectUtils.anyNotNull((Object[])new Object[]{allotRsp})) {
                if (StringUtils.isNotEmpty((CharSequence)routeAllot.getTransferFromCsId())) {
                    log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d(\u8f6e\u8bad)-\u8f6e\u8be2\u7b56\u7565\u5206\u914d\u5ba2\u670d\u6210\u529f(\u8f6c\u63a5\u5ba2\u670d):{},LAST_CS_ID = {}", (Object)allotRsp, (Object)lastCsId);
                } else {
                    log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d(\u8f6e\u8bad)-\u8f6e\u8be2\u7b56\u7565\u5206\u914d\u5ba2\u670d\u6210\u529f:{},LAST_CS_ID = {}", (Object)allotRsp, (Object)lastCsId);
                }
                return allotRsp;
            }
        }
        return RouteAllotRsp.builder().match(false).build();
    }

    private RouteAllotRsp processOne(CsInfoBO nextCs) {
        AllotCsInfo allotCsInfo = new AllotCsInfo();
        BeanUtils.copyProperties((Object)nextCs, (Object)allotCsInfo);
        return RouteAllotRsp.builder().match(true).allotCsInfo(allotCsInfo).allotUserType(UserTypeField.COMP_USER.getCode()).build();
    }

    private void putLastCs(String skillGid, String csId) {
        SKILL_LAST_CS_MAP.put(skillGid, csId);
    }

    private String getLastCs(String skillGid) {
        String csId = SKILL_LAST_CS_MAP.get(skillGid);
        if (StringUtils.isEmpty((CharSequence)csId)) {
            return "";
        }
        return csId;
    }
}

