/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.router.cs;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.eums.csm.CsAllotStrategyType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.router.CsAllotRouteService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PriorityCsRouter
implements CsAllotRouteService {
    private static final Logger log = LoggerFactory.getLogger(PriorityCsRouter.class);
    private static final Map<String, String> SKILL_LAST_CS_MAP = new HashMap<String, String>();

    public int order() {
        return 3;
    }

    public String strategy() {
        return CsAllotStrategyType.PRIORITY.getCode();
    }

    public RouteAllotRsp handleCsAllotRoute(RouteAllotReq routeAllot, List<CsInfoBO> csInfos) {
        List<CsInfoBO> freeCsInfos = csInfos.stream().sorted(Comparator.comparing(CsInfoBO::getPriority).thenComparingDouble(CsInfoBO::getSaturationRate)).collect(Collectors.toList());
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d(\u4f18\u5148\u7ea7)-\u6309\u4f18\u5148\u7ea7\u6392\u5e8f:{}", JSONObject.toJSON(freeCsInfos));
        if (!freeCsInfos.isEmpty()) {
            AllotCsInfo allotCsInfo = new AllotCsInfo();
            CsInfoBO csInfo = this.parseRandom(freeCsInfos, routeAllot.getAllotSkillGid());
            BeanUtils.copyProperties((Object)csInfo, (Object)allotCsInfo);
            return RouteAllotRsp.builder().match(true).allotCsInfo(allotCsInfo).allotUserType(UserTypeField.COMP_USER.getCode()).build();
        }
        return RouteAllotRsp.builder().match(false).build();
    }

    private CsInfoBO parseRandom(List<CsInfoBO> freeCsInfos, String skillGid) {
        CsInfoBO first = freeCsInfos.get(0);
        double saturationRate = first.getSaturationRate();
        int idx = 0;
        for (int i = 1; i < freeCsInfos.size(); ++i) {
            CsInfoBO freeCsInfo = freeCsInfos.get(i);
            if (freeCsInfo.getSaturationRate() == saturationRate) continue;
            idx = i;
            break;
        }
        if (idx > 1) {
            freeCsInfos = freeCsInfos.subList(0, idx);
            String lastCsId = SKILL_LAST_CS_MAP.get(skillGid);
            freeCsInfos = freeCsInfos.stream().filter(obj -> !obj.getCsId().equals(lastCsId)).collect(Collectors.toList());
            int index = PriorityCsRouter.getRandom(0, freeCsInfos.size());
            if (freeCsInfos.size() > 0) {
                first = (CsInfoBO)freeCsInfos.get(index);
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d(\u4f18\u5148\u7ea7)-\u6309\u4f18\u5148\u7ea7\u6392\u5e8f-\u968f\u673a\u83b7\u53d6:{} -> {}, \u4e0a\u6b21\u5206\u914d: {}", new Object[]{index, first.getCsId(), lastCsId});
                SKILL_LAST_CS_MAP.put(skillGid, first.getCsId());
            }
        }
        return first;
    }

    public static int getRandom(int min, int max) {
        if (max == 0) {
            return 0;
        }
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }
}

