/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.router.cs;

import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.eums.csm.CsAllotStrategyType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.router.CsAllotRouteService;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class RandomAllotCsRouter
implements CsAllotRouteService {
    private static final Logger log = LoggerFactory.getLogger(RandomAllotCsRouter.class);

    public int order() {
        return 2;
    }

    public String strategy() {
        return CsAllotStrategyType.RANDOM.getCode();
    }

    public RouteAllotRsp handleCsAllotRoute(RouteAllotReq routeAllot, List<CsInfoBO> csInfos) {
        RouteAllotRsp allotRsp = null;
        AllotCsInfo allotCsInfo = new AllotCsInfo();
        List<CsInfoBO> freeCsInfos = csInfos;
        if (!freeCsInfos.isEmpty()) {
            CsInfoBO csInfoBO;
            if (freeCsInfos.size() == 1) {
                csInfoBO = freeCsInfos.get(0);
            } else {
                int index = RandomAllotCsRouter.getRandom(0, freeCsInfos.size());
                csInfoBO = freeCsInfos.get(index);
            }
            BeanUtils.copyProperties((Object)csInfoBO, (Object)allotCsInfo);
            allotRsp = RouteAllotRsp.builder().match(true).allotCsInfo(allotCsInfo).allotUserType(UserTypeField.COMP_USER.getCode()).build();
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d(\u968f\u673a)-\u968f\u673a\u7b56\u7565\u5206\u914d\u5ba2\u670d\u6210\u529f:{}", (Object)allotRsp);
            return allotRsp;
        }
        return RouteAllotRsp.builder().match(false).build();
    }

    public static int getRandom(int min, int max) {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }
}

