/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.router.cs;

import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.eums.csm.CsAllotStrategyType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.router.CsAllotRouteService;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.framework.utils.AmountUtil;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SaturationAllotCsRouter
implements CsAllotRouteService {
    private static final Logger log = LoggerFactory.getLogger(SaturationAllotCsRouter.class);
    @Resource
    private CsmCommonService csmCommonService;

    public int order() {
        return 0;
    }

    public String strategy() {
        return CsAllotStrategyType.SATURATION.getCode();
    }

    public RouteAllotRsp handleCsAllotRoute(RouteAllotReq routeAllot, List<CsInfoBO> csInfos) {
        AllotCsInfo allotCsInfo = new AllotCsInfo();
        List freeCsInfos = StringUtils.isNotEmpty((CharSequence)routeAllot.getTransferFromCsId()) ? csInfos.stream().filter(cs -> {
            int receiveCount = this.csmCommonService.receivingCount(routeAllot.getTenantCode(), cs.getCsId());
            cs.setSaturationRate(AmountUtil.div((double)receiveCount, (double)cs.getReceiveLimit().intValue()));
            return true;
        }).sorted(Comparator.comparingDouble(CsInfoBO::getSaturationRate).thenComparing(CsInfoBO::getPriority)).collect(Collectors.toList()) : csInfos.stream().sorted(Comparator.comparingDouble(CsInfoBO::getSaturationRate).thenComparing(CsInfoBO::getPriority)).collect(Collectors.toList());
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d(\u9971\u548c\u5ea6)-\u6309\u9971\u548c\u5ea6\u6392\u5e8f\u7ed3\u679c:{}", freeCsInfos);
        if (!freeCsInfos.isEmpty()) {
            CsInfoBO csInfoBO = (CsInfoBO)freeCsInfos.get(0);
            BeanUtils.copyProperties((Object)csInfoBO, (Object)allotCsInfo);
            RouteAllotRsp allotRsp = RouteAllotRsp.builder().match(true).allotCsInfo(allotCsInfo).allotUserType(UserTypeField.COMP_USER.getCode()).build();
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d(\u9971\u548c\u5ea6)-\u5206\u914d\u5ba2\u670d\u6210\u529f:{}", (Object)allotRsp);
            return allotRsp;
        }
        return RouteAllotRsp.builder().match(false).build();
    }
}

