/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.router.handler;

import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FrequentAllotRuleHandler {
    private static final Logger log = LoggerFactory.getLogger(FrequentAllotRuleHandler.class);
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;

    public String getUserFrequentCs(String tenantCode, String skillGid, String userId) {
        String csId = this.csmCommonService.getRecentlyServiceCsId(tenantCode, skillGid, userId, this.niccCsmConfigProperties.getFrequentAllotMinutes());
        return csId;
    }

    public RouteAllotRsp allotByFrequent(RouteAllotReq routeAllot, List<CsInfoBO> csInfos) {
        List frequentCsList;
        String csId = this.getUserFrequentCs(routeAllot.getTenantCode(), routeAllot.getAllotSkillGid(), routeAllot.getUserId());
        log.info("\u6839\u636e\u719f\u5ba2\u5339\u914d:routeAllot = {}, csId = {}", (Object)routeAllot, (Object)csId);
        if (StringUtils.isNotEmpty((CharSequence)csId) && !(frequentCsList = csInfos.stream().filter(cs -> cs.getCsId().equals(csId)).collect(Collectors.toList())).isEmpty()) {
            AllotCsInfo allotCsInfo = new AllotCsInfo();
            BeanUtils.copyProperties(frequentCsList.get(0), (Object)allotCsInfo);
            RouteAllotRsp routeAllotRsp = RouteAllotRsp.builder().match(true).allotStrategy(routeAllot.getAllotStrategy()).allotSkillGid(routeAllot.getAllotSkillGid()).allotCsInfo(allotCsInfo).allotUserType(UserTypeField.COMP_USER.getCode()).build();
            log.info("\u6839\u636e\u719f\u5ba2\u5339\u914d,\u5206\u914d\u5230\u5ba2\u670d: {}", (Object)routeAllotRsp);
            return routeAllotRsp;
        }
        return RouteAllotRsp.builder().match(false).allotUserType(UserTypeField.COMP_USER.getCode()).build();
    }
}

