/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.router.skill.dicProduct;

import com.tydic.nicc.common.bo.csm.SkillGroupRouteReq;
import com.tydic.nicc.common.bo.csm.SkillGroupRouteRsp;
import com.tydic.nicc.common.eums.SystemCommonPropKey;
import com.tydic.nicc.common.eums.csm.CsRouteExceptionDefine;
import com.tydic.nicc.common.eums.csm.CsSkillGroupType;
import com.tydic.nicc.csm.api.CsChannelManageApi;
import com.tydic.nicc.csm.api.bo.channel.CsChannelQueryReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.api.router.SkillGroupRouteService;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.exception.CsRouteException;
import com.tydic.nicc.csm.utils.AutoReplyNoticeHelper;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.im.core.api.ImMessageService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MatchDefaultSkillGroupRouter
implements SkillGroupRouteService {
    private static final Logger log = LoggerFactory.getLogger(MatchDefaultSkillGroupRouter.class);
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsChannelManageApi csChannelManageApi;
    @Resource
    private AutoReplyNoticeHelper autoReplyNoticeHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;

    public int order() {
        return -1;
    }

    public SkillGroupRouteRsp handleSkillGroupRoute(SkillGroupRouteReq skillGroupRoute) {
        log.info("\u6280\u80fd\u7ec4\u8def\u7531-\u6839\u636e\u6e20\u9053\u5339\u914d\u6280\u80fd\u7ec4-\u53c2\u6570:{}", (Object)skillGroupRoute);
        CsChannelQueryReqBO queryReqBO = new CsChannelQueryReqBO();
        queryReqBO.setTenantCode(skillGroupRoute.getTenantCode());
        queryReqBO.setChannelCode(skillGroupRoute.getChannelCode());
        RspList rspList = this.csChannelManageApi.getSkillsByChannel(queryReqBO);
        List skills = rspList.getRows();
        CsSkillGroupBO choseSkill = null;
        if (!skills.isEmpty()) {
            if (skills.size() > 1) {
                if (StringUtils.isNotBlank((CharSequence)skillGroupRoute.getImRequestId())) {
                    Map<String, Object> userRequestData = this.csmCommonService.loadFormDataByRequestId(skillGroupRoute.getImRequestId());
                    String skillGid = (String)userRequestData.get(SystemCommonPropKey.skillGid.name());
                    List filterSkills = skills.stream().filter(obj -> obj.getSkillGid().equals(skillGid)).collect(Collectors.toList());
                    if (!filterSkills.isEmpty()) {
                        choseSkill = (CsSkillGroupBO)filterSkills.get(0);
                    }
                }
                if (choseSkill == null) {
                    this.autoReplyNoticeHelper.pushSysSkillChooseNotice(skillGroupRoute, skills);
                    return SkillGroupRouteRsp.builder().match(false).allotDeny(true).build();
                }
            } else {
                choseSkill = (CsSkillGroupBO)skills.get(0);
            }
            log.info("\u6280\u80fd\u7ec4\u8def\u7531-\u6839\u636e\u6e20\u9053\u5339\u914d\u6280\u80fd\u7ec4-\u5339\u914d\u7ed3\u679c:{}", (Object)choseSkill);
            if (choseSkill != null) {
                return SkillGroupRouteRsp.builder().match(true).skillType(CsSkillGroupType.ONLINE.getIntCode()).skillGid(choseSkill.getSkillGid()).allotStrategy(choseSkill.getAllotStrategy()).build();
            }
        }
        throw new CsRouteException(CsRouteExceptionDefine.NO_DEFAULT_SKILL);
    }
}

