/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.SystemModelType;
import com.tydic.nicc.common.eums.csm.CsAutoReplyConfigLevel;
import com.tydic.nicc.common.eums.csm.CsWorkScheduleLevel;
import com.tydic.nicc.csm.api.AutoReplyApi;
import com.tydic.nicc.csm.api.bo.autoReply.AutoReplyReqBO;
import com.tydic.nicc.csm.api.bo.autoReply.UpdateAutoReplyReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigQueryReqBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.mapper.CsAutoReplyConfigMapper;
import com.tydic.nicc.csm.mapper.po.CsAutoReplyConfig;
import com.tydic.nicc.csm.service.impl.CsWorkScheduleServiceImpl;
import com.tydic.nicc.csm.utils.LocalCacheSyncHelper;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AutoReplyServiceImpl
implements AutoReplyApi {
    private static final Logger log = LoggerFactory.getLogger(AutoReplyServiceImpl.class);
    @Autowired
    private CsmCommonService csmCommonService;
    @Autowired
    private CsWorkScheduleServiceImpl csWorkScheduleService;
    @Resource
    private CsAutoReplyConfigMapper csAutoReplyConfigMapper;
    @Resource
    private LocalCacheSyncHelper localCacheSyncHelper;

    @MethodParamVerifyEnable
    @Transactional
    public Rsp saveAutoReply(AutoReplyReqBO reqBO) {
        log.info("\u81ea\u52a8\u5e94\u7b54\u8bed-\u4fdd\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        CsAutoReplyConfig po = new CsAutoReplyConfig();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (CsWorkScheduleLevel.TENANT.getCode().equals(reqBO.getConfigLevel())) {
            reqBO.setConfigLevelValList(Collections.singletonList(reqBO.getTenantCode()));
        }
        String key = RedisCacheKeyConstant.getCsmAutoReplyConfigKey((String)reqBO.getTenantCode(), (String)reqBO.getReplyType());
        this.localCacheSyncHelper.clearAutoReplyCache(reqBO.getTenantCode(), key);
        for (String levelVal : reqBO.getConfigLevelValList()) {
            po.setId(Long.valueOf(IdWorker.nextAutoId()));
            po.setConfigLevelVal(levelVal);
            this.csAutoReplyConfigMapper.insertSelective(po);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    @MethodParamVerifyEnable
    public Rsp updateAutoReply(UpdateAutoReplyReqBO reqBO) {
        log.info("\u81ea\u52a8\u5e94\u7b54\u8bed-\u66f4\u65b0\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        CsAutoReplyConfig po = new CsAutoReplyConfig();
        if (CsWorkScheduleLevel.TENANT.getCode().equals(reqBO.getConfigLevel())) {
            reqBO.setConfigLevelVal(reqBO.getTenantCode());
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        String key = RedisCacheKeyConstant.getCsmAutoReplyConfigKey((String)reqBO.getTenantCode(), (String)reqBO.getReplyType());
        this.localCacheSyncHelper.clearAutoReplyCache(reqBO.getTenantCode(), key);
        int i = this.csAutoReplyConfigMapper.updateSelectiveByCondition(po);
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25");
    }

    public RspList autoReply(AutoReplyReqBO reqBO) {
        log.info("\u81ea\u52a8\u5e94\u7b54\u8bed-\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        CsAutoReplyConfigQueryReqBO queryBO = new CsAutoReplyConfigQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryBO);
        RspList<CsAutoReplyConfigBO> csAutoReplyConfigs = this.csmCommonService.getCsAutoReplyConfigs(queryBO);
        if (!csAutoReplyConfigs.isSuccess()) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u81ea\u52a8\u5e94\u7b54");
        }
        for (CsAutoReplyConfigBO cell : csAutoReplyConfigs.getRows()) {
            if (CsWorkScheduleLevel.CHANNEL.matchCode(cell.getConfigLevel())) {
                reqBO.setTenantCode(SystemModelType.PLATFORM.getCode());
            }
            String scheduleObjName = this.csWorkScheduleService.getScheduleObjName(reqBO.getTenantCode(), cell.getConfigLevel(), cell.getConfigLevelVal());
            cell.setConfigLevelValName(scheduleObjName);
            cell.setConfigLevelName(CsAutoReplyConfigLevel.getNameByCode((String)cell.getConfigLevel()));
        }
        return csAutoReplyConfigs;
    }

    public Rsp delAutoReply(AutoReplyReqBO reqBO) {
        log.info("\u81ea\u52a8\u5e94\u7b54\u8bed-\u5220\u9664\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        RspList rspList = this.autoReply(reqBO);
        if (!rspList.isSuccess()) {
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u81ea\u52a8\u5e94\u7b54\u5931\u8d25");
        }
        if (rspList.getRows().size() <= 1) {
            return BaseRspUtils.createErrorRsp(null, (String)"\u81ea\u52a8\u5e94\u7b54\u6570\u91cf\u5c11\u4e8e\u7b49\u4e8e1\u6761\uff0c\u4e0d\u5f97\u5220\u9664");
        }
        String key = RedisCacheKeyConstant.getCsmAutoReplyConfigKey((String)reqBO.getTenantCode(), (String)reqBO.getReplyType());
        this.localCacheSyncHelper.clearAutoReplyCache(reqBO.getTenantCode(), key);
        int i = this.csAutoReplyConfigMapper.deleteById(reqBO.getId());
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5e38\u7528\u8bed\u5931\u8d25");
    }
}

