/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.exception.DataSyncException;
import com.tydic.nicc.csm.api.CommonFormDataApi;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormConfigQueryReqBO;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormDataBO;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormDataQueryReqBO;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormDataSaveReqBO;
import com.tydic.nicc.csm.api.bo.formdata.CsEvalQueryReqBO;
import com.tydic.nicc.csm.mapper.FCommonFormConfigMapper;
import com.tydic.nicc.csm.mapper.FCommonTableDataMapper;
import com.tydic.nicc.csm.mapper.po.CsEval;
import com.tydic.nicc.csm.mapper.po.FCommonFormConfig;
import com.tydic.nicc.csm.mapper.po.FCommonTableData;
import com.tydic.nicc.csm.utils.CommonFormDataDriverHelper;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

@DS(value="nicc-csm")
@Service
public class CommonFormDataImplServiceImpl
implements CommonFormDataApi {
    private static final Logger log = LoggerFactory.getLogger(CommonFormDataImplServiceImpl.class);
    @Resource
    private FCommonTableDataMapper fCommonTableDataMapper;
    @Resource
    private CommonFormDataDriverHelper commonFormDataDriverHelper;
    @Resource
    private FCommonFormConfigMapper fCommonFormConfigMapper;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Resource
    private TransactionDefinition transactionDefinition;

    @MethodParamVerifyEnable
    public RspList getCommonFormDataCondition(CommonFormDataQueryReqBO reqBO) {
        FCommonFormConfig fCommonFormConfig;
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{reqBO.getConditions()})) {
            reqBO.setConditions(new HashMap());
        }
        Map conditions = reqBO.getConditions();
        Integer page = (Integer)conditions.get("page");
        Integer limit = (Integer)conditions.get("limit");
        if (page == null) {
            conditions.put("page", 1);
        }
        if (limit == null) {
            conditions.put("limit", 10);
        }
        if ((fCommonFormConfig = this.fCommonFormConfigMapper.selectByFormCode(reqBO.getTenantCode(), reqBO.getFormCode())) != null) {
            reqBO.setConditions(conditions);
            log.info("\u67e5\u8be2\u901a\u7528\u8868\u5355\u6570\u636e:{}", (Object)reqBO);
            return this.commonFormDataDriverHelper.commonTableQuery(reqBO);
        }
        return BaseRspUtils.createErrorRspList((String)("\u8868\u5355\u914d\u7f6e\u4e0d\u5b58\u5728:formCode = " + reqBO.getFormCode()));
    }

    @MethodParamVerifyEnable
    public Rsp saveCommonFormData(CommonFormDataSaveReqBO saveReqBO) {
        log.info("\u4fdd\u5b58\u901a\u7528\u8868\u5355\u6570\u636e:{}", (Object)saveReqBO);
        saveReqBO.setCrtTime(new Date());
        saveReqBO.setLastUpdTime(new Date());
        FCommonTableData record = new FCommonTableData();
        int update = 0;
        if (saveReqBO.getId() == null) {
            saveReqBO.setId(Long.valueOf(IdWorker.nextAutoId()));
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getContent())) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u586b\u5199\u8868\u5355\u5185\u5bb9");
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getFormCode())) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u586b\u5199\u8868\u5355\u7f16\u7801");
            }
            String formContent = saveReqBO.getContent();
            boolean isJson = JSONValidator.from((String)formContent).validate();
            if (isJson) {
                TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
                JSONObject formData = JSONObject.parseObject((String)formContent);
                formData.put("tenantCode", (Object)saveReqBO.getTenantCode());
                if (StringUtils.isEmpty((CharSequence)formData.getString("userId"))) {
                    formData.put("userId", (Object)saveReqBO.getUserId());
                }
                formData.put("itemId", (Object)saveReqBO.getItemId());
                formData.put("crtTime", (Object)DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                saveReqBO.setContent(formData.toJSONString());
                BeanUtils.copyProperties((Object)saveReqBO, (Object)record);
                update = this.fCommonTableDataMapper.insertSelective(record);
                if (update > 0) {
                    try {
                        CommonFormDataBO dataBO = new CommonFormDataBO();
                        BeanUtils.copyProperties((Object)saveReqBO, (Object)dataBO);
                        dataBO.setFormData(formData);
                        this.commonFormDataDriverHelper.commonTableDataAnalysis(dataBO);
                        this.dataSourceTransactionManager.commit(transactionStatus);
                        return BaseRspUtils.createSuccessRsp((Object)saveReqBO, (String)"\u4fdd\u5b58\u6210\u529f");
                    }
                    catch (DataSyncException e1) {
                        log.error("\u901a\u7528\u8868\u5355\u89e3\u6790\u4fdd\u5b58-\u6570\u636e\u540c\u6b65\u5f02\u5e38:{}", (Object)e1.getMessage());
                        this.dataSourceTransactionManager.rollback(transactionStatus);
                        return BaseRspUtils.createErrorRsp((String)e1.getErrorCode(), (String)e1.getMessage());
                    }
                    catch (Exception e) {
                        log.error("\u901a\u7528\u8868\u5355\u89e3\u6790\u4fdd\u5b58-\u9519\u8bef:{}", (Object)e.getMessage());
                        this.dataSourceTransactionManager.rollback(transactionStatus);
                        return BaseRspUtils.createErrorRsp((String)"\u6570\u636e\u63d0\u4ea4\u5931\u8d25:\u6570\u636e\u683c\u5f0f\u5f02\u5e38!");
                    }
                }
                return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25");
            }
            return BaseRspUtils.createErrorRsp((String)"\u6570\u636e\u63d0\u4ea4\u5931\u8d25:\u6570\u636e\u683c\u5f0f\u5f02\u5e38!");
        }
        BeanUtils.copyProperties((Object)saveReqBO, (Object)record);
        this.fCommonTableDataMapper.updateByPrimaryKeySelective(record);
        return BaseRspUtils.createSuccessRsp((Object)saveReqBO, (String)"\u66f4\u65b0\u6210\u529f");
    }

    public Rsp getCommonFormData(CommonFormDataQueryReqBO queryReqBO) {
        return null;
    }

    @MethodParamVerifyEnable
    public Rsp getCommonFormConfig(CommonFormConfigQueryReqBO queryReqBO) {
        FCommonFormConfig fCommonFormConfig;
        log.info("\u67e5\u8be2\u901a\u7528\u8868\u5355\u914d\u7f6e:{}", (Object)queryReqBO);
        String key = RedisCacheKeyConstant.getCsmCommonFormConfigCacheKey((String)queryReqBO.getTenantCode(), (String)queryReqBO.getFormCode());
        String formConfig = (String)this.redisHelper.get(key);
        if (StringUtils.isEmpty((CharSequence)formConfig) && (fCommonFormConfig = this.fCommonFormConfigMapper.selectByFormCode(queryReqBO.getTenantCode(), queryReqBO.getFormCode())) != null) {
            formConfig = fCommonFormConfig.getFormContent();
        }
        if (StringUtils.isNotEmpty((CharSequence)formConfig)) {
            boolean checkJson = JSONValidator.from((String)formConfig).validate();
            if (checkJson) {
                JSONObject jsonConfig = JSONObject.parseObject((String)formConfig);
                this.redisHelper.set(key, (Object)formConfig, (long)RedisCacheKeyConstant.ONE_DAY.intValue());
                return BaseRspUtils.createSuccessRsp((Object)jsonConfig);
            }
            log.error("\u67e5\u8be2\u901a\u7528\u8868\u5355\u914d\u7f6e:json\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5\u914d\u7f6e\u8868 content = {}", (Object)formConfig);
            return BaseRspUtils.createErrorRsp((String)("\u67e5\u8be2\u901a\u7528\u8868\u5355\u914d\u7f6e:json\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5\u914d\u7f6e\u8868 content = " + formConfig));
        }
        return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8868\u5355\u914d\u7f6e!");
    }

    @MethodParamVerifyEnable
    public Rsp getLeastCsEval(CsEvalQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u5ba2\u670d\u8bc4\u4f30\u8bb0\u5f55:{}", (Object)queryReqBO);
        CsEval csEval = this.fCommonTableDataMapper.selectLeastCsEval(queryReqBO.getTenantCode(), queryReqBO.getSessionId(), queryReqBO.getCsId());
        if (ObjectUtils.allNotNull((Object[])new Object[]{csEval})) {
            return BaseRspUtils.createSuccessRsp((Object)csEval);
        }
        return BaseRspUtils.createSuccessRsp(null, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
    }
}

