/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.common.eums.csm.CsAllotJoinType;
import com.tydic.nicc.csm.api.CsAllotOrTransferApi;
import com.tydic.nicc.csm.api.bo.cs.CsAllotAllotOrTransferBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotAllotOrTransferReqBO;
import com.tydic.nicc.csm.mapper.CsAllotRecordMapper;
import com.tydic.nicc.csm.mapper.CsAllotTransferRecordMapper;
import com.tydic.nicc.csm.mapper.CsSkillGroupMapper;
import com.tydic.nicc.csm.mapper.po.CsAllotRecord;
import com.tydic.nicc.csm.mapper.po.CsAllotTransferRecord;
import com.tydic.nicc.csm.mapper.po.CsSkillGroup;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@DS(value="nicc-csm")
@Service
public class CsAllotOrTransferServiceImpl
implements CsAllotOrTransferApi {
    private static final Logger log = LoggerFactory.getLogger(CsAllotOrTransferServiceImpl.class);
    @Resource
    private CsAllotRecordMapper csAllotRecordMapper;
    @Resource
    private CsAllotTransferRecordMapper csAllotTransferRecordMapper;
    @Resource
    private CsSkillGroupMapper skillGroupMapper;

    public Rsp getCsAllotOrTransferRecord(CsAllotAllotOrTransferReqBO reqBO) {
        log.info("\u67e5\u8be2\u5ba2\u670d\u8f6c\u63a5/\u5206\u914d\u8bb0\u5f55-\u5165\u53c2:{}", (Object)reqBO);
        if (StringUtils.isEmpty((CharSequence)reqBO.getCsId())) {
            return BaseRspUtils.createErrorRsp((String)"\u5ba2\u670did\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{reqBO.getSessionId(), reqBO.getUserId()})) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u4f20\u5165sessionId\u6216userId!");
        }
        CsAllotAllotOrTransferBO transferBO = null;
        CsAllotRecord allotRecord = this.csAllotRecordMapper.selectLeastAllot(reqBO.getTenantCode(), reqBO.getSessionId(), reqBO.getCsId(), reqBO.getUserId());
        if (allotRecord != null) {
            transferBO = new CsAllotAllotOrTransferBO();
            BeanUtils.copyProperties((Object)allotRecord, (Object)transferBO);
            transferBO.setServiceStartTime(allotRecord.getAllotEndTime());
            transferBO.setJoinType(CsAllotJoinType.ALLOT.getCode());
        }
        CsAllotAllotOrTransferBO transferBO2 = null;
        CsAllotTransferRecord transferRecord = this.csAllotTransferRecordMapper.selectLeastTransAllot(reqBO.getTenantCode(), reqBO.getSessionId(), reqBO.getCsId(), reqBO.getUserId());
        if (transferRecord != null) {
            transferBO2 = new CsAllotAllotOrTransferBO();
            BeanUtils.copyProperties((Object)transferRecord, (Object)transferBO2);
            transferBO2.setServiceStartTime(transferRecord.getTransferTime());
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{transferBO, transferBO2})) {
            if (transferBO.getServiceStartTime().getTime() > transferBO2.getServiceStartTime().getTime()) {
                transferBO.setAllotSkillName(this.getSkillName(transferBO.getAllotSkillGid()));
                return BaseRspUtils.createSuccessRsp((Object)transferBO);
            }
            transferBO2.setAllotSkillName(this.getSkillName(transferBO2.getAllotSkillGid()));
            return BaseRspUtils.createSuccessRsp((Object)transferBO2);
        }
        if (transferBO != null) {
            transferBO.setAllotSkillName(this.getSkillName(transferBO.getAllotSkillGid()));
            return BaseRspUtils.createSuccessRsp((Object)transferBO);
        }
        if (transferBO2 != null) {
            transferBO2.setAllotSkillName(this.getSkillName(transferBO2.getAllotSkillGid()));
            return BaseRspUtils.createSuccessRsp((Object)transferBO2);
        }
        log.warn("\u67e5\u8be2\u5ba2\u670d\u8f6c\u63a5/\u5206\u914d\u8bb0\u5f55-\u67e5\u8be2\u5931\u8d25:{}", (Object)reqBO);
        return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5ba2\u670d\u8f6c\u63a5/\u5206\u914d\u8bb0\u5f55\u4e3a\u7a7a!");
    }

    private String getSkillName(String skillId) {
        CsSkillGroup skillGroup = this.skillGroupMapper.selectByPrimaryKey(skillId);
        if (skillGroup != null) {
            return skillGroup.getSkillGroupName();
        }
        return "";
    }
}

