/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.csm.api.CsBannerContentApi;
import com.tydic.nicc.csm.api.bo.banner.CsBannerContentBO;
import com.tydic.nicc.csm.api.bo.banner.CsBannerContentQueryReqBO;
import com.tydic.nicc.csm.api.bo.banner.CsBannerContentSaveReqBO;
import com.tydic.nicc.csm.mapper.CsBannerContentMapper;
import com.tydic.nicc.csm.mapper.po.CsBannerContent;
import com.tydic.nicc.csm.mapper.po.CsBannerContentQueryCondition;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-csm")
@Service
public class CsBannerContentServiceImpl
implements CsBannerContentApi {
    private static final Logger log = LoggerFactory.getLogger(CsBannerContentServiceImpl.class);
    @Resource
    private CsBannerContentMapper csBannerContentMapper;

    @MethodParamVerifyEnable
    @Transactional
    public Rsp<CsBannerContentBO> saveBannerContent(CsBannerContentSaveReqBO saveReqBO) {
        saveReqBO.setLastUpdTime(new Date());
        log.info("\u4fdd\u5b58\u5e7f\u544a\u4f4d\u914d\u7f6e\u4fe1\u606f:{}", (Object)saveReqBO);
        CsBannerContent record = new CsBannerContent();
        BeanUtils.copyProperties((Object)saveReqBO, (Object)record);
        int update = 0;
        if (saveReqBO.getId() != null) {
            record.setLastUpdTime(new Date());
            update = this.csBannerContentMapper.updateSelectiveByPrimaryKey(record);
        } else {
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getBannerCode())) {
                return BaseRspUtils.createErrorRsp((String)"bannerCode\u4e0d\u5f97\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getBannerType())) {
                return BaseRspUtils.createErrorRsp((String)"bannerType\u4e0d\u5f97\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getBannerContent())) {
                return BaseRspUtils.createErrorRsp((String)"bannerContent\u4e0d\u5f97\u4e3a\u7a7a");
            }
            record.setId(Long.valueOf(IdWorker.nextAutoId()));
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getIsValid())) {
                record.setIsValid(EntityValidType.NORMAL.getCode());
            }
            record.setLastUpdTime(new Date());
            update = this.csBannerContentMapper.insertSelective(record);
        }
        if (update > 0) {
            Rsp<CsBannerContentBO> rsp = this.getBannerContentById(String.valueOf(record.getId()));
            return BaseRspUtils.createSuccessRsp((Object)rsp.getData(), (String)"\u4fdd\u5b58\u6210\u529f!");
        }
        return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @MethodParamVerifyEnable
    public RspList<CsBannerContentBO> getBannerContents(CsBannerContentQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868:{}", (Object)queryReqBO);
        ArrayList list = Lists.newArrayList();
        CsBannerContentQueryCondition condition = new CsBannerContentQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.csBannerContentMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), (List)list, CsBannerContentBO.class);
        }
        return BaseRspUtils.createSuccessRspList((List)list);
    }

    public Rsp<CsBannerContentBO> getBannerContentById(String id) {
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            CsBannerContent csBannerContent = this.csBannerContentMapper.selectById(Long.valueOf(id));
            if (ObjectUtils.anyNotNull((Object[])new Object[]{csBannerContent})) {
                CsBannerContentBO csBannerContentBO = new CsBannerContentBO();
                BeanUtils.copyProperties((Object)csBannerContent, (Object)csBannerContentBO);
                return BaseRspUtils.createSuccessRsp((Object)csBannerContentBO);
            }
        }
        return BaseRspUtils.createErrorRsp((String)("\u67e5\u8be2\u5931\u8d25: id = " + id));
    }
}

