/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.csm.api.CsChannelManageApi;
import com.tydic.nicc.csm.api.bo.channel.CsBindChannelSkillReqBO;
import com.tydic.nicc.csm.api.bo.channel.CsChannelBO;
import com.tydic.nicc.csm.api.bo.channel.CsChannelQueryReqBO;
import com.tydic.nicc.csm.api.bo.channel.CsChannelSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsChannelMapper;
import com.tydic.nicc.csm.mapper.CsSkillChannelRelMapper;
import com.tydic.nicc.csm.mapper.po.CsChannel;
import com.tydic.nicc.csm.mapper.po.CsSkillChannelRel;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@DS(value="nicc-csm")
@Service
public class CsChannelManageServiceImpl
implements CsChannelManageApi {
    private static final Logger log = LoggerFactory.getLogger(CsChannelManageServiceImpl.class);
    @Resource
    private CsChannelMapper csChannelMapper;
    @Resource
    private CsSkillChannelRelMapper csSkillChannelRelMapper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;

    @MethodParamVerifyEnable
    public Rsp saveChannel(CsChannelSaveReqBO saveReqBO) {
        log.info("\u6e20\u9053\u7ba1\u7406-\u4fdd\u5b58\u6e20\u9053\u4fe1\u606f:{}", (Object)saveReqBO);
        CsChannel channel = this.csChannelMapper.selectByPrimaryKey(saveReqBO.getId());
        CsChannel csChannel = new CsChannel();
        CsBindChannelSkillReqBO bindChannelSkillReqBO = new CsBindChannelSkillReqBO();
        bindChannelSkillReqBO.setTenantCode(saveReqBO.getTenantCode());
        bindChannelSkillReqBO.setSkillGids(saveReqBO.getSkillGids());
        bindChannelSkillReqBO.setChannelCode(saveReqBO.getChannelCode());
        if (channel != null) {
            csChannel.setId(channel.getId());
            csChannel.setUpdateTime(new Date());
            csChannel.setChannelName(saveReqBO.getChannelName());
            csChannel.setIsValid(saveReqBO.getIsValid());
            csChannel.setRemark(saveReqBO.getRemark());
            csChannel.setAccessUrl(saveReqBO.getAccessUrl());
            this.csChannelMapper.updateSelectiveByPrimaryKey(csChannel);
            if (bindChannelSkillReqBO.getSkillGids() != null) {
                this.bindSkillChannel(bindChannelSkillReqBO);
            }
        } else {
            String channelCode = saveReqBO.getChannelType() + saveReqBO.getChannelCode();
            CsChannel checkChannel = this.csChannelMapper.selectByChannelCode(saveReqBO.getTenantCode(), channelCode);
            if (checkChannel != null) {
                return BaseRspUtils.createErrorRsp((String)"\u6e20\u9053\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u8bd5!");
            }
            BeanUtils.copyProperties((Object)saveReqBO, (Object)csChannel);
            if (StringUtils.isBlank((CharSequence)saveReqBO.getIsValid())) {
                csChannel.setIsValid(EntityValidType.NORMAL.getCode());
            }
            csChannel.setId(Long.valueOf(IdWorker.nextAutoId()));
            csChannel.setUpdateTime(new Date());
            csChannel.setChannelCode(channelCode);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.niccCsmConfigProperties.getImAccessPrefix()})) {
                String url = CsChannelManageServiceImpl.parseUrl(this.niccCsmConfigProperties.getImAccessPrefix(), channelCode).toString();
                csChannel.setAccessUrl(url);
            }
            this.csChannelMapper.insertSelective(csChannel);
            if (bindChannelSkillReqBO.getSkillGids() != null) {
                bindChannelSkillReqBO.setChannelCode(channelCode);
                this.bindSkillChannel(bindChannelSkillReqBO);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)csChannel.getId());
    }

    public static URI parseUrl(String uriTemplate, Object ... uriVariables) {
        return UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVariables).encode().toUri();
    }

    public Rsp deleteChannel(CsChannelSaveReqBO reqBO) {
        log.info("\u6e20\u9053\u7ba1\u7406-\u5220\u9664\u6e20\u9053:{}", (Object)reqBO);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{reqBO.getTenantCode(), reqBO.getChannelCode()})) {
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u53c2\u6570\u5f02\u5e38!");
        }
        int update = this.csChannelMapper.deleteByChannelCode(reqBO.getTenantCode(), reqBO.getChannelCode());
        if (update > 0) {
            this.csSkillChannelRelMapper.deleteByChannel(reqBO.getTenantCode(), reqBO.getChannelCode());
            return BaseRspUtils.createSuccessRsp((Object)update, (String)"\u64cd\u4f5c\u6210\u529f!");
        }
        return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u8be5\u6e20\u9053\u4e0d\u5b58\u5728!");
    }

    public RspList<CsChannelBO> getChannelList(CsChannelQueryReqBO queryReqBO) {
        log.info("\u6e20\u9053\u7ba1\u7406-\u6e20\u9053\u5217\u8868\u67e5\u8be2:{}", (Object)queryReqBO);
        queryReqBO.setIsValid(EntityValidType.NORMAL.getCode());
        RspList<CsChannelBO> channelRspList = this.csmCommonService.getChannelList(queryReqBO);
        for (CsChannelBO row : channelRspList.getRows()) {
            CsChannelQueryReqBO reqRelBO = new CsChannelQueryReqBO();
            reqRelBO.setTenantCode(queryReqBO.getTenantCode());
            reqRelBO.setChannelCode(row.getChannelCode());
            List groupBOS = this.getSkillsByChannel(reqRelBO).getRows();
            row.setRelSkills(groupBOS);
        }
        return channelRspList;
    }

    public RspList getSkillsByChannel(CsChannelQueryReqBO queryReqBO) {
        log.info("\u6e20\u9053\u7ba1\u7406-\u67e5\u8be2\u6e20\u9053\u5173\u8054\u6280\u80fd\u7ec4:{}", (Object)queryReqBO);
        ArrayList list = Lists.newArrayList();
        List skillGroups = this.csSkillChannelRelMapper.selectSkillByChannel(queryReqBO.getTenantCode(), queryReqBO.getChannelCode());
        NiccCommonUtil.copyList((List)skillGroups, (List)list, CsSkillGroupBO.class);
        return BaseRspUtils.createSuccessRspList((List)list);
    }

    @MethodParamVerifyEnable
    public Rsp bindSkillChannel(CsBindChannelSkillReqBO bindReqBO) {
        log.info("\u6e20\u9053\u7ba1\u7406-\u7ed1\u5b9a\u6280\u80fd\u7ec4\u6e20\u9053\u5173\u7cfb:{}", (Object)bindReqBO);
        int count = 0;
        CsChannel csChannel = this.csChannelMapper.selectByChannelCode(bindReqBO.getTenantCode(), bindReqBO.getChannelCode());
        if (csChannel == null) {
            return BaseRspUtils.createErrorRsp((String)"\u7ed1\u5b9a\u5f02\u5e38:\u8be5\u6e20\u9053\u4e0d\u5b58\u5728!");
        }
        if (bindReqBO.getSkillGids() != null && !bindReqBO.getSkillGids().isEmpty()) {
            this.csSkillChannelRelMapper.deleteByChannel(bindReqBO.getTenantCode(), bindReqBO.getChannelCode());
        }
        for (String skillGid : bindReqBO.getSkillGids()) {
            CsSkillChannelRel record = new CsSkillChannelRel();
            record.setTenantCode(bindReqBO.getTenantCode());
            record.setIsValid(EntityValidType.NORMAL.getCode());
            record.setCrtTime(new Date());
            record.setChannelCode(bindReqBO.getChannelCode());
            record.setSkillGid(skillGid);
            count += this.csSkillChannelRelMapper.insertSelective(record);
        }
        return BaseRspUtils.createSuccessRsp((Object)count);
    }

    public Rsp removeSkillChannel(CsBindChannelSkillReqBO bindReqBO) {
        log.info("\u6e20\u9053\u7ba1\u7406-\u79fb\u9664\u6280\u80fd\u7ec4\u6e20\u9053\u5173\u7cfb:{}", (Object)bindReqBO);
        int count = 0;
        for (String skillGid : bindReqBO.getSkillGids()) {
            count += this.csSkillChannelRelMapper.deleteBySkillGidAndChannel(bindReqBO.getTenantCode(), skillGid, bindReqBO.getChannelCode());
        }
        return BaseRspUtils.createSuccessRsp((Object)count);
    }
}

