/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.common.api.ChatSessionService;
import com.tydic.nicc.common.bo.im.core.ImUpdateMessageReqBO;
import com.tydic.nicc.common.bo.rocketmq.CsmUserEvaluationContext;
import com.tydic.nicc.common.bo.session.ChatSessionBO;
import com.tydic.nicc.common.constants.ImCoreConstants;
import com.tydic.nicc.common.eums.CardMessageType;
import com.tydic.nicc.common.eums.im.ImMsgType;
import com.tydic.nicc.common.eums.im.MsgFormType;
import com.tydic.nicc.common.eums.im.SysMsgCode;
import com.tydic.nicc.common.msg.CardEvalMessageInfo;
import com.tydic.nicc.common.msg.CardEvalResult;
import com.tydic.nicc.common.msg.CardMessageInfo;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.common.msg.ImMessageBody;
import com.tydic.nicc.common.msg.ImSysMessageBody;
import com.tydic.nicc.common.msg.ImUserMessageBody;
import com.tydic.nicc.common.msg.system.SysMsgContent;
import com.tydic.nicc.common.msg.system.SysUserEvaluationNotice;
import com.tydic.nicc.csm.api.CsEvaluationApi;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.evaluation.CsEvaluationQueryReqBO;
import com.tydic.nicc.csm.api.bo.evaluation.CsEvaluationSaveReqBO;
import com.tydic.nicc.csm.api.bo.evaluation.InviteUserEvaluationReqBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsEvaluationRecordMapper;
import com.tydic.nicc.csm.mapper.CsInfoMapper;
import com.tydic.nicc.csm.mapper.po.CsEvaluationRecord;
import com.tydic.nicc.csm.mapper.po.CsInfo;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.ImMessageBuilder;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.bo.CheckValidSessionReqBO;
import com.tydic.nicc.im.core.api.ImMessageService;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-csm")
@Service
public class CsEvaluationServiceImpl
implements CsEvaluationApi {
    private static final Logger log = LoggerFactory.getLogger(CsEvaluationServiceImpl.class);
    @Resource
    private CsEvaluationRecordMapper evaluationRecordMapper;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsInfoMapper csInfoMapper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ChatSessionService chatSessionService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;

    public RspList getEvaluations(CsEvaluationQueryReqBO reqBO) {
        return null;
    }

    @MethodParamVerifyEnable
    @Transactional
    public Rsp saveEvaluation(CsEvaluationSaveReqBO saveReqBO) {
        log.info("\u4fdd\u5b58\u8bc4\u4ef7\u4fe1\u606f:{}", (Object)saveReqBO);
        CsEvaluationRecord csEvaluation = new CsEvaluationRecord();
        BeanUtils.copyProperties((Object)saveReqBO, (Object)csEvaluation);
        CsEvaluationRecord evaluationRecord = this.evaluationRecordMapper.selectByCsAndSessionId(csEvaluation);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{evaluationRecord})) {
            csEvaluation.setEvaluateTime(new Date());
            int update = this.evaluationRecordMapper.updateByCsAndSessionId(csEvaluation);
            if (update > 0) {
                this.noticeEvalResult(csEvaluation, saveReqBO.getEvalMsgId());
                return BaseRspUtils.createSuccessRsp((Object)saveReqBO, (String)"\u8bc4\u4ef7\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u8bc4\u4ef7\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        Rsp sessionBORsp = this.chatSessionService.getSessionInfo(csEvaluation.getSessionId());
        if (sessionBORsp.isSuccess()) {
            csEvaluation.setEvaluationId(IdWorker.nextAutoIdStr());
            csEvaluation.setEvaluateTime(new Date());
            csEvaluation.setSessionStartTime(((ChatSessionBO)sessionBORsp.getData()).getBeginTime());
            csEvaluation.setSessionEndTime(((ChatSessionBO)sessionBORsp.getData()).getEndTime());
            csEvaluation.setCsReceptStartTime(((ChatSessionBO)sessionBORsp.getData()).getBeginTime());
            csEvaluation.setCsReceptEndTime(((ChatSessionBO)sessionBORsp.getData()).getEndTime());
            csEvaluation.setEvaluationMsg(saveReqBO.getEvaluationMsg());
            saveReqBO.setEvaluationId(csEvaluation.getEvaluationId());
            BeanUtils.copyProperties((Object)csEvaluation, (Object)saveReqBO);
            this.evaluationRecordMapper.insertSelective(csEvaluation);
            this.noticeEvalResult(csEvaluation, saveReqBO.getEvalMsgId());
            return BaseRspUtils.createSuccessRsp((Object)saveReqBO, (String)"\u8bc4\u4ef7\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        }
        log.warn("\u4f1a\u8bdd\u4fdd\u5b58\u5931\u8d25,\u4f1a\u8bdd\u67e5\u8be2\u5931\u8d25:{}", (Object)sessionBORsp);
        return BaseRspUtils.createErrorRsp((String)"\u4f1a\u8bdd\u4fdd\u5b58\u5931\u8d25:\u4f1a\u8bdd\u67e5\u8be2\u5931\u8d25!");
    }

    private void noticeEvalResult(CsEvaluationRecord csEvaluation, String evalMsgId) {
        CsInfo csInfo = this.csInfoMapper.selectByPrimaryKey(csEvaluation.getCsId());
        if (csInfo == null) {
            log.warn("\u4fdd\u5b58\u8bc4\u4ef7\u4fe1\u606f-\u63a8\u9001\u8bc4\u4ef7\u901a\u77e5\u5f02\u5e38:\u5ba2\u670d {} \u4e0d\u5b58\u5728", (Object)csEvaluation.getCsId());
            return;
        }
        ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.SYSTEM.getCode());
        message.setFromNo(ImCoreConstants.getSystemUser((String)csEvaluation.getTenantCode()));
        message.setSessionId(csEvaluation.getSessionId());
        message.setToNo(csEvaluation.getCsId());
        SysMsgContent sysMsgContent = new SysMsgContent();
        SysUserEvaluationNotice evaluationNotice = SysUserEvaluationNotice.builder().evalMsgId(evalMsgId).sessionId(csEvaluation.getSessionId()).userId(csEvaluation.getUserId()).evaluationValue(csEvaluation.getEvaluationValue()).evaluationContent(csEvaluation.getEvaluationContent()).build();
        sysMsgContent.setUserEvaluationNotice(evaluationNotice);
        ImSysMessageBody messageBody = new ImSysMessageBody(SysMsgCode.USER_EVALUATION_NOTICE.getCode(), sysMsgContent);
        message.setMsgBody((ImMessageBody)messageBody);
        String msg = JSONObject.toJSONString((Object)message);
        log.info("\u4fdd\u5b58\u8bc4\u4ef7\u4fe1\u606f-\u63a8\u9001\u8bc4\u4ef7\u5b8c\u6210\u63d0\u793a:{}", (Object)msg);
        this.imMessageService.sendMessageToUser(csEvaluation.getCsId(), msg);
        CardEvalResult evalResult = CardEvalResult.builder().evalContent(csEvaluation.getEvaluationContent()).evalValue(csEvaluation.getEvaluationValue()).evalTime(csEvaluation.getEvaluateTime()).inviteType(csEvaluation.getInviteType()).userId(csEvaluation.getUserId()).csId(csEvaluation.getCsId()).build();
        CardEvalMessageInfo cardMessageInfo = new CardEvalMessageInfo(csEvaluation.getSessionId(), csInfo.getCsCode(), evalResult);
        String chatKey = NiccCommonUtil.getC2bChatKey((String)csEvaluation.getTenantCode(), (String)csEvaluation.getUserId());
        ImUpdateMessageReqBO updateMessageReqBO = new ImUpdateMessageReqBO();
        BeanUtils.copyProperties((Object)csEvaluation, (Object)updateMessageReqBO);
        updateMessageReqBO.setMsgId(evalMsgId);
        updateMessageReqBO.setChatKey(chatKey);
        updateMessageReqBO.setMsgContent(JSONObject.toJSONString((Object)cardMessageInfo));
        try {
            Rsp updateEvalMsg = this.imMessageService.updateMessage(updateMessageReqBO);
            log.info("\u4fdd\u5b58\u8bc4\u4ef7\u4fe1\u606f-\u66f4\u65b0\u8bc4\u4ef7\u6d88\u606f:{}", (Object)updateEvalMsg);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u8bc4\u4ef7\u4fe1\u606f-\u66f4\u65b0\u8bc4\u4ef7\u6d88\u606f\u5f02\u5e38:{}", (Throwable)e);
        }
        CsmUserEvaluationContext evaluationContext = new CsmUserEvaluationContext();
        BeanUtils.copyProperties((Object)csEvaluation, (Object)evaluationContext);
        evaluationContext.setEvalMsgId(evalMsgId);
        log.info("\u4fdd\u5b58\u8bc4\u4ef7\u4fe1\u606f-\u53d1\u9001\u8bc4\u4ef7\u5b8c\u6210\u6d88\u606f:{}", (Object)JSONObject.toJSONString((Object)evaluationContext));
        this.kkMqProducerHelper.sendMsg("CSM_USER_EVALUATION", (Object)evaluationContext);
    }

    @MethodParamVerifyEnable
    public Rsp inviteUserEvaluation(InviteUserEvaluationReqBO evaluationReqBO) {
        log.info("\u5ba2\u670d\u9080\u8bf7\u8bc4\u4ef7-\u5165\u53c2:{}", (Object)evaluationReqBO);
        try {
            CsInfoBO csInfoBO = this.csmCommonService.getCsInfo(evaluationReqBO.getCsId());
            if (csInfoBO != null) {
                String chatKey = NiccCommonUtil.getC2bChatKey((String)evaluationReqBO.getTenantCode(), (String)evaluationReqBO.getUserId());
                if (this.niccCsmConfigProperties.getAutoInviteType().contains(String.valueOf(evaluationReqBO.getCloseType()))) {
                    CsEvaluationRecord record = new CsEvaluationRecord();
                    record.setTenantCode(evaluationReqBO.getTenantCode());
                    record.setSessionId(evaluationReqBO.getSessionId());
                    record.setCsId(evaluationReqBO.getCsId());
                    CsEvaluationRecord evaluationRecord = this.evaluationRecordMapper.selectByCsAndSessionId(record);
                    if (evaluationRecord != null) {
                        return BaseRspUtils.createSuccessRsp((Object)evaluationRecord.getSessionId(), (String)"\u4f1a\u8bdd\u5df2\u8bc4\u4ef7\u8fc7\u65e0\u9700\u91cd\u590d\u9080\u8bf7!");
                    }
                    boolean validSession = true;
                    if (this.niccCsmConfigProperties.getInviteEvalCheckValid().booleanValue()) {
                        CheckValidSessionReqBO sessionReqBO = new CheckValidSessionReqBO();
                        sessionReqBO.setTenantCode(evaluationReqBO.getTenantCode());
                        sessionReqBO.setSessionId(evaluationReqBO.getSessionId());
                        sessionReqBO.setChatKey(chatKey);
                        sessionReqBO.setCsId(evaluationReqBO.getCsId());
                        sessionReqBO.setUserId(evaluationReqBO.getUserId());
                        Rsp validSessionRsp = this.imMessageService.checkC2bValidSession(sessionReqBO);
                        log.info("\u5ba2\u670d\u9080\u8bf7\u8bc4\u4ef7,\u6821\u9a8c\u4f1a\u8bdd\u662f\u5426\u6709\u6548:{}", (Object)validSessionRsp);
                        validSession = validSessionRsp.isSuccess();
                    }
                    if (validSession) {
                        ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.AUTO_REPLY.getCode());
                        message.setTenantCode(evaluationReqBO.getTenantCode());
                        message.setToNo(evaluationReqBO.getUserId());
                        message.setFromNo(evaluationReqBO.getCsId());
                        message.setSessionId(evaluationReqBO.getSessionId());
                        CardMessageInfo cardMessageInfo = new CardMessageInfo(CardMessageType.EVALUATION_INVITE);
                        cardMessageInfo.setContent(csInfoBO.getCsCode());
                        ImUserMessageBody userMessageBody = new ImUserMessageBody(MsgFormType.CARD_MSG.getCode(), JSONObject.toJSONString((Object)cardMessageInfo));
                        message.setMsgBody((ImMessageBody)userMessageBody);
                        log.info("\u5ba2\u670d\u9080\u8bf7\u8bc4\u4ef7,\u63a8\u9001\u8bc4\u4ef7\u9080\u8bf7\u6d88\u606f:{}", (Object)message);
                        this.imMessageService.sendMessageToUser(message, evaluationReqBO.getUserId(), chatKey);
                        return BaseRspUtils.createSuccessRsp((Object)message);
                    }
                    return BaseRspUtils.createErrorRsp((String)"\u4f1a\u8bdd\u65e0\u6548,\u65e0\u6cd5\u53d1\u8d77\u8bc4\u4ef7\u9080\u8bf7");
                }
                return BaseRspUtils.createSuccessRsp((Object)evaluationReqBO.getCloseType(), (String)"\u5904\u7406\u5b8c\u6210,\u672a\u53d1\u9001\u9080\u8bf7");
            }
            return BaseRspUtils.createErrorRsp((String)"\u9080\u8bf7\u8bc4\u4ef7\u53d1\u8d77\u5931\u8d25,\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u9080\u8bf7\u8bc4\u4ef7\u53d1\u8d77\u5931\u8d25:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u9080\u8bf7\u8bc4\u4ef7\u53d1\u8d77\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }
}

