/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.csm.CsmAllotRspContext;
import com.tydic.nicc.common.bo.im.core.ImUserAllowReqBO;
import com.tydic.nicc.common.bo.im.core.ImUserDenyReqBO;
import com.tydic.nicc.common.bo.rocketmq.CsFreeEventContext;
import com.tydic.nicc.common.bo.user.BatchUserAddReqBO;
import com.tydic.nicc.common.bo.user.BatchUserAddRspBO;
import com.tydic.nicc.common.bo.user.SaveUserInfoReqBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.AutoReplyType;
import com.tydic.nicc.common.eums.csm.CsOnlineStatus;
import com.tydic.nicc.common.eums.csm.CsState;
import com.tydic.nicc.common.eums.csm.CsType;
import com.tydic.nicc.common.eums.csm.CsWorkScheduleLevel;
import com.tydic.nicc.common.eums.im.ImOnlineStatus;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.CsAllotOrTransferApi;
import com.tydic.nicc.csm.api.CsInfoApi;
import com.tydic.nicc.csm.api.CsLabelApi;
import com.tydic.nicc.csm.api.CsSkillGroupApi;
import com.tydic.nicc.csm.api.bo.cs.CsAllotAllotOrTransferBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotAllotOrTransferReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.cs.CsFriendsInfo;
import com.tydic.nicc.csm.api.bo.cs.CsFriendsReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsFriendsSkill;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoDenyAllowReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoImportReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoSaveReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsReceiveLimitUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsStatusChangeLogSaveReqBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelQueryReqBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelRelSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupInfo;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupRelSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsStatusExtendBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.listener.CsInfoReadExcelListener;
import com.tydic.nicc.csm.mapper.CsInfoMapper;
import com.tydic.nicc.csm.mapper.po.CsInfo;
import com.tydic.nicc.csm.mapper.po.CsInfoQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsInfoSkillRel;
import com.tydic.nicc.csm.mapper.po.CsReceiveLimitUpdateCondition;
import com.tydic.nicc.csm.service.CsmCsAllotProcessService;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.csm.utils.excel.CsInfoExcelImportErrorRecord;
import com.tydic.nicc.csm.utils.excel.CsInfoExcelRecord;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.admin.api.BladeTenantService;
import com.tydic.nicc.im.bo.BladeTenantBO;
import com.tydic.nicc.im.bo.C2cUnreadCountReqBO;
import com.tydic.nicc.im.core.api.ImMessageService;
import com.tydic.nicc.user.api.UserOptionService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-csm")
@Service
public class CsInfoServiceImpl
implements CsInfoApi {
    private static final Logger log = LoggerFactory.getLogger(CsInfoServiceImpl.class);
    @Resource
    private CsInfoMapper csInfoMapper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmLogCommonService csmLogCommonService;
    @Resource
    private CsLabelApi csLabelApi;
    @Resource
    private CsSkillGroupApi csSkillGroupApi;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private CsmCsAllotProcessService csmCsAllotProcessService;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private CsAllotOrTransferApi csAllotOrTransferApi;
    @Resource
    private CsmItemCountService csmItemCountService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=1000, check=false)
    BladeTenantService bladeTenantService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;

    @MethodParamVerifyEnable
    public Rsp updateCsReceiveLimit(CsReceiveLimitUpdateReqBO limitUpdateReqBO) {
        log.info("\u8bbe\u7f6e\u5ba2\u670d\u63a5\u5f85\u4e0a\u9650:{}", (Object)limitUpdateReqBO);
        if (limitUpdateReqBO.getCsIds() != null && limitUpdateReqBO.getCsIds().isEmpty()) {
            limitUpdateReqBO.setCsIds(null);
        }
        if (limitUpdateReqBO.getReceiveLimit() > 10) {
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u5ba2\u670d\u6700\u5927\u63a5\u5f85\u4e0a\u7ebf\u4e0d\u5f97\u8d85\u8fc710\u4f4d");
        }
        CsReceiveLimitUpdateCondition condition = new CsReceiveLimitUpdateCondition();
        BeanUtils.copyProperties((Object)limitUpdateReqBO, (Object)condition);
        int update = this.csInfoMapper.updateReceiveLimit(condition);
        return BaseRspUtils.createSuccessRsp((Object)update);
    }

    @Transactional
    @MethodParamVerifyEnable
    public Rsp setCsDenyAllow(CsInfoDenyAllowReqBO denyAllowReqBO) {
        log.info("\u66f4\u65b0\u5ba2\u670d\u7981\u7528\u72b6\u6001:{}", (Object)denyAllowReqBO);
        CsInfo csInfo = this.csInfoMapper.selectByPrimaryKey(denyAllowReqBO.getCsId());
        if (csInfo == null) {
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u5ba2\u670d\u4e0d\u5b58\u5728!");
        }
        Rsp rsp = null;
        if (CsState.DENY.matchCode(denyAllowReqBO.getCsState())) {
            if (denyAllowReqBO.getCsState().equals(csInfo.getCsState())) {
                return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u5f53\u524d\u72b6\u6001\u5df2\u7981\u7528,\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!");
            }
            ImUserDenyReqBO denyReqBO = new ImUserDenyReqBO();
            denyReqBO.setTenantCode(denyAllowReqBO.getTenantCode());
            denyReqBO.setUserId(denyAllowReqBO.getCsId());
            denyReqBO.setRemark(CsState.DENY.getName());
            denyReqBO.setOperUser(denyAllowReqBO.getOperUser());
            rsp = this.userOptionService.setUserDeny(denyReqBO);
        }
        if (CsState.NORMAL.matchCode(denyAllowReqBO.getCsState())) {
            if (denyAllowReqBO.getCsState().equals(csInfo.getCsState())) {
                return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u5f53\u524d\u72b6\u6001\u6b63\u5e38,\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!");
            }
            ImUserAllowReqBO allowReqBO = new ImUserAllowReqBO();
            allowReqBO.setTenantCode(denyAllowReqBO.getTenantCode());
            allowReqBO.setUserId(denyAllowReqBO.getCsId());
            allowReqBO.setRemark(CsState.NORMAL.getName());
            allowReqBO.setOperUser(denyAllowReqBO.getOperUser());
            rsp = this.userOptionService.setUserAllow(allowReqBO);
        }
        if (rsp != null && rsp.isSuccess()) {
            CsInfo record = new CsInfo();
            record.setCsId(denyAllowReqBO.getCsId());
            record.setCsState(denyAllowReqBO.getCsState());
            record.setUpdateTime(new Date());
            this.csInfoMapper.updateByPrimaryKeySelective(record);
            return rsp;
        }
        return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public Rsp saveCsInfo(CsInfoSaveReqBO csInfoSave) {
        List csInfos;
        CsInfoQueryCondition condition;
        log.info("\u4fdd\u5b58\u5750\u5e2d\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)csInfoSave));
        CsInfo record = new CsInfo();
        csInfoSave.setUpdateTime(new Date());
        BeanUtils.copyProperties((Object)csInfoSave, (Object)record);
        int addOrUpdate = 0;
        if (StringUtils.isNotEmpty((CharSequence)csInfoSave.getCsCode())) {
            condition = new CsInfoQueryCondition();
            condition.setTenantCode(csInfoSave.getTenantCode());
            condition.setCsCode(csInfoSave.getCsCode());
            csInfos = this.csInfoMapper.selectByCondition(condition);
            if (StringUtils.isNotEmpty((CharSequence)csInfoSave.getCsId()) ? csInfos != null && !csInfos.isEmpty() && !((CsInfo)csInfos.get(0)).getCsId().equals(csInfoSave.getCsId()) : csInfos != null && !csInfos.isEmpty()) {
                return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25,\u5ba2\u670d\u5de5\u53f7\u5df2\u5b58\u5728!");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)csInfoSave.getLoginName())) {
            condition = new CsInfoQueryCondition();
            condition.setTenantCode(csInfoSave.getTenantCode());
            condition.setLoginName(csInfoSave.getLoginName());
            condition.setNotCsStates(Collections.singletonList(CsState.DELETED.getCode()));
            csInfos = this.csInfoMapper.selectByCondition(condition);
            if (StringUtils.isNotEmpty((CharSequence)csInfoSave.getCsId()) ? csInfos != null && !csInfos.isEmpty() && !((CsInfo)csInfos.get(0)).getCsId().equals(csInfoSave.getCsId()) : csInfos != null && !csInfos.isEmpty()) {
                return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25,\u5ba2\u670d\u767b\u5f55\u540d\u79f0\u5df2\u5b58\u5728!");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)csInfoSave.getCsId())) {
            record.setUpdateTime(new Date());
            if (CsState.DELETED.getCode().equals(csInfoSave.getCsState())) {
                record.setLoginName(record.getCsId());
            }
            if ((addOrUpdate = this.csInfoMapper.updateByPrimaryKeySelective(record)) == 0) {
                return BaseRspUtils.createErrorRsp((String)("\u66f4\u65b0\u5931\u8d25,\u8bf7\u68c0\u67e5\u5ba2\u670did\u662f\u5426\u6b63\u786e: csId = " + csInfoSave.getCsId()));
            }
            RspList<BatchUserAddRspBO> res = this.saveImUserInfo(csInfoSave);
            log.info("\u4fdd\u5b58im\u7528\u6237\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(res));
        } else {
            if (StringUtils.isEmpty((CharSequence)csInfoSave.getCsCode())) {
                return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25,csCode\u4e0d\u5f97\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((CharSequence)csInfoSave.getNickName())) {
                return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25,nickName\u4e0d\u5f97\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((CharSequence)csInfoSave.getLoginName())) {
                csInfoSave.setLoginName(csInfoSave.getCsPhone());
            }
            if (StringUtils.isEmpty((CharSequence)csInfoSave.getLiveStatusCode())) {
                csInfoSave.setLiveStatusCode(CsOnlineStatus.CS_SIG_OUT.getName());
                csInfoSave.setLiveOnlineStatus(CsOnlineStatus.CS_OFFLINE.getCode());
            }
            if (csInfoSave.getCsType() == null) {
                csInfoSave.setCsType(CsType.CS_ONLINE.getCode());
            }
            if (csInfoSave.getReceiveLimit() == null) {
                csInfoSave.setReceiveLimit(Integer.valueOf(5));
            }
            BeanUtils.copyProperties((Object)csInfoSave, (Object)record);
            RspList<BatchUserAddRspBO> addRspBORspList = this.saveImUserInfo(csInfoSave);
            if (addRspBORspList.isSuccess()) {
                BatchUserAddRspBO addRspBO = (BatchUserAddRspBO)addRspBORspList.getRows().get(0);
                if (!addRspBO.getResult().booleanValue()) return BaseRspUtils.createErrorRsp((String)"csCode\u5df2\u5b58\u5728,\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
                csInfoSave.setCreateTime(new Date());
                record.setCsId(addRspBO.getUserId());
                record.setCreateTime(csInfoSave.getCreateTime());
                csInfoSave.setCsId(addRspBO.getUserId());
                addOrUpdate = this.csInfoMapper.insertSelective(record);
            } else {
                log.error("\u5750\u5e2d\u4fe1\u606f\u540c\u6b65\u5230im\u5931\u8d25:{}", addRspBORspList);
            }
        }
        if (addOrUpdate <= 0) return BaseRspUtils.createErrorRsp((String)"\u5750\u5e2d\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
        boolean save = this.handleAboutCsInfo(csInfoSave);
        if (!save) return BaseRspUtils.createSuccessRsp((Object)csInfoSave);
        this.csmItemCountService.countAllCsAllotItems(csInfoSave.getTenantCode(), Collections.singletonList(csInfoSave.getCsId()));
        return BaseRspUtils.createSuccessRsp((Object)csInfoSave);
    }

    private boolean handleAboutCsInfo(CsInfoSaveReqBO csInfoSave) {
        List skillGroupInfos;
        List labels = csInfoSave.getCsLabels();
        boolean save = false;
        if (ObjectUtils.anyNotNull((Object[])new Object[]{labels})) {
            for (CsLabelBO label : labels) {
                if (StringUtils.isEmpty((CharSequence)label.getLabelId())) {
                    log.warn("\u4fdd\u5b58\u5ba2\u670d\u6807\u7b7e\u4fe1\u606f\u6807\u7b7eid\u4e0d\u5f97\u4e3a\u7a7a:{}", (Object)label);
                    continue;
                }
                CsLabelRelSaveReqBO csLabelRelSaveReqBO = new CsLabelRelSaveReqBO();
                csLabelRelSaveReqBO.setTenantCode(csInfoSave.getTenantCode());
                csLabelRelSaveReqBO.setLabelId(label.getLabelId());
                csLabelRelSaveReqBO.setCsId(csInfoSave.getCsId());
                csLabelRelSaveReqBO.setIsValid(label.getIsValid());
                csLabelRelSaveReqBO.setUpdateTime(new Date());
                this.csLabelApi.saveCsLabelRel(csLabelRelSaveReqBO);
            }
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{skillGroupInfos = csInfoSave.getCsSkillGroups()})) {
            for (CsSkillGroupInfo skillGroupInfo : skillGroupInfos) {
                if (StringUtils.isEmpty((CharSequence)skillGroupInfo.getSkillGid())) {
                    log.warn("\u4fdd\u5b58\u5ba2\u670d\u6280\u80fd\u7ec4,\u6280\u80fd\u7ec4id\u4e0d\u5f97\u4e3a\u7a7a:{}", (Object)skillGroupInfo);
                    continue;
                }
                CsSkillGroupRelSaveReqBO csSkillGroupRelSaveReqBO = new CsSkillGroupRelSaveReqBO();
                csSkillGroupRelSaveReqBO.setTenantCode(csInfoSave.getTenantCode());
                csSkillGroupRelSaveReqBO.setSkillGid(skillGroupInfo.getSkillGid());
                csSkillGroupRelSaveReqBO.setCsId(csInfoSave.getCsId());
                csSkillGroupRelSaveReqBO.setIsValid(skillGroupInfo.getIsValid());
                this.csSkillGroupApi.saveSkillGroupRel(csSkillGroupRelSaveReqBO);
            }
            save = true;
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{csInfoSave.getCsAutoReplyConfigs()}) && !csInfoSave.getCsAutoReplyConfigs().isEmpty()) {
            for (CsAutoReplyConfigBO replyConfigBO : csInfoSave.getCsAutoReplyConfigs()) {
                if (StringUtils.isEmpty((CharSequence)replyConfigBO.getReplyType())) {
                    replyConfigBO.setReplyType(AutoReplyType.CS_WELCOME.getCode());
                }
                replyConfigBO.setTenantCode(csInfoSave.getTenantCode());
                replyConfigBO.setConfigLevel(CsWorkScheduleLevel.CS.getCode());
                replyConfigBO.setConfigLevelVal(csInfoSave.getCsId());
                replyConfigBO.setIsValid(replyConfigBO.getIsValid());
                if (!StringUtils.isEmpty((CharSequence)replyConfigBO.getIsValid())) continue;
                replyConfigBO.setIsValid(EntityValidType.NORMAL.getCode());
            }
            this.csmCommonService.saveCsAutoReplyConfigs(csInfoSave.getCsAutoReplyConfigs());
        }
        return save;
    }

    private RspList<BatchUserAddRspBO> saveImUserInfo(CsInfoSaveReqBO csInfoSave) {
        BatchUserAddReqBO batchUserAddReqBO = new BatchUserAddReqBO();
        ArrayList users = Lists.newArrayList();
        SaveUserInfoReqBO userInfoReqBO = new SaveUserInfoReqBO();
        BeanUtils.copyProperties((Object)csInfoSave, (Object)userInfoReqBO);
        userInfoReqBO.setUserType(UserTypeField.COMP_USER.getIntCode());
        userInfoReqBO.setExtUid(csInfoSave.getCsCode());
        userInfoReqBO.setUserId(csInfoSave.getCsId());
        userInfoReqBO.setName(csInfoSave.getCsName());
        userInfoReqBO.setNickname(csInfoSave.getNickName());
        userInfoReqBO.setCallNum1(csInfoSave.getCsPhone());
        userInfoReqBO.setCallNum2(csInfoSave.getSelfPhone());
        userInfoReqBO.setUserAvatar(csInfoSave.getCsAvatar());
        userInfoReqBO.setStatus(csInfoSave.getCsState());
        userInfoReqBO.setExtData(csInfoSave.getExtInfo());
        if (CsState.DELETED.matchCode(csInfoSave.getCsState())) {
            userInfoReqBO.setStatus(CsState.DENY.getCode());
        }
        users.add(userInfoReqBO);
        batchUserAddReqBO.setTenantCode(csInfoSave.getTenantCode());
        batchUserAddReqBO.setUsers((List)users);
        return this.userOptionService.batchAddUsers(batchUserAddReqBO);
    }

    @MethodParamVerifyEnable
    public Rsp getCsInfo(CsInfoQueryReqBO csInfoReqBO) {
        log.info("\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f:{}", (Object)csInfoReqBO);
        if (StringUtils.isEmpty((CharSequence)csInfoReqBO.getCsId()) && StringUtils.isEmpty((CharSequence)csInfoReqBO.getLoginName())) {
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25:\u8bf7\u4f20\u5165\u5ba2\u670did/loginName");
        }
        CsInfoBO csInfo = this.csmCommonService.getCsInfo(csInfoReqBO.getCsId());
        if (csInfo != null) {
            this.csInfoAboutInfo(csInfo, true, true, true, true, true);
            long queueCount = csInfo.getCsSkillGroups().stream().mapToLong(CsSkillGroupInfo::getQueueCount).sum();
            csInfo.setQueueCount(queueCount);
            if (StringUtils.isBlank((CharSequence)csInfo.getCsAvatar())) {
                csInfo.setCsAvatar(this.niccCsmConfigProperties.getCsDefaultAvatar());
            }
            return BaseRspUtils.createSuccessRsp((Object)csInfo);
        }
        return BaseRspUtils.createErrorRsp((String)"\u5ba2\u670d\u4fe1\u606f\u4e0d\u5b58\u5728!");
    }

    public static void main(String[] args) {
        CsInfoReadExcelListener readExcelListener = new CsInfoReadExcelListener();
        EasyExcel.read((File)new File("/Volumes/Public/\u5ba2\u670d\u4fe1\u606f\u6a21\u677f.xlsx"), CsInfoExcelRecord.class, (ReadListener)readExcelListener).sheet(Integer.valueOf(0)).doRead();
        log.info("{}", readExcelListener.getCsList());
    }

    @MethodParamVerifyEnable
    public Rsp importCsInfo(CsInfoImportReqBO importReqBO) {
        ArrayList errorRecords = Lists.newArrayList();
        CsInfoReadExcelListener readExcelListener = new CsInfoReadExcelListener();
        EasyExcel.read((InputStream)importReqBO.getInputStream(), CsInfoExcelRecord.class, (ReadListener)readExcelListener).sheet(Integer.valueOf(0)).doRead();
        if (readExcelListener.getCsList().isEmpty()) {
            return BaseRspUtils.createErrorRsp((String)"\u8bfb\u53d6\u6587\u4ef6\u4e3a\u7a7a!");
        }
        log.info("\u5bfc\u5165\u5ba2\u670d\u4fe1\u606f-\u5f00\u59cb:{} \u6761\u6570\u636e", (Object)readExcelListener.getCsList().size());
        for (CsInfoExcelRecord csInfo : readExcelListener.getCsList()) {
            Rsp rsp;
            CsInfoSaveReqBO csInfoSave = new CsInfoSaveReqBO();
            BeanUtils.copyProperties((Object)csInfo, (Object)csInfoSave);
            csInfoSave.setTenantCode(importReqBO.getTenantCode());
            csInfoSave.setCsState(CsState.NORMAL.getCode());
            csInfoSave.setLiveOnlineStatus(CsOnlineStatus.CS_OFFLINE.getCode());
            if (csInfoSave.getReceiveLimit() == null) {
                csInfoSave.setReceiveLimit(Integer.valueOf(5));
            }
            if (ObjectUtils.isNotEmpty((Object)csInfoSave.getCsPosition())) {
                csInfoSave.setCsPosition("\u666e\u901a");
            }
            if (ObjectUtils.isNotEmpty((Object)csInfoSave.getCsAvatar())) {
                csInfoSave.setCsAvatar(this.niccCsmConfigProperties.getCsDefaultAvatar());
            }
            if (StringUtils.isNotEmpty((CharSequence)csInfo.getSkillGids())) {
                String[] gids = csInfo.getSkillGids().split(",");
                ArrayList csSkillGroups = Lists.newArrayList();
                for (String gid : gids) {
                    CsSkillGroupInfo groupInfo = new CsSkillGroupInfo();
                    groupInfo.setSkillGid(gid);
                    csSkillGroups.add(groupInfo);
                }
                csInfoSave.setCsSkillGroups((List)csSkillGroups);
            }
            if (StringUtils.isNotEmpty((CharSequence)csInfo.getLabelIds())) {
                String[] labels = csInfo.getLabelIds().split(",");
                ArrayList csLabels = Lists.newArrayList();
                for (String labelId : labels) {
                    CsLabelBO labelBO = new CsLabelBO();
                    labelBO.setLabelId(labelId);
                    csLabels.add(labelBO);
                }
                csInfoSave.setCsLabels((List)csLabels);
            }
            if ((rsp = this.saveCsInfo(csInfoSave)).isSuccess()) continue;
            errorRecords.add(new CsInfoExcelImportErrorRecord(csInfo.getCsCode(), rsp.getRspDesc()));
        }
        log.info("\u5bfc\u5165\u5ba2\u670d\u4fe1\u606f-\u7ed3\u675f:{} \u6761\u6570\u636e\u5f02\u5e38 errorRecords = {}", (Object)errorRecords.size(), (Object)errorRecords);
        return BaseRspUtils.createSuccessRsp((Object)errorRecords);
    }

    public Rsp updateCsOnline(CsInfoUpdateReqBO csInfoUpdateReqBO) {
        if (StringUtils.isEmpty((CharSequence)csInfoUpdateReqBO.getCsId())) {
            return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u8bf7\u4f20\u5165\u5ba2\u670did");
        }
        csInfoUpdateReqBO.setStatusChangeTime(new Date());
        CsInfoBO csInfoBO = this.csmCommonService.getCsInfo(csInfoUpdateReqBO.getCsId());
        if (csInfoBO == null) {
            return BaseRspUtils.createErrorRsp((String)"\u72b6\u6001\u66f4\u65b0\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u5ba2\u670d\u4fe1\u606f!");
        }
        CsStatusExtendBO extendBO = this.csmCommonService.getCsExtendStatus(csInfoUpdateReqBO.getTenantCode(), csInfoBO.getLiveStatusCode());
        CsInfo record = new CsInfo();
        record.setCsId(csInfoUpdateReqBO.getCsId());
        if (extendBO != null) {
            Rsp rsp;
            try {
                rsp = this.userOptionService.getOnlineStatus(csInfoUpdateReqBO.getTenantCode(), csInfoUpdateReqBO.getCsId());
            }
            catch (Exception e) {
                log.warn("\u66f4\u65b0\u5ba2\u670d\u72b6\u6001\u4e0a\u7ebf-\u5728\u7ebf\u72b6\u6001\u67e5\u8be2\u5931\u8d25:{}", (Throwable)e);
                rsp = BaseRspUtils.createSuccessRsp((Object)ImOnlineStatus.ONLINE.getCode());
            }
            if (((String)rsp.getData()).equals(ImOnlineStatus.ONLINE.getCode())) {
                record.setLiveOnlineStatus(extendBO.getOnlineStatus());
                record.setStatusChangeTime(csInfoUpdateReqBO.getStatusChangeTime());
                csInfoUpdateReqBO.setLiveStatusCode(csInfoBO.getLiveStatusCode());
                this.saveStatusChangeLog(csInfoUpdateReqBO);
                int i = this.csInfoMapper.updateByPrimaryKeySelective(record);
                if (i > 0 && CsOnlineStatus.CS_SIGN_IN.matchCode(extendBO.getOnlineStatus())) {
                    CsFreeEventContext csFreeEventContext = CsFreeEventContext.builder().tenantCode(csInfoUpdateReqBO.getTenantCode()).csId(csInfoUpdateReqBO.getCsId()).build();
                    int free = csInfoBO.getReceiveLimit() - csInfoBO.getReceivingCount();
                    int maxAllot = 0;
                    while (++maxAllot < 10) {
                        log.info("\u5750\u5e2d\u72b6\u6001\u66f4\u65b0-\u4e0a\u7ebf,\u5c1d\u8bd5\u4ece\u6392\u961f\u961f\u5217\u62c9\u53d6\u7528\u6237:{}", (Object)csFreeEventContext);
                        Rsp<CsmAllotRspContext> contextRsp = this.csmCsAllotProcessService.processCsmFreeAllot(csFreeEventContext);
                        if (contextRsp.isSuccess()) {
                            --free;
                        }
                        if (free > 0 && (contextRsp.isSuccess() || contextRsp.getData() != null)) continue;
                        break;
                    }
                }
            } else {
                log.warn("\u66f4\u65b0\u5ba2\u670d\u72b6\u6001\u4e0a\u7ebf,\u5f53\u524d\u5df2\u79bb\u7ebf:{} --> {}", (Object)csInfoUpdateReqBO.getCsId(), rsp.getData());
            }
            return BaseRspUtils.createSuccessRsp((Object)extendBO.getOnlineStatus(), (String)"\u4e0a\u7ebf\u72b6\u6001\u6062\u590d\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u4e0a\u7ebf\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
    }

    public Rsp updateCsOffline(CsInfoUpdateReqBO csInfoUpdateReqBO) {
        Rsp rsp;
        if (StringUtils.isEmpty((CharSequence)csInfoUpdateReqBO.getCsId())) {
            return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u8bf7\u4f20\u5165\u5ba2\u670did");
        }
        csInfoUpdateReqBO.setStatusChangeTime(new Date());
        csInfoUpdateReqBO.setLiveStatusCode(CsOnlineStatus.CS_OFFLINE.getName());
        CsInfo record = new CsInfo();
        record.setCsId(csInfoUpdateReqBO.getCsId());
        record.setLiveOnlineStatus(CsOnlineStatus.CS_OFFLINE.getCode());
        record.setCsState(csInfoUpdateReqBO.getCsState());
        record.setStatusChangeTime(csInfoUpdateReqBO.getStatusChangeTime());
        try {
            rsp = this.userOptionService.getOnlineStatus(csInfoUpdateReqBO.getTenantCode(), csInfoUpdateReqBO.getCsId());
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u5ba2\u670d\u72b6\u6001\u4e0b\u7ebf-\u5728\u7ebf\u72b6\u6001\u67e5\u8be2\u5931\u8d25:{}", (Throwable)e);
            rsp = BaseRspUtils.createSuccessRsp((Object)ImOnlineStatus.OFFLINE.getCode());
        }
        int update = 0;
        if (((String)rsp.getData()).equals(ImOnlineStatus.OFFLINE.getCode())) {
            this.saveStatusChangeLog(csInfoUpdateReqBO);
            update = this.csInfoMapper.updateByPrimaryKeySelective(record);
            return BaseRspUtils.createSuccessRsp((Object)update, (String)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        log.warn("\u66f4\u65b0\u5ba2\u670d\u72b6\u6001\u4e0b\u7ebf,\u5f53\u524d\u5df2\u5728\u7ebf:{} --> {}", (Object)csInfoUpdateReqBO.getCsId(), rsp.getData());
        return BaseRspUtils.createSuccessRsp((Object)update, (String)"\u72b6\u6001\u66f4\u65b0\u5931\u8d25:\u5df2\u5728\u7ebf");
    }

    @MethodParamVerifyEnable
    public Rsp updateCsStatus(CsInfoUpdateReqBO csInfoUpdateReqBO) {
        if (StringUtils.isEmpty((CharSequence)csInfoUpdateReqBO.getLiveStatusCode())) {
            return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u8bf7\u4f20\u5165\u5ba2\u670d\u72b6\u6001");
        }
        csInfoUpdateReqBO.setStatusChangeTime(new Date());
        CsStatusExtendBO extendBO = this.csmCommonService.getCsExtendStatus(csInfoUpdateReqBO.getTenantCode(), csInfoUpdateReqBO.getLiveStatusCode());
        if (extendBO != null) {
            int receivingCount;
            CsInfoBO csInfoBO = this.csmCommonService.getCsInfo(csInfoUpdateReqBO.getCsId());
            if (csInfoBO == null) {
                return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u5ba2\u670d\u4e0d\u5b58\u5728");
            }
            if ((CsOnlineStatus.CS_SIG_OUT.matchCode(extendBO.getOnlineStatus()) || CsOnlineStatus.CS_REST.matchCode(extendBO.getOnlineStatus())) && (receivingCount = csInfoBO.getReceivingCount()) > 0) {
                return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u6709\u6b63\u5728\u63a5\u5f85\u7684\u7528\u6237\uff0c\u6682\u65f6\u65e0\u6cd5\u5207\u6362\u5230\u8be5\u72b6\u6001\uff0c\u8bf7\u63a5\u5f85\u5b8c\u7528\u6237\u7136\u540e\u91cd\u8bd5");
            }
            CsInfo record = new CsInfo();
            record.setCsId(csInfoUpdateReqBO.getCsId());
            record.setLiveOnlineStatus(extendBO.getOnlineStatus());
            record.setLiveStatusCode(csInfoUpdateReqBO.getLiveStatusCode());
            record.setStatusChangeTime(csInfoUpdateReqBO.getStatusChangeTime());
            this.saveStatusChangeLog(csInfoUpdateReqBO);
            int update = this.csInfoMapper.updateByPrimaryKeySelective(record);
            if (update > 0 && CsOnlineStatus.CS_SIGN_IN.matchCode(extendBO.getOnlineStatus())) {
                CsFreeEventContext csFreeEventContext = CsFreeEventContext.builder().tenantCode(csInfoUpdateReqBO.getTenantCode()).csId(csInfoUpdateReqBO.getCsId()).build();
                log.info("\u5ba2\u670d\u72b6\u6001\u66f4\u65b0\u4e3a\u7b7e\u5165\u72b6\u6001,\u5c1d\u8bd5\u4ece\u6392\u961f\u961f\u5217\u62c9\u53d6\u7528\u6237:{}", (Object)csFreeEventContext);
                int free = csInfoBO.getReceiveLimit() - csInfoBO.getReceivingCount();
                int maxAllot = 0;
                while (++maxAllot < 10) {
                    Rsp<CsmAllotRspContext> contextRsp = this.csmCsAllotProcessService.processCsmFreeAllot(csFreeEventContext);
                    if (contextRsp.isSuccess()) {
                        --free;
                    }
                    if (free > 0 && (contextRsp.isSuccess() || contextRsp.getData() != null)) continue;
                    break;
                }
            }
            return BaseRspUtils.createSuccessRsp((Object)update, (String)"\u72b6\u6001\u66f4\u65b0\u6210\u529f!");
        }
        return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u72b6\u6001\u7801,\u8bf7\u68c0\u67e5\u72b6\u6001\u914d\u7f6e\u8868");
    }

    @MethodParamVerifyEnable
    public RspList getCsList(CsInfoQueryReqBO csInfoReqBO) {
        ArrayList list = Lists.newArrayList();
        log.info("\u5206\u9875\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f:{}", (Object)csInfoReqBO);
        if (StringUtils.isNotEmpty((CharSequence)csInfoReqBO.getSessionId())) {
            CsAllotAllotOrTransferReqBO reqBO = new CsAllotAllotOrTransferReqBO();
            reqBO.setTenantCode(csInfoReqBO.getTenantCode());
            reqBO.setSessionId(csInfoReqBO.getSessionId());
            reqBO.setCsId(csInfoReqBO.getExCsId());
            Rsp transferBORsp = this.csAllotOrTransferApi.getCsAllotOrTransferRecord(reqBO);
            if (transferBORsp.isSuccess()) {
                csInfoReqBO.setSkillGid(((CsAllotAllotOrTransferBO)transferBORsp.getData()).getAllotSkillGid());
            }
        }
        CsInfoQueryCondition condition = new CsInfoQueryCondition();
        BeanUtils.copyProperties((Object)csInfoReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)csInfoReqBO.getPage(), (int)csInfoReqBO.getLimit());
        this.csInfoMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), (List)list, CsInfoBO.class);
            for (CsInfoBO csInfoBO : list) {
                this.csInfoAboutInfo(csInfoBO, true, true, true, true, true);
                if (!StringUtils.isBlank((CharSequence)csInfoBO.getCsAvatar())) continue;
                csInfoBO.setCsAvatar(this.niccCsmConfigProperties.getCsDefaultAvatar());
            }
        }
        log.info("\u5206\u9875\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f:{} \u6761", (Object)list.size());
        return BaseRspUtils.createSuccessRspList((List)list, (long)page.getTotal());
    }

    public RspList getCsSimpleList(CsInfoQueryReqBO csInfoReqBO) {
        List<Object> list = Lists.newArrayList();
        log.info("\u5206\u9875\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f-simple:{}", (Object)csInfoReqBO);
        CsInfoQueryCondition condition = new CsInfoQueryCondition();
        BeanUtils.copyProperties((Object)csInfoReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)csInfoReqBO.getPage(), (int)csInfoReqBO.getLimit());
        this.csInfoMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), (List)list, CsInfoBO.class);
            for (CsInfoBO csInfoBO : list) {
                this.csInfoAboutInfo(csInfoBO, true, false, false, true, false);
                if (!StringUtils.isBlank((CharSequence)csInfoBO.getCsAvatar())) continue;
                csInfoBO.setCsAvatar(this.niccCsmConfigProperties.getCsDefaultAvatar());
            }
            list = list.stream().sorted(Comparator.comparing(CsInfoBO::getReceivingCount).reversed()).collect(Collectors.toList());
        }
        log.info("\u5206\u9875\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f:{} \u6761", (Object)list.size());
        return BaseRspUtils.createSuccessRspList((List)list, (long)page.getTotal());
    }

    public RspList<CsFriendsSkill> getCsSkillFriends(CsFriendsReqBO csFriendsReqBO) {
        log.info("\u5ba2\u670d\u597d\u53cb\u5217\u8868-\u67e5\u8be2:{} ms", (Object)csFriendsReqBO);
        long startTime = System.currentTimeMillis();
        ArrayList csFriendsSkills = Lists.newArrayList();
        List skillRels = this.csInfoMapper.selectSkillCsList(csFriendsReqBO.getTenantCode(), csFriendsReqBO.getCsId());
        Map<String, List<CsInfoSkillRel>> skillCsMap = skillRels.stream().collect(Collectors.groupingBy(CsInfoSkillRel::getSkillGid));
        HashMap cacheCs = new HashMap();
        HashMap cacheUnRead = new HashMap();
        skillCsMap.forEach((skillGid, csList) -> {
            CsFriendsSkill skill = new CsFriendsSkill();
            CsSkillGroupBO groupBO = this.csmCommonService.getSkillGroupInfo((String)skillGid);
            if (groupBO != null) {
                BeanUtils.copyProperties((Object)groupBO, (Object)skill);
                List<Object> friendsInfos = Lists.newArrayList();
                int countOnlineTotal = 0;
                int countUnReadTotal = 0;
                for (CsInfoSkillRel skillRel : csList) {
                    String key;
                    Integer unRead;
                    CsInfo csInfo = (CsInfo)cacheCs.get(skillRel.getCsId());
                    if (csInfo == null) {
                        csInfo = this.csInfoMapper.selectByPrimaryKey(skillRel.getCsId());
                        if (csInfo == null) continue;
                        cacheCs.put(skillRel.getCsId(), csInfo);
                    }
                    CsFriendsInfo friendsInfo = new CsFriendsInfo();
                    BeanUtils.copyProperties((Object)csInfo, (Object)friendsInfo);
                    if (friendsInfo.getLiveOnlineStatus() > 0) {
                        ++countOnlineTotal;
                    }
                    if ((unRead = (Integer)cacheUnRead.get(key = csFriendsReqBO.getCsId() + friendsInfo.getCsId())) == null) {
                        C2cUnreadCountReqBO c2cUnreadCountReqBO = new C2cUnreadCountReqBO();
                        c2cUnreadCountReqBO.setTenantCode(csFriendsReqBO.getTenantCode());
                        c2cUnreadCountReqBO.setFromNo(csFriendsReqBO.getCsId());
                        c2cUnreadCountReqBO.setToNo(friendsInfo.getCsId());
                        Rsp countRsp = this.imMessageService.getC2cUnReadCount(c2cUnreadCountReqBO);
                        log.info("\u5ba2\u670d\u597d\u53cb\u5217\u8868-\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u6570:{}-{}", (Object)friendsInfo.getCsId(), countRsp.getData());
                        unRead = (Integer)countRsp.getData();
                        cacheUnRead.put(key, unRead);
                    }
                    friendsInfo.setUnReadCount(unRead.intValue());
                    countUnReadTotal += unRead.intValue();
                    friendsInfos.add(friendsInfo);
                }
                friendsInfos = friendsInfos.stream().sorted(Comparator.comparing(CsFriendsInfo::getLiveOnlineStatus).reversed()).collect(Collectors.toList());
                skill.setFriends((List)friendsInfos);
                skill.setOnlineCount(countOnlineTotal);
                skill.setUnReadCount(countUnReadTotal);
                skill.setCsCount(friendsInfos.size());
                csFriendsSkills.add(skill);
            }
        });
        long endTime = System.currentTimeMillis();
        log.info("\u5ba2\u670d\u597d\u53cb\u5217\u8868-\u67e5\u8be2\u8017\u65f6:{} ms, csFriendsSkills = {},friends = {}", new Object[]{endTime - startTime, csFriendsSkills.size(), cacheCs.size()});
        return BaseRspUtils.createSuccessRspList((List)csFriendsSkills, (long)csFriendsSkills.size());
    }

    private void csInfoAboutInfo(CsInfoBO csInfoBO, boolean csStatus, boolean skills, boolean labels, boolean receiving, boolean signTime) {
        int count;
        CsStatusExtendBO extendBO;
        if (csStatus && (extendBO = this.csmCommonService.getCsExtendStatus(csInfoBO.getTenantCode(), csInfoBO.getLiveStatusCode())) != null) {
            csInfoBO.setLiveStatusName(extendBO.getStatusName());
        }
        if (skills) {
            List<CsSkillGroupInfo> csSkillGroups = this.csmCommonService.getCsSkillGidList(csInfoBO.getTenantCode(), csInfoBO.getCsId(), true);
            for (CsSkillGroupInfo csSkillGroup : csSkillGroups) {
                long queueCount = this.csmCsAllotHelper.getQueueCount(csInfoBO.getTenantCode(), csSkillGroup.getSkillGid());
                csSkillGroup.setQueueCount(queueCount);
            }
            csInfoBO.setCsSkillGroups(csSkillGroups);
        }
        if (receiving && (count = this.csmCommonService.receivingCount(csInfoBO.getTenantCode(), csInfoBO.getCsId()).intValue()) > 0) {
            csInfoBO.setReceivingCount(count);
        }
        if (labels) {
            CsLabelQueryReqBO csLabelQueryReqBO = new CsLabelQueryReqBO();
            csLabelQueryReqBO.setTenantCode(csInfoBO.getTenantCode());
            csLabelQueryReqBO.setCsId(csInfoBO.getCsId());
            RspList labelsRsp = this.csLabelApi.getCsLabels(csLabelQueryReqBO);
            if (labelsRsp.isSuccess()) {
                csInfoBO.setCsLabels(labelsRsp.getRows());
            }
        }
        if (signTime) {
            int signTimeSec = this.csmLogCommonService.countSignInTime(csInfoBO.getTenantCode(), csInfoBO.getCsId(), CsOnlineStatus.CS_SIGN_IN.getCode());
            csInfoBO.setOnlineDurationSec(signTimeSec);
        }
        try {
            String tenantName = "";
            Rsp rspTenant = this.bladeTenantService.queryById(csInfoBO.getTenantCode());
            if (rspTenant.isSuccess()) {
                tenantName = ((BladeTenantBO)rspTenant.getData()).getTenantName();
            }
            csInfoBO.setTenantName(tenantName);
        }
        catch (Exception e) {
            log.info("\u5ba2\u670d\u597d\u53cb\u5217\u8868-\u83b7\u53d6\u79df\u6237\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    private void saveStatusChangeLog(CsInfoUpdateReqBO reqBO) {
        CsStatusChangeLogSaveReqBO changeLogBO = new CsStatusChangeLogSaveReqBO();
        changeLogBO.setTenantCode(reqBO.getTenantCode());
        changeLogBO.setCsId(reqBO.getCsId());
        changeLogBO.setCurrStatus(reqBO.getLiveStatusCode());
        changeLogBO.setLoginId(reqBO.getLoginId());
        changeLogBO.setStartTime(reqBO.getStatusChangeTime());
        String lockKey = reqBO.getCsId() + reqBO.getLiveStatusCode();
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(lockKey).requestId(IdWorker.nextAutoIdStr()).build();
        try {
            this.csmLogCommonService.saveCsStatusChangeLog(changeLogBO);
        }
        catch (Exception e) {
            log.error("\u5750\u5e2d\u72b6\u6001\u53d8\u66f4-\u8bb0\u5f55\u4fdd\u5b58\u5f02\u5e38:", (Throwable)e);
        }
    }
}

