/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.csm.api.CsLabelApi;
import com.tydic.nicc.csm.api.bo.label.CsLabelBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelQueryReqBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelRelSaveReqBO;
import com.tydic.nicc.csm.api.bo.label.CsLabelSaveReqBO;
import com.tydic.nicc.csm.mapper.CsLabelMapper;
import com.tydic.nicc.csm.mapper.CsLabelRelMapper;
import com.tydic.nicc.csm.mapper.po.CsLabel;
import com.tydic.nicc.csm.mapper.po.CsLabelRel;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-csm")
@Service
public class CsLabelServiceImpl
implements CsLabelApi {
    private static final Logger log = LoggerFactory.getLogger(CsLabelServiceImpl.class);
    @Resource
    private CsLabelMapper csLabelMapper;
    @Resource
    private CsLabelRelMapper csLabelRelMapper;

    @Transactional
    @MethodParamVerifyEnable
    public Rsp saveCsLabel(CsLabelSaveReqBO csLabelSaveReqBO) {
        try {
            log.info("\u4fdd\u5b58\u5ba2\u670d\u6807\u7b7e\u4fe1\u606f:{}", (Object)csLabelSaveReqBO);
            CsLabel record = new CsLabel();
            csLabelSaveReqBO.setUpdateTime(new Date());
            BeanUtils.copyProperties((Object)csLabelSaveReqBO, (Object)record);
            int update = 0;
            if (StringUtils.isNotEmpty((CharSequence)csLabelSaveReqBO.getLabelId())) {
                update = this.csLabelMapper.updateSelectiveByPrimaryKey(record);
            } else {
                record.setLabelId(IdWorker.nextAutoIdStr());
                csLabelSaveReqBO.setLabelId(record.getLabelId());
                update = this.csLabelMapper.insertSelective(record);
            }
            if (update > 0) {
                return BaseRspUtils.createSuccessRsp((Object)csLabelSaveReqBO);
            }
            return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
        catch (Exception e) {
            log.error("\u5ba2\u670d\u6807\u7b7e\u4fe1\u606f\u4fdd\u5b58\u9519\u8bef:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6807\u7b7e\u4fe1\u606f\u4fdd\u5b58\u9519\u8bef:" + e.getMessage()));
        }
    }

    @MethodParamVerifyEnable
    public RspList getCsLabels(CsLabelQueryReqBO csLabelQueryReqBO) {
        ArrayList list = Lists.newArrayList();
        log.info("\u67e5\u8be2\u5ba2\u670d\u6807\u7b7e\u5217\u8868:{}", (Object)csLabelQueryReqBO);
        CsLabel condition = new CsLabel();
        BeanUtils.copyProperties((Object)csLabelQueryReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)csLabelQueryReqBO.getPage(), (int)csLabelQueryReqBO.getLimit());
        this.csLabelMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), (List)list, CsLabelBO.class);
        }
        return BaseRspUtils.createSuccessRspList((List)list, (long)page.getTotal());
    }

    @MethodParamVerifyEnable
    @Transactional
    public Rsp saveCsLabelRel(CsLabelRelSaveReqBO csLabelRelSaveReqBO) {
        log.info("\u4fdd\u5b58\u5ba2\u670d\u6807\u7b7e\u5173\u8054\u4fe1\u606f:{}", (Object)csLabelRelSaveReqBO);
        CsLabelRel record = new CsLabelRel();
        BeanUtils.copyProperties((Object)csLabelRelSaveReqBO, (Object)record);
        int count = this.csLabelRelMapper.existLabelRel(csLabelRelSaveReqBO.getTenantCode(), csLabelRelSaveReqBO.getCsId(), csLabelRelSaveReqBO.getLabelId());
        if (count > 0) {
            this.csLabelRelMapper.updateSelectiveByCondition(record);
        } else {
            this.csLabelRelMapper.insertSelective(record);
        }
        return BaseRspUtils.createSuccessRsp((Object)csLabelRelSaveReqBO);
    }
}

