/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.RobotQaType;
import com.tydic.nicc.common.eums.im.MsgFormType;
import com.tydic.nicc.csm.api.CsRobotManagerApi;
import com.tydic.nicc.csm.api.bo.robot.CsChatRobotInstanceBO;
import com.tydic.nicc.csm.api.bo.robot.CsChatRobotInstanceQueryReqBO;
import com.tydic.nicc.csm.api.bo.robot.CsChatRobotInstanceSaveReqBO;
import com.tydic.nicc.csm.api.bo.robot.CsRobotInstanceAttrBO;
import com.tydic.nicc.csm.api.bo.robot.CsRobotSimpleQaBO;
import com.tydic.nicc.csm.api.bo.robot.CsRobotSimpleQaQueryReqBO;
import com.tydic.nicc.csm.api.bo.robot.CsRobotSimpleQaSaveReqBO;
import com.tydic.nicc.csm.api.bo.robot.ImportRobotSimpleQAReqBO;
import com.tydic.nicc.csm.api.bo.robot.QueryTemplateBo;
import com.tydic.nicc.csm.api.bo.robot.RobotEnum;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsChatRobotInstanceMapper;
import com.tydic.nicc.csm.mapper.CsRobotInstanceAttrMapper;
import com.tydic.nicc.csm.mapper.CsRobotSimpleQaMapper;
import com.tydic.nicc.csm.mapper.po.CsChatRobotInstance;
import com.tydic.nicc.csm.mapper.po.CsChatRobotInstanceQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsRobotExcelBo;
import com.tydic.nicc.csm.mapper.po.CsRobotInstanceAttr;
import com.tydic.nicc.csm.mapper.po.CsRobotSimpleQa;
import com.tydic.nicc.csm.mapper.po.CsRobotSimpleQaQueryCondition;
import com.tydic.nicc.csm.utils.LocalCacheSyncHelper;
import com.tydic.nicc.csm.utils.LocalCacheUtil;
import com.tydic.nicc.csm.utils.excel.RobotSimpleQADTO;
import com.tydic.nicc.csm.utils.excel.listener.RobotSimpleQAListener;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.FileManagerHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.admin.api.FileManageService;
import com.tydic.nicc.im.bo.FileUploadReqBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@DS(value="nicc-csm")
@Service
public class CsRobotManagerServiceImpl
implements CsRobotManagerApi {
    private static final Logger log = LoggerFactory.getLogger(CsRobotManagerServiceImpl.class);
    @Resource
    private CsRobotSimpleQaMapper csRobotSimpleQaMapper;
    @Resource
    private CsChatRobotInstanceMapper csChatRobotInstanceMapper;
    @Resource
    private CsRobotInstanceAttrMapper csRobotInstanceAttrMapper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private FileManagerHelper fileManagerHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private FileManageService fileManageService;
    @Resource
    private LocalCacheSyncHelper localCacheSyncHelper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;

    @MethodParamVerifyEnable
    @Transactional
    public Rsp<CsChatRobotInstanceBO> saveRobotInstance(CsChatRobotInstanceSaveReqBO saveReqBO) {
        saveReqBO.setLastUpdTime(new Date());
        log.info("\u4fdd\u5b58\u673a\u5668\u4eba\u5b9e\u4f8b\u4fe1\u606f:{}", (Object)saveReqBO);
        CsChatRobotInstance record = new CsChatRobotInstance();
        BeanUtils.copyProperties((Object)saveReqBO, (Object)record);
        int update = 0;
        if (saveReqBO.getRobotInstanceId() != null) {
            update = this.csChatRobotInstanceMapper.updateSelectiveByInstanceId(record);
        } else {
            record.setRobotInstanceId(IdWorker.nextAutoIdStr());
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getIsValid())) {
                record.setIsValid(EntityValidType.NORMAL.getCode());
            }
            update = this.csChatRobotInstanceMapper.insertSelective(record);
        }
        if (update > 0) {
            if (ObjectUtils.anyNotNull((Object[])new Object[]{saveReqBO.getAttrs()})) {
                this.saveRobotInstanceAttrs(record.getTenantCode(), record.getRobotInstanceId(), saveReqBO.getAttrs());
            }
            return BaseRspUtils.createSuccessRsp((Object)this.getRobotInstanceById(record.getRobotInstanceId()), (String)"\u4fdd\u5b58\u6210\u529f!");
        }
        return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @MethodParamVerifyEnable
    public RspList<CsChatRobotInstanceBO> getRobotInstances(CsChatRobotInstanceQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u673a\u5668\u5b9e\u4f8b\u5217\u8868:{}", (Object)queryReqBO);
        ArrayList list = Lists.newArrayList();
        CsChatRobotInstanceQueryCondition condition = new CsChatRobotInstanceQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.csChatRobotInstanceMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), (List)list, CsChatRobotInstanceBO.class);
            for (CsChatRobotInstanceBO instanceBO : list) {
                instanceBO.setAttrs(this.getRobotInstanceAttrs(instanceBO.getRobotInstanceId()));
            }
        }
        return BaseRspUtils.createSuccessRspList((List)list);
    }

    @MethodParamVerifyEnable
    @Transactional
    public Rsp<CsRobotSimpleQaBO> saveRobotSimpleQa(CsRobotSimpleQaSaveReqBO saveReqBO) {
        saveReqBO.setLastUpdTime(new Date());
        if (!MsgFormType.CARD_MSG.getCode().equals(saveReqBO.getAnswerMsgType())) {
            saveReqBO.setAnswerMsgType(MsgFormType.HTML.getCode());
        }
        log.info("\u4fdd\u5b58\u673a\u5668\u4eba\u7b80\u5355\u95ee\u7b54\u914d\u7f6e\u4fe1\u606f:{}", (Object)saveReqBO);
        CsRobotSimpleQa record = new CsRobotSimpleQa();
        BeanUtils.copyProperties((Object)saveReqBO, (Object)record);
        int update = 0;
        String key = "";
        if (saveReqBO.getId() != null || !CollectionUtils.isEmpty((Collection)saveReqBO.getIdList())) {
            CsSkillGroupBO groupBO;
            if (StringUtils.isNotEmpty((CharSequence)saveReqBO.getRobotInstanceId()) && (groupBO = this.csmCommonService.getSkillGroupInfo(saveReqBO.getRobotInstanceId())) == null) {
                return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u6307\u5b9a\u98ce\u683c\u5931\u6548\u6216\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isNotEmpty((CharSequence)saveReqBO.getQuestion()) && this.checkExistQuestion(saveReqBO, true) > 0) {
                return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u8be5\u5b9e\u4f8b\u4e0b\u5173\u952e\u5b57\u5df2\u5b58\u5728");
            }
            List idList = saveReqBO.getIdList();
            if (saveReqBO.getId() != null) {
                idList.add(saveReqBO.getId());
            }
            for (Long id : idList) {
                CsRobotSimpleQa simpleQa = this.csRobotSimpleQaMapper.selectById(id);
                if (simpleQa != null) {
                    key = RedisCacheKeyConstant.getCsmRobotQaKey((String)simpleQa.getRobotInstanceId());
                    LocalCacheUtil.ROBOT_QA.remove(key);
                    log.info("\u4fdd\u5b58\u673a\u5668\u4eba\u7b80\u5355\u95ee\u7b54\u914d\u7f6e\u4fe1\u606f-\u79fb\u9664\u7f13\u5b58-key\uff1a{}", (Object)key);
                    record.setId(id);
                    String question = (String)CollectionUtils.firstElement((List)saveReqBO.getQuestionList());
                    if (StringUtils.isBlank((CharSequence)saveReqBO.getQuestion())) {
                        if (StringUtils.isNotEmpty((CharSequence)question) && RobotQaType.QA_REG.matchCode(saveReqBO.getQaType())) {
                            question = ("" + question.charAt(0)).equals("/") && ("" + question.charAt(question.length() - 1)).equals("/") ? question.substring(1, question.length() - 1) : question;
                        }
                    } else {
                        question = saveReqBO.getQuestion();
                    }
                    record.setQuestion(question);
                    update = this.csRobotSimpleQaMapper.updateSelectiveById(record);
                    if (CollectionUtils.isEmpty((Collection)saveReqBO.getQuestionList()) || saveReqBO.getQuestionList().size() <= 1) continue;
                    simpleQa = this.csRobotSimpleQaMapper.selectById(id);
                    saveReqBO.getQuestionList().remove(question);
                    for (String content : saveReqBO.getQuestionList()) {
                        saveReqBO.setQuestion(content);
                        if (this.checkExistQuestion(saveReqBO, true) > 0) {
                            return BaseRspUtils.createErrorRsp((String)("\u66f4\u65b0\u5931\u8d25:\u95ee\u9898\u3010" + content + "\u3011\u5df2\u5b58\u5728"));
                        }
                        simpleQa.setQuestion(content);
                        simpleQa.setId(Long.valueOf(IdWorker.nextAutoId()));
                        update += this.csRobotSimpleQaMapper.insertSelective(simpleQa);
                    }
                    continue;
                }
                return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:id\u4e0d\u5b58\u5728");
            }
        } else {
            CsSkillGroupBO groupBO;
            if (saveReqBO.getRobotId() == null) {
                saveReqBO.setRobotId(Long.valueOf(0L));
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getRobotInstanceId())) {
                record.setRobotInstanceId(saveReqBO.getTenantCode());
                saveReqBO.setRobotInstanceId(saveReqBO.getTenantCode());
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getQaType())) {
                return BaseRspUtils.createErrorRsp((String)"qaType\u4e0d\u5f97\u4e3a\u7a7a");
            }
            if (!RobotQaType.QA_REG.matchCode(saveReqBO.getQaType()) && !RobotQaType.QA_KEYWORD.matchCode(saveReqBO.getQaType())) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5339\u914d\u7c7b\u578b");
            }
            if (StringUtils.isBlank((CharSequence)saveReqBO.getQuestion())) {
                if (CollectionUtils.isEmpty((Collection)saveReqBO.getQuestionList())) {
                    return BaseRspUtils.createErrorRsp((String)"questionList\u4e0d\u5f97\u4e3a\u7a7a");
                }
                HashSet set = new HashSet(saveReqBO.getQuestionList());
                if (set.size() != saveReqBO.getQuestionList().size()) {
                    return BaseRspUtils.createErrorRsp((String)"\u5173\u952e\u5b57\u91cd\u590d");
                }
                for (String question : saveReqBO.getQuestionList()) {
                    saveReqBO.setQuestion(question);
                    int i = this.checkExistQuestion(saveReqBO, false);
                    if (i <= 0) continue;
                    return BaseRspUtils.createErrorRsp((String)("\u65b0\u589e\u5931\u8d25:\u95ee\u9898:\u3010" + question + "\u3011\u5df2\u5b58\u5728"));
                }
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getAnswerMsgType())) {
                return BaseRspUtils.createErrorRsp((String)"answerMsgType\u4e0d\u5f97\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getAnswerMsgContent())) {
                return BaseRspUtils.createErrorRsp((String)"answerMsgContent\u4e0d\u5f97\u4e3a\u7a7a");
            }
            if (!saveReqBO.getTenantCode().equals(record.getRobotInstanceId()) && (groupBO = this.csmCommonService.getSkillGroupInfo(saveReqBO.getRobotInstanceId())) == null) {
                return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25:\u6307\u5b9a\u98ce\u683c\u5931\u6548\u6216\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getIsValid())) {
                record.setIsValid(EntityValidType.NORMAL.getCode());
            }
            key = RedisCacheKeyConstant.getCsmRobotQaKey((String)saveReqBO.getRobotInstanceId());
            LocalCacheUtil.ROBOT_QA.remove(key);
            log.info("\u4fdd\u5b58\u673a\u5668\u4eba\u7b80\u5355\u95ee\u7b54\u914d\u7f6e\u4fe1\u606f-\u79fb\u9664\u7f13\u5b58-key\uff1a{}", (Object)key);
            if (StringUtils.isNotEmpty((CharSequence)record.getQuestion()) && CollectionUtils.isEmpty((Collection)saveReqBO.getQuestionList())) {
                saveReqBO.setQuestionList(Arrays.asList(record.getQuestion()));
            }
            for (String question : saveReqBO.getQuestionList()) {
                if (StringUtils.isBlank((CharSequence)question)) continue;
                if (RobotQaType.QA_REG.matchCode(saveReqBO.getQaType())) {
                    question = ("" + question.charAt(0)).equals("/") && ("" + question.charAt(question.length() - 1)).equals("/") ? question.substring(1, question.length() - 1) : question;
                }
                record.setQuestion(question);
                record.setId(Long.valueOf(IdWorker.nextAutoId()));
                record.setRobotId(Long.valueOf(0L));
                update = this.csRobotSimpleQaMapper.insertSelective(record);
            }
        }
        if (update > 0) {
            this.localCacheSyncHelper.clearRobotQaCache(saveReqBO.getTenantCode(), key);
            return BaseRspUtils.createSuccessRsp((Object)this.getRobotQaById(record.getId()), (String)"\u4fdd\u5b58\u6210\u529f!");
        }
        return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25!");
    }

    private int checkExistQuestion(CsRobotSimpleQaSaveReqBO saveReqBO, boolean isUpdate) {
        CsRobotSimpleQaQueryCondition condition = new CsRobotSimpleQaQueryCondition();
        condition.setTenantCode(saveReqBO.getTenantCode());
        condition.setRobotInstanceId(saveReqBO.getRobotInstanceId());
        condition.setQuestion(saveReqBO.getQuestion());
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        List list = this.csRobotSimpleQaMapper.selectByCondition(condition);
        if (isUpdate ? !list.isEmpty() && StringUtils.isNotEmpty((CharSequence)saveReqBO.getRobotInstanceId()) && !((CsRobotSimpleQa)list.get(0)).getRobotInstanceId().equals(saveReqBO.getRobotInstanceId()) : !list.isEmpty()) {
            return 1;
        }
        return 0;
    }

    @MethodParamVerifyEnable
    public RspList<CsRobotSimpleQaBO> getRobotSimpleQaList(CsRobotSimpleQaQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u673a\u5668\u4eba\u7b80\u5355\u95ee\u7b54\u914d\u7f6e\u5217\u8868:{}", (Object)JSON.toJSONString((Object)queryReqBO));
        List<Object> list = Lists.newArrayList();
        if (queryReqBO.isResultCache() && StringUtils.isNotEmpty((CharSequence)queryReqBO.getRobotInstanceId())) {
            String key = RedisCacheKeyConstant.getCsmRobotQaKey((String)queryReqBO.getRobotInstanceId());
            list = LocalCacheUtil.ROBOT_QA.get(key);
            if (ObjectUtils.anyNotNull((Object[])new Object[]{list}) && list.size() > 0) {
                log.info("\u67e5\u8be2\u673a\u5668\u4eba\u7b80\u5355\u95ee\u7b54\u914d\u7f6e\u5217\u8868,\u7f13\u5b58\u547d\u4e2d:{} \u6761", (Object)list.size());
                return BaseRspUtils.createSuccessRspList(list, (long)list.size());
            }
            list = Lists.newArrayList();
        }
        CsRobotSimpleQaQueryCondition condition = new CsRobotSimpleQaQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.csRobotSimpleQaMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), list, CsRobotSimpleQaBO.class);
        }
        if (queryReqBO.isResultCache() && ObjectUtils.allNotNull((Object[])new Object[]{queryReqBO.getRobotInstanceId(), list}) && !list.isEmpty()) {
            String key = RedisCacheKeyConstant.getCsmRobotQaKey((String)queryReqBO.getRobotInstanceId());
            LocalCacheUtil.ROBOT_QA.put(key, list);
        }
        log.info("\u67e5\u8be2\u673a\u5668\u4eba\u7b80\u5355\u95ee\u7b54\u914d\u7f6e\u5217\u8868:{} \u6761", (Object)list.size());
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }

    @Transactional
    public RspList importRobotSampleQA(ImportRobotSimpleQAReqBO reqBO) {
        log.info("\u5bfc\u5165\u673a\u5668\u4eba\u95ee\u7b54\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        String accessUrl = reqBO.getAccessUrl();
        String router = this.niccCsmConfigProperties.getDownRouter();
        String downFileName = accessUrl.substring(accessUrl.indexOf(router) + router.length());
        InputStream inputStream = this.fileManagerHelper.downloadFile(downFileName);
        RobotSimpleQAListener listener = new RobotSimpleQAListener();
        EasyExcel.read((InputStream)inputStream, RobotSimpleQADTO.class, (ReadListener)listener).sheet().doRead();
        List<RobotSimpleQADTO> record = listener.getRecord();
        if (CollectionUtils.isEmpty(record)) {
            return BaseRspUtils.createErrorRspList((String)"\u6587\u4ef6\u4e0d\u5f97\u4e3a\u7a7a");
        }
        ArrayList<RobotSimpleQADTO> errList = new ArrayList<RobotSimpleQADTO>();
        for (RobotSimpleQADTO dto : record) {
            Rsp<CsRobotSimpleQaBO> res;
            CsRobotSimpleQaSaveReqBO bo = new CsRobotSimpleQaSaveReqBO();
            BeanUtils.copyProperties((Object)dto, (Object)bo);
            bo.setTenantCode(reqBO.getTenantCode());
            bo.setQuestionList(new ArrayList<String>(Collections.singletonList(dto.getQuestion())));
            if (RobotEnum.KEYWORDS_QA.getName().equals(bo.getQaType())) {
                bo.setQaType(RobotEnum.KEYWORDS_QA.getCode());
            }
            if (RobotEnum.REGULAR_QA.getName().equals(bo.getQaType())) {
                bo.setQaType(RobotEnum.REGULAR_QA.getCode());
            }
            if ((res = this.saveRobotSimpleQa(bo)).isSuccess()) continue;
            dto.setFailedReason(res.getRspDesc());
            errList.add(dto);
        }
        if (errList.size() == 0) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        List fileManageSaveBOS = null;
        try {
            String fileName = "\u673a\u5668\u4eba\u95ee\u7b54\u5bfc\u5165\u5931\u8d25" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xlsx";
            String tempPath = System.getProperty("java.io.tmpdir");
            File dirFile = new File(tempPath + "/" + fileName);
            EasyExcel.write((File)dirFile, RobotSimpleQADTO.class).sheet().doWrite(errList);
            MockMultipartFile multipartFile = new MockMultipartFile(fileName, dirFile.getAbsolutePath(), null, (InputStream)new FileInputStream(dirFile));
            MultipartFile[] files = new MultipartFile[]{multipartFile};
            String month = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMM");
            fileManageSaveBOS = this.fileManagerHelper.saveFiles(files, month);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8868\u683c\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u521b\u5efa\u8868\u683c\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)fileManageSaveBOS)) {
            return BaseRspUtils.createErrorRspList((String)"\u673a\u5668\u4eba\u95ee\u7b54\u5bfc\u5165\uff1a\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
        FileUploadReqBO fileUploadReqBO = new FileUploadReqBO();
        fileUploadReqBO.setServerIp(NiccCommonUtil.getIpAddress());
        fileUploadReqBO.setSaveResults(fileManageSaveBOS);
        return this.fileManageService.fileUpload(fileUploadReqBO);
    }

    public RspList exportRobotSampleQA(CsRobotSimpleQaQueryReqBO reqBO) {
        log.info("\u5bfc\u51fa\u673a\u5668\u4eba\u95ee\u7b54\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        CsRobotSimpleQaQueryCondition robotSimpleQa = new CsRobotSimpleQaQueryCondition();
        reqBO.setIsValid("1");
        BeanUtils.copyProperties((Object)reqBO, (Object)robotSimpleQa);
        List robotExcelBoList = this.csRobotSimpleQaMapper.selectExcelRobotCon(robotSimpleQa);
        if (CollectionUtils.isEmpty((Collection)robotExcelBoList)) {
            return BaseRspUtils.createSuccessRspList(null, (long)0L);
        }
        log.info("\u673a\u5668\u4eba\u95ee\u7b54\u914d\u7f6e\u67e5\u627e\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u6761\u6570\u4e3a={}", (Object)JSON.toJSONString((Object)robotExcelBoList.size()));
        return this.createUploadExcel(robotExcelBoList, CsRobotExcelBo.class);
    }

    private RspList createUploadExcel(List<?> exportBOList, Class clazz) {
        try {
            String fileName = "\u673a\u5668\u4eba\u95ee\u7b54\u914d\u7f6e" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xlsx";
            String tempPath = System.getProperty("java.io.tmpdir");
            File dirFile = new File(tempPath + "/" + fileName);
            EasyExcel.write((File)dirFile, CsRobotExcelBo.class).sheet("\u673a\u5668\u4eba\u95ee\u7b54\u914d\u7f6e\u5bfc\u51fa").doWrite(exportBOList);
            MockMultipartFile multipartFile = new MockMultipartFile(fileName, dirFile.getAbsolutePath(), null, (InputStream)new FileInputStream(dirFile));
            MultipartFile[] files = new MultipartFile[]{multipartFile};
            String month = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMM");
            List fileManageSaveBOS = this.fileManagerHelper.saveFiles(files, month);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fileManageSaveBOS));
            if (CollectionUtils.isEmpty((Collection)fileManageSaveBOS)) {
                return BaseRspUtils.createErrorRspList((String)"\u4e0a\u4f20\u673a\u5668\u4eba\u95ee\u7b54\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            }
            FileUploadReqBO fileUploadReqBO = new FileUploadReqBO();
            fileUploadReqBO.setServerIp(NiccCommonUtil.getIpAddress());
            fileUploadReqBO.setSaveResults(fileManageSaveBOS);
            this.fileManageService.fileUpload(fileUploadReqBO);
            return BaseRspUtils.createSuccessRspList((List)fileManageSaveBOS);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u521b\u5efa\u673a\u5668\u4eba\u95ee\u7b54\u914d\u7f6e\u8868\u683c\u5931\u8d25");
        }
    }

    public CsRobotSimpleQaBO getRobotQaById(Long id) {
        CsRobotSimpleQaBO simpleQaBO = null;
        CsRobotSimpleQa simpleQa = this.csRobotSimpleQaMapper.selectById(id);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{simpleQa})) {
            simpleQaBO = new CsRobotSimpleQaBO();
            BeanUtils.copyProperties((Object)simpleQa, (Object)simpleQaBO);
        }
        log.info("\u67e5\u8be2\u673a\u5668\u4eba\u7b80\u5355\u95ee\u7b54\u914d\u7f6e:{}", (Object)simpleQaBO);
        return simpleQaBO;
    }

    public CsChatRobotInstanceBO getRobotInstanceById(String instanceId) {
        CsChatRobotInstanceBO instanceBO = null;
        CsChatRobotInstance instance = this.csChatRobotInstanceMapper.selectByInstanceId(instanceId);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{instance})) {
            instanceBO = new CsChatRobotInstanceBO();
            BeanUtils.copyProperties((Object)instance, (Object)instanceBO);
            List<CsRobotInstanceAttrBO> attrBOS = this.getRobotInstanceAttrs(instanceId);
            instanceBO.setAttrs(attrBOS);
        }
        log.info("\u67e5\u8be2\u673a\u5668\u4eba\u5b9e\u4f8b:{}", (Object)instanceBO);
        return instanceBO;
    }

    private void saveRobotInstanceAttrs(String instanceId, String tenantCode, List<CsRobotInstanceAttrBO> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        this.csRobotInstanceAttrMapper.deleteByInstanceId(instanceId);
        for (CsRobotInstanceAttrBO attr : attrs) {
            CsRobotInstanceAttr record = new CsRobotInstanceAttr();
            BeanUtils.copyProperties((Object)attr, (Object)record);
            record.setRobotInstanceId(instanceId);
            record.setTenantCode(tenantCode);
            record.setId(Long.valueOf(IdWorker.nextAutoId()));
            this.csRobotInstanceAttrMapper.insertSelective(record);
        }
    }

    private List<CsRobotInstanceAttrBO> getRobotInstanceAttrs(String instanceId) {
        ArrayList list = Lists.newArrayList();
        List attrs = this.csRobotInstanceAttrMapper.selectByRobotInstanceId(instanceId);
        NiccCommonUtil.copyList((List)attrs, (List)list, CsRobotInstanceAttrBO.class);
        return list;
    }

    public Rsp queryTemplate(QueryTemplateBo batchTem) {
        log.info("\u6a21\u677f\u67e5\u8be2\u5165\u53c2\u4e3a:{}", (Object)batchTem.getBatchTem());
        if (ObjectUtils.isEmpty((Object)batchTem.getBatchTem())) {
            BaseRspUtils.createErrorRsp((String)"batch\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165");
        }
        if ("robot".equals(batchTem.getBatchTem())) {
            String filePath = this.niccCsmConfigProperties.getRobotTemplateAddress();
            log.info("\u67e5\u8be2\u6a21\u677f\u4e3a: {}", (Object)filePath);
            return BaseRspUtils.createSuccessRsp((Object)filePath, (String)"\u673a\u5668\u4eba\u6a21\u677f\u5730\u5740\u67e5\u8be2\u6210\u529f");
        }
        if ("commentSentence".equals(batchTem.getBatchTem())) {
            String filePath = this.niccCsmConfigProperties.getSentenceTemplateAddress();
            log.info("\u67e5\u8be2\u6a21\u677f\u4e3a: {}", (Object)filePath);
            return BaseRspUtils.createSuccessRsp((Object)filePath, (String)"\u5e38\u7528\u8bed\u6a21\u677f\u5730\u5740\u67e5\u8be2\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5bfc\u5165\u6a21\u677f\u7c7b\u578b: robot/sentence");
    }
}

