/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.csm.CsmQueueCountReqBO;
import com.tydic.nicc.common.bo.csm.CsmUserQueueContext;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.AutoReplyType;
import com.tydic.nicc.common.eums.csm.CsChannelType;
import com.tydic.nicc.common.eums.csm.CsScheduleType;
import com.tydic.nicc.common.eums.csm.CsWorkScheduleLevel;
import com.tydic.nicc.csm.api.CsSkillGroupApi;
import com.tydic.nicc.csm.api.bo.channel.CsChannelBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsItemCacheBO;
import com.tydic.nicc.csm.api.bo.cs.CsSkillRelBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleQueryReqBO;
import com.tydic.nicc.csm.api.bo.eum.SyncSkillType;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupItemsBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupItemsReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupRelSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.SkillCsListSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.SkillGroupItem;
import com.tydic.nicc.csm.api.bo.skill.SkillGroupQueueUser;
import com.tydic.nicc.csm.api.bo.skill.SkillMemberSaveReqBO;
import com.tydic.nicc.csm.api.bo.skill.SkillRelInfoContext;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsInfoMapper;
import com.tydic.nicc.csm.mapper.CsInfoSkillRelMapper;
import com.tydic.nicc.csm.mapper.CsSkillGroupMapper;
import com.tydic.nicc.csm.mapper.po.CsInfoSkillRel;
import com.tydic.nicc.csm.mapper.po.CsSkillGroup;
import com.tydic.nicc.csm.mapper.po.CsSkillGroupQueryCondition;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.admin.api.BladeTenantService;
import com.tydic.nicc.im.bo.BladeTenantBO;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import com.tydic.nicc.user.api.UserOptionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-csm")
@Service
public class CsSkillGroupServiceImpl
implements CsSkillGroupApi {
    private static final Logger log = LoggerFactory.getLogger(CsSkillGroupServiceImpl.class);
    @Resource
    private CsSkillGroupMapper csSkillGroupMapper;
    @Resource
    private CsInfoSkillRelMapper csInfoSkillRelMapper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private CsmItemCountService csmItemCountService;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private CsInfoMapper csInfoMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=1000, check=false)
    private BladeTenantService bladeTenantService;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;

    public Rsp getSkillItems(CsSkillGroupItemsReqBO reqBO) {
        log.info("\u67e5\u8be2\u6280\u80fd\u7ec4\u6307\u6807-\u5f00\u59cb:{}", (Object)reqBO);
        CsSkillGroupItemsBO itemsBO = new CsSkillGroupItemsBO();
        itemsBO.setTenantCode(reqBO.getTenantCode());
        ArrayList items = Lists.newArrayList();
        List<SkillGroupQueueUser> queueUsersAll = this.getQueueUsers(reqBO);
        log.info("\u67e5\u8be2\u6280\u80fd\u7ec4\u6307\u6807-\u6392\u961f\u961f\u5217:{}", queueUsersAll);
        queueUsersAll.stream().sorted(Comparator.comparing(SkillGroupQueueUser::getWaitTime).reversed()).collect(Collectors.toList());
        Map<String, List<SkillGroupQueueUser>> groupQueueUserMap = queueUsersAll.stream().collect(Collectors.groupingBy(SkillGroupQueueUser::getSkillGid));
        for (Map.Entry<String, List<SkillGroupQueueUser>> listEntry : groupQueueUserMap.entrySet()) {
            SkillGroupItem item = new SkillGroupItem();
            item.setSkillGid(listEntry.getKey());
            item.setQueueCount(listEntry.getValue().size());
            item.setSkillGroupName(listEntry.getValue().get(0).getSkillName());
            items.add(item);
        }
        itemsBO.setQueueTotal(queueUsersAll.size());
        itemsBO.setItems((List)items);
        itemsBO.setQueueUsers(queueUsersAll);
        int onlineTotal = this.csInfoMapper.countOnlineCsAll(reqBO.getTenantCode(), reqBO.getTenantCodeList(), reqBO.getSkillGid());
        itemsBO.setOnlineTotal(onlineTotal);
        log.info("\u67e5\u8be2\u6280\u80fd\u7ec4\u6307\u6807-\u5728\u7ebf\u4eba\u6570\u7edf\u8ba1:{}", (Object)onlineTotal);
        return BaseRspUtils.createSuccessRsp((Object)itemsBO);
    }

    private List<SkillGroupQueueUser> getQueueUsers(CsSkillGroupItemsReqBO reqBO) {
        List<CsmUserQueueContext> queueContexts = this.csmCsAllotHelper.getSystemQueueList();
        ArrayList queueUsers = Lists.newArrayList();
        HashMap<String, String> tenantMap = new HashMap<String, String>();
        if (queueContexts != null) {
            long outTime = System.currentTimeMillis();
            for (CsmUserQueueContext context : queueContexts) {
                if ("platform".equals(reqBO.getTenantCode())) {
                    if (reqBO.getTenantCodeList() != null) {
                        if (reqBO.getTenantCodeList().size() == 0) {
                            reqBO.getTenantCodeList().add(reqBO.getTenantCode());
                        }
                        if (!reqBO.getTenantCodeList().contains(context.getTenantCode())) {
                            continue;
                        }
                    }
                } else if (!context.getTenantCode().equals(reqBO.getTenantCode())) continue;
                context.setQueueOutTime(outTime);
                Rsp userRsp = this.userOptionService.getUserAuthInfo(context.getTenantCode(), context.getUserId());
                SkillGroupQueueUser queueUser = new SkillGroupQueueUser();
                queueUser.setTenantName(this.getTenantName(tenantMap, context.getTenantCode()));
                queueUser.setQueueContext(context);
                queueUser.setAuthInfo((UserAuthInfo)userRsp.getData());
                queueUser.setSkillName(this.getSkillName(context.getAllotSkillGid()));
                queueUser.setSkillGid(context.getAllotSkillGid());
                queueUsers.add(queueUser);
            }
        }
        return queueUsers;
    }

    private String getSkillName(String skillGid) {
        CsSkillGroupBO groupBO = this.csmCommonService.getSkillGroupInfo(skillGid);
        if (groupBO != null) {
            return groupBO.getSkillGroupName();
        }
        return "";
    }

    private String getTenantName(Map<String, String> tenantMap, String tenantCode) {
        String tenantName = tenantMap.get(tenantCode);
        try {
            Rsp rspTenant;
            if (StringUtils.isBlank((CharSequence)tenantName) && (rspTenant = this.bladeTenantService.queryById(tenantCode)).isSuccess() && rspTenant.getData() != null) {
                tenantName = ((BladeTenantBO)rspTenant.getData()).getTenantName();
                tenantMap.put(tenantCode, tenantName);
            }
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u6280\u80fd\u7ec4\u6307\u6807-\u83b7\u53d6\u79df\u6237\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return tenantName;
    }

    @MethodParamVerifyEnable
    public Rsp saveSkillMembers(SkillMemberSaveReqBO saveReqBO) {
        log.info("\u7ed1\u5b9a\u6280\u80fd\u7ec4\u6210\u5458:{}", (Object)saveReqBO);
        CsSkillGroup skillGroup = this.csSkillGroupMapper.selectByPrimaryKey(saveReqBO.getSkillGid());
        if (skillGroup == null || EntityValidType.DELETE.getCode().equals(skillGroup.getIsValid())) {
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u8be5\u6280\u80fd\u7ec4\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isEmpty((CharSequence)EntityValidType.getNameByCode((String)saveReqBO.getIsValid()))) {
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u64cd\u4f5c\u72b6\u6001\u9519\u8bef!");
        }
        for (String csId : saveReqBO.getCsIds()) {
            CsInfoSkillRel skillRel = this.csInfoSkillRelMapper.selectSkillRel(saveReqBO.getTenantCode(), csId, saveReqBO.getSkillGid());
            if (saveReqBO.getIsValid().equals(EntityValidType.NORMAL.getCode())) {
                if (skillRel == null) {
                    this.saveSkillRel(saveReqBO.getTenantCode(), saveReqBO.getSkillGid(), csId);
                } else if (skillRel.getIsValid().equals(EntityValidType.DELETE.getCode())) {
                    this.csInfoSkillRelMapper.deleteByPrimaryKey(skillRel.getRelId());
                    this.saveSkillRel(saveReqBO.getTenantCode(), saveReqBO.getSkillGid(), csId);
                }
            } else if (skillRel != null) {
                this.csInfoSkillRelMapper.deleteByPrimaryKey(skillRel.getRelId());
            }
            this.csmItemCountService.countAllCsAllotItems(saveReqBO.getTenantCode(), Collections.singletonList(csId));
            if (!this.niccCsmConfigProperties.getSendSkillUpdateMsg().booleanValue()) continue;
            this.sendMq(csId, saveReqBO, skillGroup, skillRel);
        }
        return BaseRspUtils.createSuccessRsp((Object)saveReqBO.getCsIds());
    }

    private void sendMq(String csId, SkillMemberSaveReqBO saveReqBO, CsSkillGroup skillGroup, CsInfoSkillRel skillRel) {
        SkillRelInfoContext context = new SkillRelInfoContext();
        this.packSkillRel(context, csId, saveReqBO, skillGroup, skillRel);
        this.kkMqProducerHelper.sendMsg("CSM_SKILL_UPDATE", (Object)context);
        this.packSkillInfo(context, skillGroup);
        this.kkMqProducerHelper.sendMsg("CSM_SKILL_UPDATE", (Object)context);
    }

    private void packSkillRel(SkillRelInfoContext context, String csId, SkillMemberSaveReqBO saveReqBO, CsSkillGroup skillGroup, CsInfoSkillRel skillRel) {
        SkillRelInfoContext.CsSkillRel data = new SkillRelInfoContext.CsSkillRel();
        data.setTenantCode(saveReqBO.getTenantCode());
        data.setIsValid(saveReqBO.getIsValid());
        data.setSkillGid(saveReqBO.getSkillGid());
        data.setSkillGroupName(skillGroup.getSkillGroupName());
        data.setCsId(csId);
        if (ObjectUtils.isEmpty((Object)skillRel)) {
            data.setCrtTime(new Date());
        } else {
            data.setCrtTime(skillRel.getCreateTime());
        }
        context.setOpType(SyncSkillType.UPDATE_SKILL_REL.getCode());
        context.setData((Object)data);
    }

    private void packSkillInfo(SkillRelInfoContext context, CsSkillGroup skillGroup) {
        SkillRelInfoContext.SkillInfo data = new SkillRelInfoContext.SkillInfo();
        BeanUtils.copyProperties((Object)skillGroup, (Object)data);
        context.setOpType(SyncSkillType.UPDATE_SKILL_INFO.getCode());
        context.setData((Object)data);
    }

    private void saveSkillRel(String tenantCode, String skillId, String csId) {
        CsInfoSkillRel record = new CsInfoSkillRel();
        record.setRelId(IdWorker.nextAutoIdStr());
        record.setTenantCode(tenantCode);
        record.setSkillGid(skillId);
        record.setCsId(csId);
        record.setIsValid(EntityValidType.NORMAL.getCode());
        record.setCreateTime(new Date());
        this.csInfoSkillRelMapper.insertSelective(record);
    }

    public Rsp getRtQueueCount(CsmQueueCountReqBO csmQueueCountReqBO) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{csmQueueCountReqBO.getCsId(), csmQueueCountReqBO.getSkillGid()})) {
            long count = 0L;
            if (StringUtils.isNotEmpty((CharSequence)csmQueueCountReqBO.getSkillGid())) {
                count += this.csmCsAllotHelper.getQueueCount(csmQueueCountReqBO.getTenantCode(), csmQueueCountReqBO.getSkillGid());
            } else {
                Rsp csItemRsp = this.csmItemCountService.getCsAllotItem(csmQueueCountReqBO.getTenantCode(), csmQueueCountReqBO.getCsId());
                List skillGids = null;
                if (csItemRsp.isSuccess()) {
                    List csSkillGroups = ((CsItemCacheBO)csItemRsp.getData()).getCsSkillGroups();
                    skillGids = csSkillGroups.stream().map(obj -> obj.getSkillGid()).collect(Collectors.toList());
                } else {
                    skillGids = this.csInfoSkillRelMapper.selectSkillGids(csmQueueCountReqBO.getTenantCode(), csmQueueCountReqBO.getCsId());
                }
                if (skillGids != null) {
                    for (String skillGid : skillGids) {
                        count += this.csmCsAllotHelper.getQueueCount(csmQueueCountReqBO.getTenantCode(), skillGid);
                    }
                }
            }
            return BaseRspUtils.createSuccessRsp((Object)count);
        }
        log.error("\u83b7\u53d6\u6392\u961f\u6570\u636e\u5f02\u5e38,\u53c2\u6570\u9519\u8bef:{}", (Object)csmQueueCountReqBO);
        return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u6392\u961f\u6570\u636e\u5f02\u5e38:\u53c2\u6570\u9519\u8bef!");
    }

    @MethodParamVerifyEnable
    public Rsp getSkillByTag(CsSkillGroupReqBO groupReqBO) {
        String skillGid;
        CsSkillGroup skillGroup;
        List groups;
        CsSkillGroupBO groupBO = new CsSkillGroupBO();
        if (StringUtils.isNotEmpty((CharSequence)groupReqBO.getSkillGroupTag()) && (groups = this.csSkillGroupMapper.selectByTagCode(groupReqBO.getTenantCode(), groupReqBO.getSkillGroupTag())) != null && !groups.isEmpty()) {
            BeanUtils.copyProperties(groups.get(0), (Object)groupBO);
            return BaseRspUtils.createSuccessRsp((Object)groupBO);
        }
        if (StringUtils.isNotEmpty((CharSequence)groupReqBO.getChannelCode()) && (skillGroup = this.csSkillGroupMapper.selectByPrimaryKey(skillGid = groupReqBO.getChannelCode().replace("h5", "").replace("pc", ""))) != null) {
            BeanUtils.copyProperties((Object)skillGroup, (Object)groupBO);
            return BaseRspUtils.createSuccessRsp((Object)groupBO);
        }
        return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u6280\u80fd\u7ec4\u4fe1\u606f");
    }

    @MethodParamVerifyEnable
    public RspList getCsSkillGroupList(CsSkillGroupReqBO groupReqBO) {
        ArrayList list = Lists.newArrayList();
        CsSkillGroupQueryCondition condition = new CsSkillGroupQueryCondition();
        BeanUtils.copyProperties((Object)groupReqBO, (Object)condition);
        log.info("\u6761\u4ef6\u67e5\u8be2\u6280\u80fd\u7ec4:{}", (Object)condition);
        Page page = PageHelper.startPage((int)groupReqBO.getPage(), (int)groupReqBO.getLimit());
        this.csSkillGroupMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), (List)list, CsSkillGroupBO.class);
            for (CsSkillGroupBO csSkillGroupBO : list) {
                csSkillGroupBO.setCsChannels(this.getSkillChannels(csSkillGroupBO));
                CsWorkScheduleQueryReqBO queryReqBO = new CsWorkScheduleQueryReqBO();
                queryReqBO.setLimit(100);
                queryReqBO.setTenantCode(csSkillGroupBO.getTenantCode());
                queryReqBO.setConfigLevel(CsWorkScheduleLevel.SKILL_GROUP.getCode());
                queryReqBO.setConfigLevelVal(csSkillGroupBO.getSkillGid());
                RspList<CsWorkScheduleBO> queryRspList = this.csmCommonService.getCsWorkSchedules(queryReqBO);
                csSkillGroupBO.setCsWorkSchedules(queryRspList.getRows());
                CsAutoReplyConfigQueryReqBO queryAutoReplyReqBO = new CsAutoReplyConfigQueryReqBO();
                queryAutoReplyReqBO.setLimit(100);
                queryAutoReplyReqBO.setTenantCode(csSkillGroupBO.getTenantCode());
                queryAutoReplyReqBO.setConfigLevel(CsWorkScheduleLevel.SKILL_GROUP.getCode());
                queryAutoReplyReqBO.setConfigLevelVal(csSkillGroupBO.getSkillGid());
                RspList<CsAutoReplyConfigBO> queryAutoReplyRspList = this.csmCommonService.getCsAutoReplyConfigs(queryAutoReplyReqBO);
                csSkillGroupBO.setCsAutoReplyConfigs(queryAutoReplyRspList.getRows());
                CsInfoQueryReqBO queryReqBO1 = new CsInfoQueryReqBO();
                queryReqBO1.setSkillGid(csSkillGroupBO.getSkillGid());
                queryReqBO1.setTenantCode(csSkillGroupBO.getTenantCode());
                List<CsInfoBO> csInfoBOS = this.csmCommonService.getCsListBySkillId(queryReqBO1);
                csSkillGroupBO.setCsCount(csInfoBOS.size());
            }
        }
        return BaseRspUtils.createSuccessRspList((List)list);
    }

    public RspList getSimpleSkillGroupList(CsSkillGroupReqBO groupReqBO) {
        ArrayList list = Lists.newArrayList();
        CsSkillGroupQueryCondition condition = new CsSkillGroupQueryCondition();
        condition.setTenantCode(groupReqBO.getTenantCode());
        condition.setSkillGroupName(groupReqBO.getSkillGroupName());
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        if (StringUtils.isNotEmpty((CharSequence)groupReqBO.getTargetTenantCode())) {
            condition.setTenantCode(groupReqBO.getTargetTenantCode());
        }
        log.info("\u6761\u4ef6\u67e5\u8be2\u6280\u80fd\u7ec4[simple]:{}", (Object)condition);
        Page page = PageHelper.startPage((int)groupReqBO.getPage(), (int)groupReqBO.getLimit());
        this.csSkillGroupMapper.selectByCondition(condition);
        NiccCommonUtil.copyList((List)page.getResult(), (List)list, CsSkillGroupBO.class);
        return BaseRspUtils.createSuccessRspList((List)list);
    }

    private List<CsChannelBO> getSkillChannels(CsSkillGroupBO groupBO) {
        ArrayList channelBOS = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)groupBO.getSkillGroupTag())) {
            String channelCode = CsChannelType.H5.getCode() + groupBO.getSkillGid();
            CsChannelBO csChannelH5 = this.csmCommonService.getChannelByCode(groupBO.getTenantCode(), channelCode);
            if (csChannelH5 != null) {
                channelBOS.add(csChannelH5);
            }
            String channelCodePc = CsChannelType.PC.getCode() + groupBO.getSkillGid();
            CsChannelBO csChannelPc = this.csmCommonService.getChannelByCode(groupBO.getTenantCode(), channelCodePc);
            if (csChannelPc != null) {
                channelBOS.add(csChannelPc);
            }
        }
        return channelBOS;
    }

    @Transactional
    public Rsp saveSkillGroup(CsSkillGroupSaveReqBO skillGroupSaveReqBO) {
        int insert;
        CsSkillGroupReqBO groupReqBO;
        List skillGroups;
        log.info("\u4fdd\u5b58\u6280\u80fd\u7ec4\u4fe1\u606f:{}", (Object)skillGroupSaveReqBO);
        CsSkillGroup record = new CsSkillGroup();
        skillGroupSaveReqBO.setUpdateTime(new Date());
        BeanUtils.copyProperties((Object)skillGroupSaveReqBO, (Object)record);
        if (StringUtils.isNotEmpty((CharSequence)skillGroupSaveReqBO.getSkillGroupTag()) && (skillGroups = this.csSkillGroupMapper.selectByTagCode(skillGroupSaveReqBO.getTenantCode(), skillGroupSaveReqBO.getSkillGroupTag())) != null && skillGroups.size() > 0) {
            CsSkillGroup group = (CsSkillGroup)skillGroups.get(0);
            if (!group.getSkillGid().equals(skillGroupSaveReqBO.getSkillGid())) {
                return BaseRspUtils.createErrorRsp((String)("\u4fdd\u5b58\u5931\u8d25:\u6280\u80fd\u7ec4[" + group.getSkillGid() + "]\u5df2\u7ecf\u7ed1\u5b9a groupTag = " + skillGroupSaveReqBO.getSkillGroupTag() + ",\u8bf7\u66f4\u6362!"));
            }
            if (!group.getSkillGroupTag().equals(skillGroupSaveReqBO.getSkillGroupTag())) {
                return BaseRspUtils.createErrorRsp((String)("\u4fdd\u5b58\u5931\u8d25:\u6280\u80fd\u7ec4[" + group.getSkillGid() + "]\u5df2\u7ecf\u7ed1\u5b9a groupTag = " + skillGroupSaveReqBO.getSkillGroupTag() + ",\u8bf7\u66f4\u6362!"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)skillGroupSaveReqBO.getSkillGid())) {
            int update = this.csSkillGroupMapper.updateByPrimaryKeySelective(record);
            if (update > 0) {
                if (this.niccCsmConfigProperties.getAutoCreateChannel().booleanValue()) {
                    this.csmCommonService.saveTwoDefaultChannel(record);
                }
                this.saveAboutSkillGroup(skillGroupSaveReqBO);
                groupReqBO = new CsSkillGroupReqBO();
                groupReqBO.setSkillGid(record.getSkillGid());
                groupReqBO.setTenantCode(skillGroupSaveReqBO.getTenantCode());
                RspList groupList = this.getCsSkillGroupList(groupReqBO);
                return BaseRspUtils.createSuccessRsp(groupList.getRows().get(0), (String)"\u66f4\u65b0\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u6280\u80fd\u7ec4id\u4e0d\u5b58\u5728!");
        }
        record.setSkillGid(IdWorker.nextAutoIdStr());
        skillGroupSaveReqBO.setSkillGid(record.getSkillGid());
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        if (record.getOrderIndex() == null) {
            record.setOrderIndex(Integer.valueOf(0));
        }
        if (skillGroupSaveReqBO.getQueueLimit() == null) {
            record.setQueueLimit(Integer.valueOf(9999));
        }
        if ((insert = this.csSkillGroupMapper.insertSelective(record)) > 0) {
            if (this.niccCsmConfigProperties.getAutoCreateChannel().booleanValue()) {
                this.csmCommonService.saveTwoDefaultChannel(record);
            }
            this.saveAboutSkillGroup(skillGroupSaveReqBO);
            groupReqBO = new CsSkillGroupReqBO();
            groupReqBO.setSkillGid(record.getSkillGid());
            groupReqBO.setTenantCode(skillGroupSaveReqBO.getTenantCode());
            RspList groupList = this.getCsSkillGroupList(groupReqBO);
            return BaseRspUtils.createSuccessRsp(groupList.getRows().get(0), (String)"\u65b0\u589e\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    private void saveAboutSkillGroup(CsSkillGroupSaveReqBO skillGroupSaveReqBO) {
        if (skillGroupSaveReqBO.getCsList() != null) {
            for (CsSkillRelBO relBO : skillGroupSaveReqBO.getCsList()) {
                relBO.setTenantCode(skillGroupSaveReqBO.getTenantCode());
                if (StringUtils.isBlank((CharSequence)relBO.getIsValid())) {
                    relBO.setIsValid(EntityValidType.NORMAL.getCode());
                }
                if (StringUtils.isBlank((CharSequence)relBO.getSkillGid())) {
                    relBO.setSkillGid(skillGroupSaveReqBO.getSkillGid());
                }
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{relBO.getTenantCode(), relBO.getSkillGid(), relBO.getCsId()})) {
                    log.warn("\u4fdd\u5b58\u5ba2\u670d\u6280\u80fd\u7ec4,\u6280\u80fd\u7ec4id\u4e0d\u5f97\u4e3a\u7a7a:{}", (Object)relBO);
                    continue;
                }
                CsSkillGroupRelSaveReqBO saveReqBO = new CsSkillGroupRelSaveReqBO();
                BeanUtils.copyProperties((Object)relBO, (Object)saveReqBO);
                this.saveSkillGroupRel(saveReqBO);
                this.csmItemCountService.countAllCsAllotItems(relBO.getTenantCode(), Collections.singletonList(relBO.getCsId()));
            }
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{skillGroupSaveReqBO.getCsWorkSchedules()}) && !skillGroupSaveReqBO.getCsWorkSchedules().isEmpty()) {
            for (CsWorkScheduleBO csWorkSchedule : skillGroupSaveReqBO.getCsWorkSchedules()) {
                if (StringUtils.isEmpty((CharSequence)csWorkSchedule.getScheduleType())) {
                    csWorkSchedule.setScheduleType(CsScheduleType.NORMAL.getCode());
                }
                if (StringUtils.isEmpty((CharSequence)csWorkSchedule.getWorkDays())) {
                    csWorkSchedule.setWorkDays("w1|w2|w3|w4|w5|w6|w7");
                }
                csWorkSchedule.setTenantCode(skillGroupSaveReqBO.getTenantCode());
                csWorkSchedule.setConfigLevel(CsWorkScheduleLevel.SKILL_GROUP.getCode());
                csWorkSchedule.setConfigLevelVal(skillGroupSaveReqBO.getSkillGid());
            }
            this.csmCommonService.saveCsWorkSchedule(skillGroupSaveReqBO.getCsWorkSchedules());
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{skillGroupSaveReqBO.getCsAutoReplyConfigs()}) && !skillGroupSaveReqBO.getCsAutoReplyConfigs().isEmpty()) {
            for (CsAutoReplyConfigBO replyConfigBO : skillGroupSaveReqBO.getCsAutoReplyConfigs()) {
                if (StringUtils.isEmpty((CharSequence)replyConfigBO.getReplyType())) {
                    replyConfigBO.setReplyType(AutoReplyType.ROBOT_WELCOME.getCode());
                }
                replyConfigBO.setTenantCode(skillGroupSaveReqBO.getTenantCode());
                replyConfigBO.setConfigLevel(CsWorkScheduleLevel.SKILL_GROUP.getCode());
                replyConfigBO.setConfigLevelVal(skillGroupSaveReqBO.getSkillGid());
                if (!StringUtils.isEmpty((CharSequence)replyConfigBO.getIsValid())) continue;
                replyConfigBO.setIsValid(EntityValidType.NORMAL.getCode());
            }
            this.csmCommonService.saveCsAutoReplyConfigs(skillGroupSaveReqBO.getCsAutoReplyConfigs());
        }
    }

    @MethodParamVerifyEnable
    public Rsp saveSkillGroupRel(CsSkillGroupRelSaveReqBO saveReqBO) {
        CsInfoSkillRel record = new CsInfoSkillRel();
        record.setCreateTime(new Date());
        BeanUtils.copyProperties((Object)saveReqBO, (Object)record);
        CsInfoSkillRel skillRel = this.csInfoSkillRelMapper.selectSkillRel(saveReqBO.getTenantCode(), saveReqBO.getCsId(), saveReqBO.getSkillGid());
        log.info("\u66f4\u65b0\u6280\u80fd\u7ec4\u5173\u7cfb:{},{},{}", new Object[]{saveReqBO.getSkillGid(), saveReqBO.getCsId(), saveReqBO.getIsValid()});
        if (skillRel != null) {
            record.setRelId(skillRel.getRelId());
            this.csInfoSkillRelMapper.updateByPrimaryKeySelective(record);
        } else {
            record.setRelId(IdWorker.nextAutoIdStr());
            if (StringUtils.isEmpty((CharSequence)saveReqBO.getIsValid())) {
                saveReqBO.setIsValid(EntityValidType.NORMAL.getCode());
            }
            this.csInfoSkillRelMapper.insertSelective(record);
        }
        return BaseRspUtils.createSuccessRsp((Object)saveReqBO);
    }

    public Rsp saveSkillCsList(SkillCsListSaveReqBO saveReqBO) {
        log.info("\u66f4\u65b0\u6280\u80fd\u7ec4\u5173\u7cfb:{}", (Object)saveReqBO);
        if (saveReqBO.getCsList().isEmpty()) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u5f02\u5e38!");
        }
        CsSkillGroupBO groupBO = this.csmCommonService.getSkillGroupInfo(saveReqBO.getSkillGid());
        if (groupBO == null) {
            return BaseRspUtils.createErrorRsp((String)saveReqBO.getSkillGid(), (String)"\u6280\u80fd\u7ec4\u4e0d\u5b58\u5728!");
        }
        try {
            for (CsSkillRelBO relBO : saveReqBO.getCsList()) {
                CsInfoSkillRel skillRel;
                CsSkillGroupRelSaveReqBO relSaveReqBO = new CsSkillGroupRelSaveReqBO();
                BeanUtils.copyProperties((Object)relBO, (Object)relSaveReqBO);
                relSaveReqBO.setTenantCode(saveReqBO.getTenantCode());
                relSaveReqBO.setSkillGid(saveReqBO.getSkillGid());
                CsInfoBO csInfoBO = this.csmCommonService.getCsInfo(relBO.getCsId());
                String errorMsgAdd = "\u5ba2\u670d\uff08" + relBO.getCsId() + "\uff09\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u5ba2\u670d\u4e0d\u5b58\u5728\uff01";
                String errorMsgDel = "\u5ba2\u670d\uff08" + relBO.getCsId() + "\uff09\u5220\u9664\u5931\u8d25\uff0c\u6b64\u8d26\u53f7\u5728\u8be5\u6280\u80fd\u7ec4\u4e0b\u4e0d\u5b58\u5728\uff01";
                if (csInfoBO == null) {
                    if (EntityValidType.DELETE.getCode().equals(relBO.getIsValid())) {
                        log.warn("\u66f4\u65b0\u6280\u80fd\u7ec4\u5173\u7cfb:{}", (Object)errorMsgDel);
                        return BaseRspUtils.createErrorRsp((String)relBO.getCsId(), (String)errorMsgDel);
                    }
                    log.warn("\u66f4\u65b0\u6280\u80fd\u7ec4\u5173\u7cfb:{}", (Object)errorMsgAdd);
                    return BaseRspUtils.createErrorRsp((String)relBO.getCsId(), (String)errorMsgAdd);
                }
                if (EntityValidType.DELETE.getCode().equals(relBO.getIsValid()) && ((skillRel = this.csInfoSkillRelMapper.selectSkillRel(saveReqBO.getTenantCode(), relBO.getCsId(), saveReqBO.getSkillGid())) == null || EntityValidType.DELETE.getCode().equals(skillRel.getIsValid()))) {
                    return BaseRspUtils.createErrorRsp((String)relBO.getCsId(), (String)errorMsgDel);
                }
                this.saveSkillGroupRel(relSaveReqBO);
                this.csmItemCountService.countAllCsAllotItems(relBO.getTenantCode(), Collections.singletonList(relBO.getCsId()));
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6280\u80fd\u7ec4\u5173\u7cfb-\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5f02\u5e38!");
        }
        return BaseRspUtils.createSuccessRsp((Object)saveReqBO.getCsList());
    }
}

