/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.eums.SystemModelType;
import com.tydic.nicc.common.eums.csm.CsScheduleStatus;
import com.tydic.nicc.common.eums.csm.CsScheduleType;
import com.tydic.nicc.common.eums.csm.CsWorkScheduleLevel;
import com.tydic.nicc.csm.api.CsWorkScheduleApi;
import com.tydic.nicc.csm.api.bo.channel.CsChannelBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleCheck;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleCheckResult;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleMergeBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleSaveReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.ScheduleApply2OtherReqBO;
import com.tydic.nicc.csm.api.bo.cs.ScheduleRspListExtBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.busi.CsWorkScheduleCommonService;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.mapper.CsWorkScheduleMapper;
import com.tydic.nicc.csm.mapper.po.CsWorkSchedule;
import com.tydic.nicc.csm.mapper.po.CsWorkScheduleQueryCondition;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.im.admin.api.BladeTenantService;
import com.tydic.nicc.im.bo.BladeTenantBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CsWorkScheduleServiceImpl
implements CsWorkScheduleApi {
    private static final Logger log = LoggerFactory.getLogger(CsWorkScheduleServiceImpl.class);
    @Resource
    private CsWorkScheduleCommonService csWorkScheduleCommonService;
    @Resource
    private CsWorkScheduleMapper csWorkScheduleMapper;
    @Resource
    private CsmCommonService csmCommonService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private BladeTenantService bladeTenantService;

    public Rsp checkCsWorkSchedule(CsWorkScheduleCheck scheduleCheck) {
        CsWorkScheduleCheckResult result = this.csWorkScheduleCommonService.checkCsWorkSchedule(scheduleCheck);
        return BaseRspUtils.createSuccessRsp((Object)result);
    }

    public Rsp saveCsWorkSchedule(CsWorkScheduleSaveReqBO reqBO) {
        String objName;
        log.info("\u4fdd\u5b58\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e-\u5f00\u59cb:{}", (Object)reqBO);
        if (CsWorkScheduleLevel.TENANT.matchCode(reqBO.getConfigLevel())) {
            reqBO.setConfigLevelVal(reqBO.getTenantCode());
        }
        String tenantCode = reqBO.getTenantCode();
        if (CsWorkScheduleLevel.CHANNEL.matchCode(reqBO.getConfigLevel())) {
            tenantCode = SystemModelType.PLATFORM.getCode();
        }
        if (StringUtils.isEmpty((CharSequence)(objName = this.getScheduleObjName(tenantCode, reqBO.getConfigLevel(), reqBO.getConfigLevelVal())))) {
            log.warn("\u4fdd\u5b58\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e-\u9519\u8bef:\u914d\u7f6e\u5bf9\u8c61\u9519\u8bef!");
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u4e0d\u5230\u53ef\u914d\u7f6e\u7684\u9002\u7528\u8303\u56f4");
        }
        CsWorkSchedule record = new CsWorkSchedule();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setId("" + IdWorker.nextAutoId());
        record.setUpdateTime(new Date());
        record.setIsValid(CsScheduleStatus.VALID.getCode());
        this.csWorkScheduleMapper.insertSelective(record);
        return BaseRspUtils.createSuccessRsp((Object)record);
    }

    public Rsp updateCsWorkSchedule(CsWorkScheduleUpdateReqBO reqBO) {
        log.info("\u66f4\u65b0\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e-\u5f00\u59cb:{}", (Object)reqBO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getIdList()) && ObjectUtils.isEmpty((Object)reqBO.getScheduleType())) {
            return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u65e0\u914d\u7f6e\u5de5\u4f5c\u65f6\u95f4\uff0c\u8bf7\u5148\u5b8c\u6210\u914d\u7f6e\u518d\u70b9\u51fb\u6309\u94ae\u5f00\u542f");
        }
        int update = 0;
        if (CsWorkScheduleLevel.TENANT.matchCode(reqBO.getConfigLevel())) {
            reqBO.setConfigLevelVal(reqBO.getTenantCode());
        }
        CsWorkSchedule record = new CsWorkSchedule();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setUpdateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIdList())) {
            update = this.csWorkScheduleMapper.updateByPrimaryKeySelective(record);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getScheduleType()) && StringUtils.isNotEmpty((CharSequence)CsScheduleType.getNameByCode((String)reqBO.getScheduleType()))) {
            update = this.csWorkScheduleMapper.updateSelective(record);
        }
        if (update > 0) {
            return BaseRspUtils.createSuccessRsp((Object)"");
        }
        return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e\u5931\u8d25");
    }

    public RspList getCsWorkSchedules(CsWorkScheduleQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e:{}", (Object)reqBO);
        CsWorkScheduleQueryCondition condition = new CsWorkScheduleQueryCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        List csWorkSchedules = this.csWorkScheduleMapper.selectByCondition(condition);
        String isValid = CollectionUtils.isEmpty((Collection)csWorkSchedules) ? CsScheduleStatus.INVALID.getCode() : CsScheduleStatus.VALID.getCode();
        ArrayList scheduleBOS = Lists.newArrayList();
        for (CsWorkSchedule csWorkSchedule : csWorkSchedules) {
            String objName;
            CsWorkScheduleBO scheduleBO = new CsWorkScheduleBO();
            BeanUtils.copyProperties((Object)csWorkSchedule, (Object)scheduleBO);
            if (CsWorkScheduleLevel.CHANNEL.matchCode(reqBO.getConfigLevel())) {
                reqBO.setTenantCode(SystemModelType.PLATFORM.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)(objName = this.getScheduleObjName(reqBO.getTenantCode(), reqBO.getConfigLevel(), scheduleBO.getConfigLevelVal())))) {
                log.info("\u67e5\u8be2\u65f6\u95f4\u914d\u7f6e\u672a\u627e\u5230\u9002\u914d\u6709\u6548\u5bf9\u8c61 tenantCode:{} - configLevel:{} - configLevelVal:{}", new Object[]{reqBO.getTenantCode(), reqBO.getConfigLevel(), scheduleBO.getConfigLevelVal()});
                continue;
            }
            scheduleBO.setConfigObjName(objName);
            this.convertWeekDays(scheduleBO);
            scheduleBOS.add(scheduleBO);
            if (!CsScheduleStatus.INVALID.getCode().equals(csWorkSchedule.getIsValid())) continue;
            isValid = CsScheduleStatus.INVALID.getCode();
        }
        ArrayList rows = new ArrayList();
        Map<String, List<CsWorkScheduleBO>> collect = scheduleBOS.stream().collect(Collectors.groupingBy(CsWorkScheduleBO::getConfigLevelVal));
        collect.forEach((k, v) -> {
            Map<String, List<CsWorkScheduleBO>> map = v.stream().collect(Collectors.groupingBy(CsWorkScheduleBO::getScheduleType));
            CsWorkScheduleMergeBO mergeBO = new CsWorkScheduleMergeBO();
            List<CsWorkScheduleBO> normal = map.get(CsScheduleType.NORMAL.getCode());
            List<CsWorkScheduleBO> unique = map.get(CsScheduleType.UNIQUE.getCode());
            mergeBO.setCommonSchedule(this.convertWorkTime(normal));
            mergeBO.setSpecialSchedule(this.convertWorkTime(unique));
            mergeBO.setAreaName(((CsWorkScheduleBO)v.get(0)).getConfigObjName());
            rows.add(mergeBO);
        });
        RspList rspList = BaseRspUtils.createSuccessRspList(rows, (long)rows.size());
        ScheduleRspListExtBO bo = new ScheduleRspListExtBO();
        BeanUtils.copyProperties((Object)rspList, (Object)bo);
        bo.setIsValid(isValid);
        return bo;
    }

    public Rsp deleteCsWorkSchedules(CsWorkScheduleUpdateReqBO reqBO) {
        log.info("\u5220\u9664\u5ba2\u670d\u5de5\u4f5c\u65f6\u95f4 \uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        int i = this.csWorkScheduleMapper.deleteByIdList(reqBO.getIdList());
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5ba2\u670d\u5de5\u4f5c\u65f6\u95f4\u5931\u8d25");
    }

    @Transactional
    public Rsp apply2other(ScheduleApply2OtherReqBO reqBO) {
        log.info("\u5de5\u4f5c\u65f6\u95f4\u5e94\u7528\u5230\u5176\u4ed6\u6280\u80fd\u7ec4\u3001\u6e20\u9053\u3001\u5750\u5e2d\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        CsWorkScheduleQueryCondition condition = new CsWorkScheduleQueryCondition();
        condition.setTenantCode(reqBO.getTenantCode());
        condition.setConfigLevel(reqBO.getConfigLevel());
        condition.setConfigLevelVal(reqBO.getConfigLevelVal());
        List sample = this.csWorkScheduleMapper.selectByCondition(condition);
        if (CollectionUtils.isEmpty((Collection)sample)) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5750\u5e2d\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e");
        }
        List configLevelValList = reqBO.getConfigLevelValList();
        for (String configLevelVal : configLevelValList) {
            condition.setConfigLevelVal(configLevelVal);
            List oldList = this.csWorkScheduleMapper.selectByCondition(condition);
            sample.stream().filter(v -> !oldList.contains(v)).map(v -> {
                v.setConfigLevelVal(configLevelVal);
                v.setId(IdWorker.nextAutoIdStr());
                return v;
            }).forEach(po -> this.csWorkScheduleMapper.insertSelective(po));
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    private List<CsWorkScheduleBO> convertWorkTime(List<CsWorkScheduleBO> convert) {
        if (CollectionUtils.isEmpty(convert)) {
            return null;
        }
        for (CsWorkScheduleBO bo : convert) {
            if (!StringUtils.isNotEmpty((CharSequence)bo.getWorkStartTimes())) continue;
            Object workTime = "";
            List<String> startTimes = Arrays.asList(bo.getWorkStartTimes().split(","));
            List<String> endTimes = Arrays.asList(bo.getWorkEndTimes().split(","));
            for (int i = 0; i < startTimes.size(); ++i) {
                workTime = (String)workTime + startTimes.get(i) + "-" + endTimes.get(i) + ",";
            }
            bo.setWorkTime(((String)workTime).substring(0, ((String)workTime).length() - 1));
        }
        return convert;
    }

    private void convertWeekDays(CsWorkScheduleBO scheduleBO) {
        String workDays = scheduleBO.getWorkDays();
        workDays = CsScheduleType.NORMAL.getCode().equals(scheduleBO.getScheduleType()) ? workDays.replace("|", ",") : workDays.replace("|", " \u81f3 ");
        if (workDays.contains("w")) {
            workDays = workDays.replace("w", "\u5468");
            workDays = workDays.replace("1", "\u4e00");
            workDays = workDays.replace("2", "\u4e8c");
            workDays = workDays.replace("3", "\u4e09");
            workDays = workDays.replace("4", "\u56db");
            workDays = workDays.replace("5", "\u4e94");
            workDays = workDays.replace("6", "\u516d");
            workDays = workDays.replace("7", "\u65e5");
        }
        scheduleBO.setWorkDays(workDays);
    }

    public String getScheduleObjName(String tenantCode, String configLevel, String levelVal) {
        CsChannelBO channel;
        CsInfoBO csInfo;
        CsSkillGroupBO groupBO;
        Rsp rsp;
        String objName = "";
        if (CsWorkScheduleLevel.TENANT.matchCode(configLevel) && (rsp = this.bladeTenantService.queryById(levelVal)).isSuccess() && ObjectUtils.anyNotNull((Object[])new Object[]{rsp.getData()})) {
            objName = ((BladeTenantBO)rsp.getData()).getTenantName();
        }
        if (CsWorkScheduleLevel.SKILL_GROUP.matchCode(configLevel) && ObjectUtils.anyNotNull((Object[])new Object[]{groupBO = this.csmCommonService.getSkillGroupInfo(levelVal)})) {
            objName = groupBO.getSkillGroupName();
        }
        if (CsWorkScheduleLevel.CS.matchCode(configLevel) && ObjectUtils.anyNotNull((Object[])new Object[]{csInfo = this.csmCommonService.getCsInfo(levelVal)})) {
            objName = csInfo.getCsName();
        }
        if (CsWorkScheduleLevel.CHANNEL.matchCode(configLevel) && ObjectUtils.anyNotNull((Object[])new Object[]{channel = this.csmCommonService.getChannelByCode(tenantCode, levelVal)})) {
            objName = channel.getChannelName();
        }
        return objName;
    }
}

