/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.api.ChatSessionService;
import com.tydic.nicc.common.bo.csm.CsmAllotRspContext;
import com.tydic.nicc.common.bo.csm.CsmUserQueueContext;
import com.tydic.nicc.common.bo.csm.ProcessAllotListenerResult;
import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.bo.rocketmq.CsFreeEventContext;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotNewReqContext;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.bo.session.ChangeSessionAddUserBO;
import com.tydic.nicc.common.bo.session.ChangeSessionRemoveUserBO;
import com.tydic.nicc.common.bo.session.ChangeSessionUserReqBO;
import com.tydic.nicc.common.bo.session.ChangeSessionUserRspBO;
import com.tydic.nicc.common.bo.session.CloseSessionReqBO;
import com.tydic.nicc.common.bo.session.CreateNewSessionReqBO;
import com.tydic.nicc.common.bo.session.CreateNewSessionRspBO;
import com.tydic.nicc.common.bo.session.GetUserActiveSessionReqBO;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.csm.CsAllotJoinType;
import com.tydic.nicc.common.eums.csm.CsQueueExitType;
import com.tydic.nicc.common.eums.csm.CsRouteExceptionDefine;
import com.tydic.nicc.common.eums.csm.CsSkillGroupType;
import com.tydic.nicc.common.eums.im.ImOnlineStatus;
import com.tydic.nicc.common.eums.im.MsgChatType;
import com.tydic.nicc.common.eums.session.SessionCloseType;
import com.tydic.nicc.common.eums.session.SessionIsQueue;
import com.tydic.nicc.common.eums.session.UserAddSessionType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.csm.api.CsAllotOrTransferApi;
import com.tydic.nicc.csm.api.bo.cs.CsAllotAllotOrTransferBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotAllotOrTransferReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupInfo;
import com.tydic.nicc.csm.api.bo.skill.FetchQueueCount;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.exception.CsRouteException;
import com.tydic.nicc.csm.service.CsmCsAllotProcessService;
import com.tydic.nicc.csm.strategy.CsAllotExceptionStrategyFactory;
import com.tydic.nicc.csm.strategy.CsAllotRouteListenerFactory;
import com.tydic.nicc.csm.strategy.CsRouteAllotStrategyFactory;
import com.tydic.nicc.csm.strategy.RobotRouteAllotStrategyFactory;
import com.tydic.nicc.csm.strategy.SkillGroupStrategyFactory;
import com.tydic.nicc.csm.utils.AutoReplyNoticeHelper;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.core.api.ImMessageService;
import com.tydic.nicc.user.api.UserOptionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CsmCsAllotProcessServiceImpl
implements CsmCsAllotProcessService {
    private static final Logger log = LoggerFactory.getLogger(CsmCsAllotProcessServiceImpl.class);
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private SkillGroupStrategyFactory skillGroupStrategyFactory;
    @Resource
    private CsRouteAllotStrategyFactory csRouteAllotStrategyFactory;
    @Resource
    private RobotRouteAllotStrategyFactory robotRouteAllotStrategyFactory;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private CsAllotRouteListenerFactory csAllotRouteListenerFactory;
    @Resource
    private CsAllotExceptionStrategyFactory csAllotExceptionStrategyFactory;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private CsAllotOrTransferApi csAllotOrTransferApi;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private AutoReplyNoticeHelper autoReplyNoticeHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ChatSessionService chatSessionService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;

    @Override
    public Rsp<CsmAllotRspContext> processCsmFreeAllot(CsFreeEventContext eventContext) {
        FetchQueueCount count;
        List<CsSkillGroupInfo> skills;
        this.csAllotRouteListenerFactory.onReceivedCsmFreeRequest(eventContext);
        String skillGid = eventContext.getSkillGid();
        long start = System.currentTimeMillis();
        if (StringUtils.isNotEmpty((CharSequence)skillGid)) {
            if (this.csmCsAllotHelper.isEmptyQueue(eventContext.getTenantCode(), skillGid)) {
                log.info("\u5ba2\u670d\u7a7a\u95f2\u4e8b\u4ef6-\u5904\u7406:\u6280\u80fd\u7ec4\u5185\u6682\u65e0\u6392\u961f\u7528\u6237,\u4e22\u5f03\u6d88\u606f,skillGid = {}", (Object)skillGid);
                return BaseRspUtils.createErrorRsp((String)("\u5ba2\u670d\u7a7a\u95f2\u4e8b\u4ef6\u5904\u7406:\u6280\u80fd\u7ec4\u5185\u6682\u65e0\u6392\u961f\u7528\u6237,\u4e22\u5f03\u6d88\u606f,skillGid = {}" + skillGid));
            }
            CsmCsAllotReqContext csmCsAllotContext = new CsmCsAllotReqContext();
            csmCsAllotContext.setTenantCode(eventContext.getTenantCode());
            csmCsAllotContext.setAllotCsId(eventContext.getCsId());
            csmCsAllotContext.setAllotSkillGid(skillGid);
            csmCsAllotContext.setFetchQueue(true);
            csmCsAllotContext.setAllotJoinType(CsAllotJoinType.QUEUE.getCode());
            Rsp<CsmAllotRspContext> rsp = this.processCsmAllot(csmCsAllotContext);
            long end = System.currentTimeMillis();
            log.info("\u5ba2\u670d\u7a7a\u95f2\u4e8b\u4ef6-\u5904\u7406\u5b8c\u6210:{}|{}|{}|{}", new Object[]{skillGid, eventContext.getCsId(), rsp, end - start});
            return rsp;
        }
        if (StringUtils.isNotEmpty((CharSequence)eventContext.getCsId()) && !(skills = this.csmCommonService.getCsSkillGidList(eventContext.getTenantCode(), eventContext.getCsId(), true)).isEmpty() && StringUtils.isNotEmpty((CharSequence)(count = this.csmCsAllotHelper.fetchQueueSkill(eventContext.getTenantCode(), skills)).getSkillId()) && count.getQueueCount() > 0L) {
            CsmCsAllotReqContext csmCsAllotContext = new CsmCsAllotReqContext();
            csmCsAllotContext.setFetchQueue(true);
            csmCsAllotContext.setTenantCode(eventContext.getTenantCode());
            csmCsAllotContext.setAllotCsId(eventContext.getCsId());
            csmCsAllotContext.setAllotJoinType(CsAllotJoinType.QUEUE.getCode());
            csmCsAllotContext.setAllotSkillGid(count.getSkillId());
            Rsp<CsmAllotRspContext> rsp = this.processCsmAllot(csmCsAllotContext);
            long end = System.currentTimeMillis();
            log.info("\u5ba2\u670d\u7a7a\u95f2\u4e8b\u4ef6-\u5904\u7406\u5b8c\u6210:{}|{}|{}|{}", new Object[]{count.getSkillId(), eventContext.getCsId(), rsp, end - start});
            return rsp;
        }
        log.info("\u5ba2\u670d\u7a7a\u95f2\u4e8b\u4ef6-\u5904\u7406\u5b8c\u6210,\u672a\u62c9\u53d6\u5230\u6392\u961f\u7528\u6237:{}", (Object)eventContext);
        return BaseRspUtils.createErrorRsp((String)"\u5ba2\u670d\u7a7a\u95f2\u4e8b\u4ef6,\u672a\u62c9\u53d6\u5230\u6392\u961f\u7528\u6237");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rsp<CsmAllotRspContext> processCsmAllot(CsmCsAllotReqContext csmCsAllotContext) {
        Rsp<CsmAllotRspContext> rsp;
        block19: {
            long start = System.currentTimeMillis();
            if (StringUtils.isEmpty((CharSequence)csmCsAllotContext.getAllotRequestId())) {
                csmCsAllotContext.setAllotRequestId(IdWorker.nextAutoIdStr());
            }
            String requestId = csmCsAllotContext.getAllotRequestId();
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5f00\u59cb:{}", (Object)requestId, (Object)csmCsAllotContext);
            Rsp paramCheckRsp = this.csmAllotParamCheck(csmCsAllotContext);
            if (!paramCheckRsp.isSuccess()) {
                return paramCheckRsp;
            }
            ProcessAllotListenerResult listenerResult = this.csAllotRouteListenerFactory.onBeforeRoute(csmCsAllotContext);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-onBeforeRoute: isAllow = {}", (Object)requestId, (Object)listenerResult);
            if (!listenerResult.isAllotAllow()) {
                return BaseRspUtils.createErrorRsp((String)listenerResult.getReason());
            }
            if (StringUtils.isNotEmpty((CharSequence)csmCsAllotContext.getAllotCsId()) && StringUtils.isEmpty((CharSequence)csmCsAllotContext.getAllotSkillGid())) {
                CsAllotAllotOrTransferReqBO reqBO = new CsAllotAllotOrTransferReqBO();
                reqBO.setTenantCode(csmCsAllotContext.getTenantCode());
                reqBO.setCsId(csmCsAllotContext.getTransferFromCsId());
                reqBO.setSessionId(csmCsAllotContext.getSessionId());
                Rsp transferBORsp = this.csAllotOrTransferApi.getCsAllotOrTransferRecord(reqBO);
                if (transferBORsp.isSuccess()) {
                    csmCsAllotContext.setAllotSkillGid(((CsAllotAllotOrTransferBO)transferBORsp.getData()).getAllotSkillGid());
                } else {
                    return BaseRspUtils.createErrorRsp((String)"\u5ba2\u670d\u5206\u914d\u5931\u8d25,\u6307\u5b9a\u5ba2\u670d\u5206\u914d\u5931\u8d25,\u627e\u4e0d\u5230\u5ba2\u670d\u6240\u5c5e\u6280\u80fd\u7ec4!");
                }
            }
            RouteAllotRsp allotRsp = this.skillGroupStrategyFactory.processSkillGroupRoute(csmCsAllotContext);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u6280\u80fd\u7ec4\u8def\u7531\u5b8c\u6210:{}", (Object)requestId, (Object)allotRsp);
            if (allotRsp.isAllotDeny()) {
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u6280\u80fd\u7ec4\u8def\u7531\u5b8c\u6210-\u5ba2\u670d\u5206\u914d\u5931\u8d25,\u6d41\u7a0b\u7ec8\u6b62:{}", (Object)requestId, (Object)allotRsp);
                return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u65e0\u53ef\u670d\u52a1\u5750\u5e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            RouteAllotReq routeAllot = new RouteAllotReq();
            BeanUtils.copyProperties((Object)csmCsAllotContext, (Object)routeAllot);
            routeAllot.setAllotSkillGid(allotRsp.getAllotSkillGid());
            routeAllot.setAllotSkillType(allotRsp.getAllotSkillType());
            routeAllot.setAllotStrategy(allotRsp.getAllotStrategy());
            routeAllot.setFetchQueue(csmCsAllotContext.isFetchQueue());
            routeAllot.setFrequentRule(allotRsp.isFrequentRule());
            if (!csmCsAllotContext.isFetchQueue() && !CsAllotJoinType.TRANSFER.matchCode(csmCsAllotContext.getAllotJoinType())) {
                int onlineCount = this.csmCommonService.countOnlineCs(routeAllot.getTenantCode(), routeAllot.getAllotSkillGid());
                if (onlineCount == 0) {
                    log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u63a8\u9001\u975e\u5de5\u4f5c\u65f6\u95f4\u63d0\u9192\u6d88\u606f(\u65e0\u5ba2\u670d\u5728\u7ebf):{}", (Object)requestId, (Object)allotRsp.getAllotSkillGid());
                    this.autoReplyNoticeHelper.pushSysNoWorkingNotice(routeAllot.getTenantCode(), allotRsp.getAllotSkillGid(), routeAllot.getUserId(), true);
                    return BaseRspUtils.createErrorRsp((String)"\u5ba2\u670d\u8def\u7531\u5206\u914d,\u65e0\u5ba2\u670d\u5728\u7ebf\uff0c\u8bf7\u7559\u8a00\uff01");
                }
                String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)csmCsAllotContext.getTenantCode(), (String)allotRsp.getAllotSkillGid());
                List<Object> queueContexts = this.csmCsAllotHelper.getQueueList(queueCacheKey);
                if (queueContexts != null && queueContexts.size() > 0) {
                    return this.processQueue(csmCsAllotContext, allotRsp);
                }
            }
            String lockKey = NiccCommonUtil.getAllotLockKey((String)allotRsp.getAllotSkillGid());
            RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(lockKey).requestId(IdWorker.nextAutoIdStr()).build();
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u6280\u80fd\u7ec4\u52a0\u9501:{}", (Object)requestId, (Object)redisLockEntity);
            boolean locked = this.redisHelper.lock(redisLockEntity);
            try {
                Rsp<CsmAllotRspContext> contextRsp;
                if (locked) {
                    log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5f00\u59cb\u6267\u884c\u5206\u914d\u903b\u8f91:{}", (Object)requestId, (Object)routeAllot);
                    contextRsp = this.processCsAllotStrategy(routeAllot, csmCsAllotContext);
                } else {
                    log.warn("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u83b7\u53d6redis\u9501\u5931\u8d25,\u91cd\u65b0\u5c1d\u8bd5\u5206\u914d:{}", (Object)requestId, (Object)csmCsAllotContext);
                    TimeUnit.MILLISECONDS.sleep(100L);
                    contextRsp = this.processCsmAllot(csmCsAllotContext);
                }
                long end = System.currentTimeMillis();
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5206\u914d\u5b8c\u6210:{}|{}", new Object[]{requestId, contextRsp.getRspDesc(), end - start});
                rsp = contextRsp;
                if (!locked) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (locked) {
                        this.redisHelper.unlockLua(redisLockEntity);
                    }
                    throw throwable;
                }
                catch (CsRouteException routeException) {
                    log.error("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u8def\u7531\u5f02\u5e38:{}", (Object)requestId, (Object)routeException);
                    this.csAllotExceptionStrategyFactory.handleAllotErrorListener(csmCsAllotContext, CsRouteExceptionDefine.getInstance((String)routeException.getErrorCode()));
                    return BaseRspUtils.createErrorRsp((String)("\u5ba2\u670d\u5206\u914d\u8def\u7531\u5f02\u5e38: routeCode = " + routeException.getErrorCode()));
                }
                catch (Exception e) {
                    log.error("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u7cfb\u7edf\u5f02\u5e38:", (Object)requestId, (Object)e);
                    return BaseRspUtils.createErrorRsp((String)("\u5ba2\u670d\u5206\u914d\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage()));
                }
            }
            this.redisHelper.unlockLua(redisLockEntity);
        }
        return rsp;
    }

    @Override
    @MethodParamVerifyEnable
    public Rsp processAllotByRequestAndClose(CsmCsAllotNewReqContext newReqContext) {
        String cacheKey = RedisCacheKeyConstant.getImUserRequestIdCacheKey((String)newReqContext.getUserId());
        String requestId = (String)this.redisHelper.get(cacheKey);
        log.info("\u5ba2\u670d\u8f6c\u63a5\u5206\u914d[{}]-\u5f00\u59cb:{}", (Object)requestId, (Object)newReqContext);
        if (StringUtils.isNotEmpty((CharSequence)requestId)) {
            CsmCsAllotReqContext csmCsAllotContext = new CsmCsAllotReqContext();
            csmCsAllotContext.setTenantCode(newReqContext.getTenantCode());
            csmCsAllotContext.setChannelCode(newReqContext.getChannelCode());
            csmCsAllotContext.setUserId(newReqContext.getUserId());
            csmCsAllotContext.setAllotSkillGid(newReqContext.getAllotSkillGid());
            csmCsAllotContext.setAllotCsId(newReqContext.getAllotCsId());
            csmCsAllotContext.setImRequestId(requestId);
            csmCsAllotContext.setAllotJoinType(CsAllotJoinType.ALLOT.getCode());
            Rsp<CsmAllotRspContext> rsp = this.processCsmAllot(csmCsAllotContext);
            log.info("\u5ba2\u670d\u8f6c\u63a5\u5206\u914d[{}]-\u5b8c\u6210:{}", (Object)requestId, rsp);
            if (rsp.isSuccess()) {
                CloseSessionReqBO closeSessionReqBO = new CloseSessionReqBO();
                closeSessionReqBO.setSessionId(newReqContext.getCurrSessionId());
                closeSessionReqBO.setTenantCode(newReqContext.getTenantCode());
                closeSessionReqBO.setUserId(newReqContext.getUserId());
                closeSessionReqBO.setOperUser(newReqContext.getOperUser());
                closeSessionReqBO.setCloseType(SessionCloseType.CS_CLOSE.getCode());
                this.chatSessionService.sessionClose(closeSessionReqBO);
                return rsp;
            }
            return BaseRspUtils.createErrorRsp((String)("\u8f6c\u63a5\u5931\u8d25:" + rsp.getRspDesc()));
        }
        return BaseRspUtils.createErrorRsp((String)"\u8f6c\u63a5\u5931\u8d25:\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
    }

    private Rsp csmAllotParamCheck(CsmCsAllotReqContext csmCsAllotContext) {
        if (StringUtils.isEmpty((CharSequence)csmCsAllotContext.getTenantCode())) {
            return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        if (csmCsAllotContext.isFetchQueue()) {
            if (StringUtils.isEmpty((CharSequence)csmCsAllotContext.getAllotSkillGid())) {
                return BaseRspUtils.createErrorRsp((String)"\u6392\u961f\u62c9\u53d6\u6280\u80fd\u7ec4id\u4e0d\u5f97\u4e3a\u7a7a!");
            }
        } else {
            if (CsAllotJoinType.TRANSFER.matchCode(csmCsAllotContext.getAllotJoinType())) {
                if (StringUtils.isEmpty((CharSequence)csmCsAllotContext.getTransferFromCsId())) {
                    return BaseRspUtils.createErrorRsp((String)"\u8f6c\u63a5\u5931\u8d25:\u8f6c\u63a5\u53d1\u8d77\u4ebaID\u4e0d\u5f97\u4e3a\u7a7a!");
                }
                if (StringUtils.isEmpty((CharSequence)csmCsAllotContext.getAllotCsId()) && StringUtils.isEmpty((CharSequence)csmCsAllotContext.getAllotSkillGid())) {
                    return BaseRspUtils.createErrorRsp((String)"\u8f6c\u63a5\u5931\u8d25:\u8f6c\u63a5\u5bf9\u8c61\u4e0d\u5f97\u4e3a\u7a7a!");
                }
            }
            if (CsAllotJoinType.ROBOT.matchCode(csmCsAllotContext.getAllotJoinType()) || CsAllotJoinType.ALLOT.matchCode(csmCsAllotContext.getAllotJoinType())) {
                if (StringUtils.isEmpty((CharSequence)csmCsAllotContext.getUserId())) {
                    return BaseRspUtils.createErrorRsp((String)"\u7528\u6237Id\u4e0d\u5f97\u4e3a\u7a7a!");
                }
                Rsp checkRsp = this.checkUserOnline(csmCsAllotContext.getUserId());
                if (!checkRsp.isSuccess()) {
                    return checkRsp;
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6821\u9a8c\u901a\u8fc7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rsp processCsAllotStrategy(RouteAllotReq routeAllot, CsmCsAllotReqContext csmCsAllotContext) throws InterruptedException {
        GetUserActiveSessionReqBO sessionReqBO;
        Rsp sessionSetRsp;
        boolean fetchResult;
        String requestId = csmCsAllotContext.getAllotRequestId();
        RouteAllotRsp allotRsp = null;
        if (csmCsAllotContext.isFetchQueue() && !(fetchResult = this.fetchQueue(csmCsAllotContext))) {
            return BaseRspUtils.createErrorRsp((Object)0, (String)"\u5ba2\u670d\u8def\u7531\u5206\u914d-\u4ece\u6392\u961f\u62c9\u53d6\u7ec8\u6b62!");
        }
        if ((CsAllotJoinType.ALLOT.matchCode(csmCsAllotContext.getAllotJoinType()) || CsAllotJoinType.QUEUE.matchCode(csmCsAllotContext.getAllotJoinType()) || CsAllotJoinType.ROBOT.matchCode(csmCsAllotContext.getAllotJoinType())) && ((Set)(sessionSetRsp = this.chatSessionService.getUserActiveSessions(sessionReqBO = new GetUserActiveSessionReqBO(csmCsAllotContext.getTenantCode(), csmCsAllotContext.getUserId(), false))).getData()).size() > 0 && "cs".equals(this.niccCsmConfigProperties.getDeployModel())) {
            log.warn("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u7528\u6237\u6709\u4f1a\u8bdd\u672a\u7ed3\u675f,\u5206\u914d\u5df2\u7ec8\u6b62:userId = {}, sessions = {}", new Object[]{requestId, csmCsAllotContext.getUserId(), sessionSetRsp.getData()});
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u6709\u4f1a\u8bdd\u672a\u7ed3\u675f,\u4e0d\u5f97\u91cd\u590d\u63a5\u5165\u5ba2\u670d!");
        }
        if (CsSkillGroupType.ONLINE.matchCode(routeAllot.getAllotSkillType()) || CsSkillGroupType.DEFAULT.matchCode(routeAllot.getAllotSkillType())) {
            if (StringUtils.isNotEmpty((CharSequence)routeAllot.getAllotCsId())) {
                allotRsp = this.csRouteAllotStrategyFactory.allotToCs(routeAllot);
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u6307\u5b9a\u5ba2\u670d\u5206\u914d:{}", (Object)requestId, (Object)allotRsp);
            } else {
                allotRsp = this.csRouteAllotStrategyFactory.handleCsRouteAllot(routeAllot);
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u4f7f\u7528\u7b56\u7565\u5206\u914d:{}", (Object)requestId, (Object)allotRsp);
            }
        } else if (CsSkillGroupType.ROBOT.matchCode(routeAllot.getAllotSkillType())) {
            allotRsp = this.robotRouteAllotStrategyFactory.handleRobotRouteAllot(routeAllot);
        } else {
            log.error("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u6267\u884c\u6280\u80fd\u7ec4\u8def\u7531\u5f02\u5e38,\u6280\u80fd\u7ec4\u7c7b\u578b\u9519\u8bef:{}", (Object)requestId, (Object)routeAllot);
            throw new CsRouteException(CsRouteExceptionDefine.SKILL_TYPE_ERROR);
        }
        BeanUtils.copyProperties((Object)routeAllot, (Object)allotRsp);
        if (allotRsp.isAllotDeny()) {
            return BaseRspUtils.createErrorRsp((String)"\u5ba2\u670d\u5206\u914d\u5931\u8d25,\u5206\u914d\u6d41\u7a0b\u88ab\u7ec8\u6b62!");
        }
        ProcessAllotListenerResult listenerResult = this.csAllotRouteListenerFactory.onAfterRoute(csmCsAllotContext, allotRsp);
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-onAfterRoute:{}", (Object)requestId, (Object)listenerResult);
        if (!listenerResult.isAllotAllow()) {
            return BaseRspUtils.createErrorRsp((String)listenerResult.getReason());
        }
        if (allotRsp.isMatch()) {
            if (UserTypeField.COMP_USER.getCode().equals(allotRsp.getAllotUserType())) {
                if (!CsAllotJoinType.TRANSFER.matchCode(csmCsAllotContext.getAllotJoinType())) {
                    String key = "CS_ALLOTTING_LOCK_" + allotRsp.getAllotCsInfo().getCsId();
                    RedisLockEntity entity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
                    boolean locked = this.redisHelper.lock(entity);
                    if (locked) {
                        try {
                            Rsp rsp = this.allottingCs(csmCsAllotContext, allotRsp, requestId);
                            return rsp;
                        }
                        finally {
                            this.redisHelper.unlockLua(entity);
                        }
                    }
                    log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5206\u914d\u5ba2\u670d\u83b7\u53d6\u9501\u5931\u8d25:{}", (Object)requestId, (Object)allotRsp);
                    TimeUnit.MILLISECONDS.sleep(100L);
                    return this.processCsAllotStrategy(routeAllot, csmCsAllotContext);
                }
                return this.transingCs(csmCsAllotContext, allotRsp, requestId);
            }
            if (UserTypeField.ROBOT.getCode().equals(allotRsp.getAllotUserType())) {
                CsmAllotRspContext rspContext = CsmAllotRspContext.builder().allotJoinType(csmCsAllotContext.getAllotJoinType()).allotRsp(allotRsp).build();
                return BaseRspUtils.createSuccessRsp((Object)rspContext, (String)"\u673a\u5668\u4eba\u8def\u7531\u5206\u914d\u6210\u529f!");
            }
            return BaseRspUtils.createErrorRsp((String)"\u5ba2\u670d\u5206\u914d\u5931\u8d25:\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b!");
        }
        return this.processQueue(csmCsAllotContext, allotRsp);
    }

    private Rsp transingCs(CsmCsAllotReqContext csmCsAllotContext, RouteAllotRsp allotRsp, String requestId) {
        ChangeSessionUserReqBO changeSessionUserReqBO = new ChangeSessionUserReqBO();
        changeSessionUserReqBO.setSessionId(csmCsAllotContext.getSessionId());
        changeSessionUserReqBO.setOptTime(new Date());
        changeSessionUserReqBO.setChatObjId(csmCsAllotContext.getUserId());
        ArrayList addUsers = Lists.newArrayList();
        addUsers.add(new ChangeSessionAddUserBO(allotRsp.getAllotCsInfo().getCsId(), UserAddSessionType.TYPE_3.getCode(), UserTypeField.COMP_USER.getCode()));
        changeSessionUserReqBO.setAddUsers((List)addUsers);
        if (CsAllotJoinType.TRANSFER.matchCode(csmCsAllotContext.getAllotJoinType())) {
            ArrayList removeUsers = Lists.newArrayList();
            removeUsers.add(new ChangeSessionRemoveUserBO(csmCsAllotContext.getTransferFromCsId(), SessionCloseType.USER_CLOSE.getStringCode()));
            changeSessionUserReqBO.setRemoveUsers((List)removeUsers);
        }
        Rsp sessionChangeRsp = this.chatSessionService.changeSessionUsers(changeSessionUserReqBO);
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5ba2\u670d\u8f6c\u63a5\u5206\u914d,\u4f1a\u8bdd\u53d8\u66f4\u7ed3\u679c:{}", (Object)requestId, (Object)sessionChangeRsp);
        CsmAllotRspContext rspContext = CsmAllotRspContext.builder().allotJoinType(csmCsAllotContext.getAllotStrategy()).allotRsp(allotRsp).changeSessionUsers((ChangeSessionUserRspBO)sessionChangeRsp.getData()).build();
        if (sessionChangeRsp.isSuccess()) {
            this.csAllotRouteListenerFactory.onAfterAllotCs(csmCsAllotContext, rspContext, csmCsAllotContext.getSessionId());
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5ba2\u670d\u8f6c\u63a5\u5206\u914d\u6210\u529f-onAfterAllotCs:{}", (Object)requestId, (Object)rspContext);
            return BaseRspUtils.createSuccessRsp((Object)rspContext, (String)"\u5ba2\u670d\u8f6c\u63a5\u5206\u914d\u6210\u529f!");
        }
        this.csAllotRouteListenerFactory.onAfterAllotCs(csmCsAllotContext, rspContext, "");
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5ba2\u670d\u8f6c\u63a5\u5206\u914d\u5931\u8d25-onAfterAllotCs:{}", (Object)requestId, (Object)rspContext);
        return BaseRspUtils.createErrorRsp((String)("\u5ba2\u670d\u8f6c\u63a5\u5206\u914d\u5931\u8d25:" + sessionChangeRsp.getRspDesc()));
    }

    private Rsp allottingCs(CsmCsAllotReqContext csmCsAllotContext, RouteAllotRsp allotRsp, String requestId) {
        Map<String, Object> userRequestData;
        CreateNewSessionReqBO createSession = new CreateNewSessionReqBO();
        BeanUtils.copyProperties((Object)csmCsAllotContext, (Object)createSession);
        createSession.setFromNo(allotRsp.getAllotCsInfo().getCsId());
        createSession.setFromType(UserTypeField.COMP_USER.getCode());
        createSession.setToNo(csmCsAllotContext.getUserId());
        String chatKey = NiccCommonUtil.getC2bChatKey((String)csmCsAllotContext.getTenantCode(), (String)csmCsAllotContext.getUserId());
        createSession.setChatKey(chatKey);
        createSession.setChatType(MsgChatType.C2B.getCode());
        createSession.setSkillGid(allotRsp.getAllotSkillGid());
        createSession.setJoinType(csmCsAllotContext.getAllotJoinType());
        createSession.setSessionType(Integer.valueOf(0));
        createSession.setIsQueue(SessionIsQueue.NO.getCode());
        if (csmCsAllotContext.isFetchQueue()) {
            createSession.setIsQueue(SessionIsQueue.YES.getCode());
        }
        if (!(userRequestData = this.csmCommonService.loadFormDataByRequestId(csmCsAllotContext.getImRequestId())).isEmpty()) {
            createSession.setExtInfo(JSONObject.toJSONString(userRequestData));
        }
        Rsp sessionRsp = this.chatSessionService.createNewSession(createSession);
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u4f1a\u8bdd\u521b\u5efa\u5b8c\u6210:{}", (Object)requestId, (Object)sessionRsp);
        if (csmCsAllotContext.isFetchQueue()) {
            if (sessionRsp.isSuccess()) {
                this.csmCsAllotHelper.popQueue(csmCsAllotContext.getQueueContext().getQueueKey(), csmCsAllotContext.getUserId(), ((CreateNewSessionRspBO)sessionRsp.getData()).getSessionId(), CsQueueExitType.ALLOT.getCode());
            } else {
                this.csmCsAllotHelper.popQueue(csmCsAllotContext.getQueueContext().getQueueKey(), csmCsAllotContext.getUserId(), CsQueueExitType.SYS_EXIT_OFFLINE.getCode());
            }
        }
        CsmAllotRspContext rspContext = CsmAllotRspContext.builder().allotJoinType(csmCsAllotContext.getAllotJoinType()).allotRsp(allotRsp).build();
        if (sessionRsp.isSuccess()) {
            String sessionId = ((CreateNewSessionRspBO)sessionRsp.getData()).getSessionId();
            if (StringUtils.isNotEmpty((CharSequence)sessionId)) {
                this.csAllotRouteListenerFactory.onAfterAllotCs(csmCsAllotContext, rspContext, sessionId);
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5ba2\u670d\u8def\u7531\u5206\u914d\u6210\u529f-onAfterAllotCs:{}", (Object)requestId, (Object)rspContext);
                return BaseRspUtils.createSuccessRsp((Object)rspContext, (String)"\u5ba2\u670d\u8def\u7531\u5206\u914d\u6210\u529f!");
            }
            log.warn("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u4f1a\u8bdd\u521b\u5efa\u5931\u8d25,\u5ba2\u6237\u5df2\u79bb\u7ebf:{}", (Object)requestId, sessionRsp.getData());
        }
        this.csAllotRouteListenerFactory.onAfterAllotCs(csmCsAllotContext, rspContext, "");
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5ba2\u670d\u5206\u914d\u5931\u8d25-onAfterAllotCs:{}", (Object)requestId, (Object)rspContext);
        return BaseRspUtils.createErrorRsp((String)("\u5ba2\u670d\u5206\u914d\u5931\u8d25:" + sessionRsp.getRspDesc()));
    }

    private Rsp processQueue(CsmCsAllotReqContext csmCsAllotContext, RouteAllotRsp allotRsp) {
        CsmUserQueueContext queueContext = new CsmUserQueueContext(System.currentTimeMillis());
        BeanUtils.copyProperties((Object)csmCsAllotContext, (Object)queueContext);
        BeanUtils.copyProperties((Object)allotRsp, (Object)queueContext);
        queueContext.setJoinType(csmCsAllotContext.getAllotJoinType());
        CsmAllotRspContext rspContext = CsmAllotRspContext.builder().allotJoinType(csmCsAllotContext.getAllotJoinType()).queueContext(queueContext).allotRsp(allotRsp).build();
        CsmUserQueueContext csmUserQueueContext = this.csmCsAllotHelper.matchUserInQueue(queueContext.getTenantCode(), queueContext.getAllotSkillGid(), queueContext.getUserId());
        if (!csmCsAllotContext.isFetchQueue()) {
            if (ObjectUtils.anyNotNull((Object[])new Object[]{csmUserQueueContext})) {
                ImMessage message = this.csmCsAllotHelper.packageSysQueueMessage(csmUserQueueContext);
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u63a8\u9001\u7528\u6237 {} \u6392\u961f\u6d88\u606f(\u7528\u6237\u5df2\u5728\u6392\u961f\u961f\u5217\u4e2d):{}", new Object[]{csmCsAllotContext.getAllotRequestId(), csmUserQueueContext.getUserId(), JSONObject.toJSONString((Object)message)});
                this.imMessageService.sendMessageToUser(message);
                return BaseRspUtils.createErrorRsp((Object)rspContext, (String)"\u5ba2\u670d\u8def\u7531\u5206\u914d:\u7528\u6237\u5df2\u5728\u6392\u961f\u961f\u5217\u4e2d,\u8bf7\u52ff\u91cd\u590d\u5206\u914d!");
            }
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u8fdb\u5165\u6392\u961f\u961f\u5217:queueContext = {}", (Object)csmCsAllotContext.getAllotRequestId(), (Object)queueContext);
            this.csmCsAllotHelper.addQueue(queueContext);
            this.csAllotRouteListenerFactory.onAfterInQueue(queueContext);
            return BaseRspUtils.createSuccessRsp((Object)rspContext, (String)"\u5ba2\u670d\u8def\u7531\u5206\u914d:\u8fdb\u5165\u6392\u961f\u961f\u5217!");
        }
        rspContext.setQueueContext(csmCsAllotContext.getQueueContext());
        return BaseRspUtils.createErrorRsp((Object)rspContext, (String)"\u5ba2\u670d\u8def\u7531\u5206\u914d:\u7ee7\u7eed\u6392\u961f\u7b49\u5f85!");
    }

    private Rsp checkUserOnline(String userId) {
        try {
            Rsp usrOnlineRsp = this.userOptionService.getOnlineStatus("", userId);
            if (((String)usrOnlineRsp.getData()).equals(ImOnlineStatus.OFFLINE.getCode())) {
                return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u5f53\u524d\u4e0d\u5728\u7ebf\uff0c\u65e0\u6cd5\u5206\u914d\u5ba2\u670d!");
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u72b6\u6001\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
        }
        return BaseRspUtils.createSuccessRsp((Object)"ok");
    }

    private boolean fetchQueue(CsmCsAllotReqContext csmCsAllotContext) {
        String requestId = csmCsAllotContext.getAllotRequestId();
        CsmUserQueueContext queueContext = this.csmCsAllotHelper.getQueueFirstItem(csmCsAllotContext.getTenantCode(), csmCsAllotContext.getAllotSkillGid());
        if (ObjectUtils.anyNotNull((Object[])new Object[]{queueContext})) {
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u4ece\u6392\u961f\u961f\u5217\u62c9\u53d6:{}", (Object)requestId, (Object)queueContext);
            BeanUtils.copyProperties((Object)queueContext, (Object)csmCsAllotContext);
            csmCsAllotContext.setUserId(queueContext.getUserId());
            csmCsAllotContext.setChannelCode(queueContext.getChannelCode());
            csmCsAllotContext.setAllotStrategy(queueContext.getAllotStrategy());
            csmCsAllotContext.setAllotCsId(queueContext.getTransferFromCsId());
            csmCsAllotContext.setAllotJoinType(queueContext.getJoinType());
            csmCsAllotContext.setQueueContext(queueContext);
            csmCsAllotContext.setAllotStartTime(new Date());
            Rsp checkRsp = this.checkUserOnline(csmCsAllotContext.getUserId());
            if (!checkRsp.isSuccess()) {
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u7528\u6237\u4e0d\u5728\u7ebf,\u79fb\u51fa\u961f\u5217:{}->{}", new Object[]{requestId, csmCsAllotContext.getQueueContext().getQueueKey(), csmCsAllotContext.getUserId()});
                this.csmCsAllotHelper.popQueue(csmCsAllotContext.getQueueContext().getQueueKey(), csmCsAllotContext.getUserId(), CsQueueExitType.SYS_EXIT_OFFLINE.getCode());
                return this.fetchQueue(csmCsAllotContext);
            }
            return true;
        }
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u5ba2\u670d\u7cfb\u7edf\u6392\u961f\u961f\u5217\u6682\u65e0\u7528\u6237:{}", (Object)requestId, (Object)csmCsAllotContext);
        return false;
    }
}

