/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.tydic.nicc.common.api.ChatSessionService;
import com.tydic.nicc.common.bo.csm.CsmAllotRspContext;
import com.tydic.nicc.common.bo.csm.CsmForceOfflineAndTransferReqBO;
import com.tydic.nicc.common.bo.csm.CsmForceOfflineAndTransferRspBO;
import com.tydic.nicc.common.bo.csm.CsmTransferReqBO;
import com.tydic.nicc.common.bo.im.core.ImUserDenyReqBO;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.bo.session.ChatSessionMemberBO;
import com.tydic.nicc.common.bo.session.GetUserActiveSessionBO;
import com.tydic.nicc.common.bo.session.GetUserActiveSessionReqBO;
import com.tydic.nicc.common.eums.csm.CsAllotJoinType;
import com.tydic.nicc.common.eums.csm.CsState;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.CsInfoApi;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoUpdateReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupInfo;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.service.CsmCsAllotProcessService;
import com.tydic.nicc.csm.service.CsmCsTransferProcessService;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.im.core.api.ImCoreService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CsmCsTransferProcessServiceImpl
implements CsmCsTransferProcessService {
    private static final Logger log = LoggerFactory.getLogger(CsmCsTransferProcessServiceImpl.class);
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmCsAllotProcessService csmCsAllotProcessService;
    @Resource
    private CsInfoApi csInfoApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ChatSessionService chatSessionService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImCoreService imCoreService;

    @MethodParamVerifyEnable
    public Rsp processCsmTransfer(CsmTransferReqBO csmTransferReqBO) {
        log.info("\u5ba2\u670d\u8f6c\u63a5\u5206\u914d\u5f00\u59cb:{}", (Object)csmTransferReqBO);
        CsmCsAllotReqContext csmCsAllotContext = new CsmCsAllotReqContext();
        csmCsAllotContext.setTenantCode(csmTransferReqBO.getTenantCode());
        csmCsAllotContext.setUserId(csmTransferReqBO.getUserId());
        csmCsAllotContext.setSessionId(csmTransferReqBO.getSessionId());
        csmCsAllotContext.setTransferFromCsId(csmTransferReqBO.getCsId());
        csmCsAllotContext.setAllotCsId(csmTransferReqBO.getAllotCsId());
        csmCsAllotContext.setAllotSkillGid(csmTransferReqBO.getAllotSkillGid());
        csmCsAllotContext.setAllotJoinType(CsAllotJoinType.TRANSFER.getCode());
        csmCsAllotContext.setAllotStrategy(csmTransferReqBO.getAllotStrategy());
        csmCsAllotContext.setAllotRequestId(IdWorker.nextAutoIdStr());
        Rsp<CsmAllotRspContext> rsp = this.csmCsAllotProcessService.processCsmAllot(csmCsAllotContext);
        if (!rsp.isSuccess()) {
            return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u65e0\u53ef\u670d\u52a1\u5750\u5e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        return rsp;
    }

    @Override
    @MethodParamVerifyEnable
    public Rsp<CsmForceOfflineAndTransferRspBO> processForceOfflineAndTransfer(CsmForceOfflineAndTransferReqBO transferReqBO) {
        List<CsSkillGroupInfo> skillGids;
        log.info("\u5750\u5e2d\u5f3a\u5236\u4e0b\u7ebf,\u5f00\u59cb:{}", (Object)transferReqBO);
        CsmForceOfflineAndTransferRspBO transferRspBO = new CsmForceOfflineAndTransferRspBO();
        transferRspBO.setCsId(transferReqBO.getCsId());
        transferRspBO.setTenantCode(transferReqBO.getTenantCode());
        CsInfoBO csInfoBO = this.csmCommonService.getCsInfo(transferReqBO.getCsId());
        if (csInfoBO == null) {
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u6307\u5b9a\u5ba2\u670d\u4e0d\u5b58\u5728!");
        }
        if (CsState.DENY.matchCode(csInfoBO.getCsState())) {
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25:\u8be5\u5ba2\u670d\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c!");
        }
        ImUserDenyReqBO offLineReqBO = ImUserDenyReqBO.builder().tenantCode(transferReqBO.getTenantCode()).userId(transferReqBO.getCsId()).build();
        Rsp setUserOffline = this.imCoreService.setUserForceOffline(offLineReqBO);
        if (!setUserOffline.isSuccess()) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4e0b\u7ebf\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        CsInfoUpdateReqBO csInfoUpdateReqBO = new CsInfoUpdateReqBO();
        csInfoUpdateReqBO.setCsId(transferReqBO.getCsId());
        csInfoUpdateReqBO.setTenantCode(transferReqBO.getTenantCode());
        csInfoUpdateReqBO.setCsState(CsState.DENY.getCode());
        log.info("\u5750\u5e2d\u5f3a\u5236\u4e0b\u7ebf,\u66f4\u65b0\u5ba2\u670d\u72b6\u6001\u4e0b\u7ebf:{}", (Object)csInfoUpdateReqBO);
        this.csInfoApi.updateCsOffline(csInfoUpdateReqBO);
        GetUserActiveSessionReqBO sessionReqBO = new GetUserActiveSessionReqBO();
        sessionReqBO.setUserId(transferReqBO.getCsId());
        sessionReqBO.setQueryMember(true);
        String skillGid = "";
        if (StringUtils.isNotEmpty((CharSequence)transferReqBO.getCsId()) && (skillGids = this.csmCommonService.getCsSkillGidList(transferReqBO.getTenantCode(), transferReqBO.getCsId(), true)) != null && !skillGids.isEmpty()) {
            skillGid = skillGids.get(0).getSkillGid();
        }
        if (StringUtils.isEmpty((CharSequence)skillGid)) {
            log.warn("\u5750\u5e2d\u5f3a\u5236\u4e0b\u7ebf,\u627e\u4e0d\u5230\u5ba2\u670d\u5f52\u5c5e\u6280\u80fd\u7ec4:skillGid = {}", (Object)skillGid);
            return BaseRspUtils.createSuccessRsp((Object)transferRspBO);
        }
        RspList sessionList = this.chatSessionService.getUserActiveSessionList(sessionReqBO);
        if (sessionList.getCount() > 0L) {
            List activeSessionRspBOS = sessionList.getRows();
            for (GetUserActiveSessionBO activeSession : activeSessionRspBOS) {
                List sessionMembers = activeSession.getSessionMembers();
                String userId = "";
                for (ChatSessionMemberBO sessionMember : sessionMembers) {
                    if (UserTypeField.USER.getShotCode() != sessionMember.getUserType()) continue;
                    userId = sessionMember.getUserId();
                    break;
                }
                if (!StringUtils.isNotEmpty((CharSequence)userId)) continue;
                CsmCsAllotReqContext csmCsAllotContext = new CsmCsAllotReqContext();
                csmCsAllotContext.setTenantCode(transferReqBO.getTenantCode());
                csmCsAllotContext.setUserId(userId);
                csmCsAllotContext.setSessionId(activeSession.getSessionId());
                csmCsAllotContext.setTransferFromCsId(transferReqBO.getCsId());
                csmCsAllotContext.setAllotSkillGid(skillGid);
                csmCsAllotContext.setAllotJoinType(CsAllotJoinType.TRANSFER.getCode());
                csmCsAllotContext.setAllotStrategy("");
                Rsp<CsmAllotRspContext> allotRspContextRsp = this.csmCsAllotProcessService.processCsmAllot(csmCsAllotContext);
                log.info("\u5750\u5e2d\u5f3a\u5236\u4e0b\u7ebf\uff0c\u8f6c\u63a5\u5206\u914d\u7ed3\u679c:{}", allotRspContextRsp);
            }
        }
        transferRspBO.setCloseSessionCount(sessionList.getRows().size());
        return BaseRspUtils.createSuccessRsp((Object)transferRspBO);
    }
}

