/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.api.SessionDetailService;
import com.tydic.nicc.common.api.bo.opdata.ESSessionDetailReqBO;
import com.tydic.nicc.common.api.bo.opdata.SessionDetailsDocument;
import com.tydic.nicc.common.bo.session.ChatSessionMemberBO;
import com.tydic.nicc.common.bo.user.UserAccessLogBO;
import com.tydic.nicc.common.bo.user.UserAccessLogQueryReqBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.bo.user.UserQueryReqBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.CsState;
import com.tydic.nicc.common.eums.im.MsgReadStatus;
import com.tydic.nicc.common.eums.im.MsgStatus;
import com.tydic.nicc.common.eums.session.SessionCloseType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.CsmMonitorApi;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsItemCacheBO;
import com.tydic.nicc.csm.api.bo.cs.CsStatusChangeLogBO;
import com.tydic.nicc.csm.api.bo.cs.CsStatusChangeQueryReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorCsInfoBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorCsInfoReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorCsStateLogReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorServiceRecordReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorServiceRecordRspBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorSkillQueueAndReceiveBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorSkillQueueReqBO;
import com.tydic.nicc.csm.api.bo.monitor.SessionDetailsBO;
import com.tydic.nicc.csm.api.bo.monitor.SessionDetailsCount;
import com.tydic.nicc.csm.api.bo.monitor.SessionDetailsCountResult;
import com.tydic.nicc.csm.api.bo.monitor.SessionMsgDetail;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsInfoMapper;
import com.tydic.nicc.csm.mapper.CsSkillGroupMapper;
import com.tydic.nicc.csm.mapper.po.CsInfo;
import com.tydic.nicc.csm.mapper.po.CsInfoQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsSkillGroup;
import com.tydic.nicc.csm.mapper.po.CsSkillGroupQueryCondition;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.DesensitizationUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.admin.api.BladeTenantService;
import com.tydic.nicc.im.bo.BladeTenantBO;
import com.tydic.nicc.user.api.UserAccessLogService;
import com.tydic.nicc.user.api.UserManageService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@DS(value="nicc-csm")
@Service
public class CsmMonitorServiceImpl
implements CsmMonitorApi {
    private static final Logger log = LoggerFactory.getLogger(CsmMonitorServiceImpl.class);
    static final int SQL_QUEUE_SLOW_LIMIT_TIME = 200;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsSkillGroupMapper csSkillGroupMapper;
    @Resource
    private CsmLogCommonService csmLogCommonService;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private CsInfoMapper csInfoMapper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private CsmItemCountService csmItemCountService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    BladeTenantService bladeTenantService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserManageService userManageService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserAccessLogService userAccessLogService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", timeout=300000, group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private SessionDetailService sessionDetailService;

    public RspList skillQueueAndServiceMonitor(MonitorSkillQueueReqBO reqBO) {
        ArrayList queueBOS = Lists.newArrayList();
        CsSkillGroupQueryCondition condition = new CsSkillGroupQueryCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        long startTime = System.currentTimeMillis();
        log.info("\u6280\u80fd\u7ec4\u5b9e\u65f6\u76d1\u63a7 \u63a5\u5f85|\u6392\u961f-\u5f00\u59cb:{}", (Object)condition);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.csSkillGroupMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            for (CsSkillGroup group : page.getResult()) {
                MonitorSkillQueueAndReceiveBO receiveBO = new MonitorSkillQueueAndReceiveBO();
                BeanUtils.copyProperties((Object)group, (Object)receiveBO);
                long queueCount = this.csmCsAllotHelper.getQueueCount(reqBO.getTenantCode(), group.getSkillGid());
                receiveBO.setQueueCount(queueCount);
                long startTime1 = System.currentTimeMillis();
                int receivingCount = this.csmCommonService.skillReceivingCount(reqBO.getTenantCode(), group.getSkillGid());
                receiveBO.setReceivingCount(receivingCount);
                int receivedCountTotal = this.csmItemCountService.getSkillReceivedTotal(group.getTenantCode(), group.getSkillGid());
                receiveBO.setReceivedCountTotal(receivedCountTotal);
                long endTime1 = System.currentTimeMillis();
                if (endTime1 - startTime1 > 200L) {
                    log.warn("\u6280\u80fd\u7ec4\u5b9e\u65f6\u76d1\u63a7,\u7edf\u8ba1\u5b9e\u65f6\u63a5\u5f85\u6570\u67e5\u8be2\u6162,\u8bf7\u4f18\u5316: {} ms ,skillGId = {}", (Object)(endTime1 - startTime1), (Object)group.getSkillGid());
                }
                queueBOS.add(receiveBO);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("\u6280\u80fd\u7ec4\u5b9e\u65f6\u76d1\u63a7 \u63a5\u5f85|\u6392\u961f-\u7ed3\u675f: \u7edf\u8ba1\u6570 {},\u8017\u65f6 {} ms", (Object)page.getTotal(), (Object)(endTime - startTime));
        return BaseRspUtils.createSuccessRspList((List)queueBOS, (long)page.getTotal());
    }

    public RspList csInfoMonitor(MonitorCsInfoReqBO reqBO) {
        log.info("\u5750\u5e2d\u57fa\u672c\u4fe1\u606f\u5b9e\u65f6\u76d1\u63a7\u67e5\u8be2-\u5f00\u59cb:{}", (Object)reqBO);
        long startTime = System.currentTimeMillis();
        List<Object> csInfoBOS = Lists.newArrayList();
        CsInfoQueryCondition condition = new CsInfoQueryCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        if (condition.getNotCsStates() == null) {
            condition.setNotCsStates(Arrays.asList(CsState.DELETED.getCode()));
        }
        String today = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyy-MM-dd");
        condition.setStateStartTime(DateTimeUtil.convertAsDate((String)String.format("%s 00:00:00", today)));
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.csInfoMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            for (CsInfo row : page.getResult()) {
                MonitorCsInfoBO monitorCsInfoBO = new MonitorCsInfoBO();
                BeanUtils.copyProperties((Object)row, (Object)monitorCsInfoBO);
                int count = this.csmCommonService.receivingCount(row.getTenantCode(), row.getCsId());
                monitorCsInfoBO.setReceivingCount(count);
                monitorCsInfoBO.setLiveStatusName(row.getLiveStatusCode());
                if (StringUtils.isNotEmpty((CharSequence)reqBO.getSkillGid())) {
                    CsSkillGroupBO skillGroupBO = this.csmCommonService.getSkillGroupInfo(reqBO.getSkillGid());
                    if (skillGroupBO != null) {
                        monitorCsInfoBO.setSkillGroupName(skillGroupBO.getSkillGroupName());
                        monitorCsInfoBO.setSkillGid(skillGroupBO.getSkillGid());
                        int receivedCountTotal = this.csmCommonService.receivedCount(row.getTenantCode(), reqBO.getSkillGid(), row.getCsId(), false);
                        monitorCsInfoBO.setReceivedCountTotal(receivedCountTotal);
                    }
                } else {
                    Rsp csItemRsp = this.csmItemCountService.getCsAllotItem(row.getTenantCode(), row.getCsId());
                    if (csItemRsp.isSuccess()) {
                        List csSkillGroups = ((CsItemCacheBO)csItemRsp.getData()).getCsSkillGroups();
                        if (csSkillGroups != null && !csSkillGroups.isEmpty()) {
                            List skillIds = csSkillGroups.stream().map(obj -> obj.getSkillGid()).collect(Collectors.toList());
                            List skillNames = csSkillGroups.stream().map(obj -> obj.getSkillGroupName()).collect(Collectors.toList());
                            monitorCsInfoBO.setSkillGroupName(StringUtils.join(skillNames, (String)","));
                            monitorCsInfoBO.setSkillGid(StringUtils.join(skillIds, (String)","));
                        }
                        int receivedCountTotal = ((CsItemCacheBO)csItemRsp.getData()).getReceivedCountTotal();
                        int receivedCountToday = this.csmCommonService.receivedCount(row.getTenantCode(), "", row.getCsId(), true);
                        monitorCsInfoBO.setReceivedCountTotal(receivedCountTotal + receivedCountToday);
                    }
                }
                monitorCsInfoBO.setStatusChangeTime(row.getStatusChangeTime());
                List<String> states = Arrays.asList("\u6574\u7406", "\u7528\u9910", "\u4f11\u606f", "\u793a\u5fd9");
                int countTime = this.csmLogCommonService.countTimeByLoginState(row.getTenantCode(), row.getCsId(), states);
                monitorCsInfoBO.setLeaveTimeTotalSec(Integer.valueOf(countTime));
                String timeTotal = DateTimeUtil.secondToTime((long)countTime, (int)2, (String)"", (String)"", (String)"'", (String)"\"");
                monitorCsInfoBO.setLeaveTimeTotal(timeTotal);
                csInfoBOS.add(monitorCsInfoBO);
            }
            csInfoBOS = csInfoBOS.stream().sorted(Comparator.comparing(MonitorCsInfoBO::getLeaveTimeTotalSec).reversed()).collect(Collectors.toList());
        }
        long endTime = System.currentTimeMillis();
        log.info("\u5750\u5e2d\u57fa\u672c\u4fe1\u606f\u5b9e\u65f6\u76d1\u63a7\u67e5\u8be2-\u7ed3\u675f: \u7edf\u8ba1\u6570 {},\u8017\u65f6 {} ms", (Object)page.getTotal(), (Object)(endTime - startTime));
        return BaseRspUtils.createSuccessRspList((List)csInfoBOS, (long)page.getTotal());
    }

    public RspList csInfoMonitorByRel(MonitorCsInfoReqBO reqBO) {
        log.info("\u5750\u5e2d\u57fa\u672c\u4fe1\u606f\u5b9e\u65f6\u76d1\u63a7\u67e5\u8be2-\u5f00\u59cb:{}", (Object)reqBO);
        long startTime = System.currentTimeMillis();
        ArrayList csInfoBOS = Lists.newArrayList();
        log.info("\u5750\u5e2d\u57fa\u672c\u4fe1\u606f\u5b9e\u65f6\u76d1\u63a7\u67e5\u8be2-\u5206\u9875\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f:{}", (Object)reqBO);
        CsInfoQueryCondition condition = new CsInfoQueryCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.csInfoMapper.selectRelSkillByCondition(condition);
        if (page.getTotal() > 0L) {
            for (CsInfo csInfo : page.getResult()) {
                int count;
                MonitorCsInfoBO monitorCsInfoBO = new MonitorCsInfoBO();
                BeanUtils.copyProperties((Object)csInfo, (Object)monitorCsInfoBO);
                CsSkillGroupBO csSkillGroup = this.csmCommonService.getSkillGroupInfo(csInfo.getSkillGid());
                if (csSkillGroup != null) {
                    long queueCount = this.csmCsAllotHelper.getQueueCount(csInfo.getTenantCode(), csSkillGroup.getSkillGid());
                    monitorCsInfoBO.setQueueCount(queueCount);
                    BeanUtils.copyProperties((Object)csSkillGroup, (Object)monitorCsInfoBO);
                }
                if ((count = this.csmCommonService.receivingCount(csInfo.getTenantCode(), csInfo.getCsId()).intValue()) > 0) {
                    monitorCsInfoBO.setReceivingCount(count);
                }
                csInfoBOS.add(monitorCsInfoBO);
            }
        }
        return null;
    }

    public RspList csStateChangeLogMonitor(MonitorCsStateLogReqBO reqBO) {
        log.info("\u5750\u5e2d\u72b6\u6001\u5b9e\u65f6\u76d1\u63a7\u67e5\u8be2-\u5f00\u59cb:{}", (Object)reqBO);
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{reqBO.getStartTime()})) {
            reqBO.setStartTime(DateTimeUtil.getFirstDayOfMonth((int)0));
        }
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{reqBO.getEndTime()})) {
            reqBO.setEndTime(DateTimeUtil.getLastDayOfMonth((int)1));
        }
        if (reqBO.getLimit() < 0) {
            reqBO.setLimit(99999);
        }
        long startTime = System.currentTimeMillis();
        CsStatusChangeQueryReqBO queryReqBO = new CsStatusChangeQueryReqBO();
        queryReqBO.setPage(reqBO.getPage());
        queryReqBO.setLimit(reqBO.getLimit());
        BeanUtils.copyProperties((Object)reqBO, (Object)queryReqBO);
        RspList changeLogBORspList = this.csmLogCommonService.getCsStatusChangeLogs(queryReqBO);
        HashMap<String, UserAccessLogBO> accessLogMap = new HashMap<String, UserAccessLogBO>();
        HashMap<String, CsInfoBO> csInfoMap = new HashMap<String, CsInfoBO>();
        if (changeLogBORspList.isSuccess() && changeLogBORspList.getCount() > 0L) {
            for (CsStatusChangeLogBO row : changeLogBORspList.getRows()) {
                if (StringUtils.isNotEmpty((CharSequence)row.getLoginId())) {
                    UserAccessLogBO logBO = (UserAccessLogBO)accessLogMap.get(row.getLoginId());
                    if (logBO == null) {
                        UserAccessLogQueryReqBO accessLogQueryReqBO = new UserAccessLogQueryReqBO();
                        accessLogQueryReqBO.setTenantCode(row.getTenantCode());
                        accessLogQueryReqBO.setAccessId(row.getLoginId());
                        accessLogQueryReqBO.setUserId(row.getCsId());
                        Rsp rspLog = this.userAccessLogService.getAccessLog(accessLogQueryReqBO);
                        if (rspLog.isSuccess()) {
                            logBO = (UserAccessLogBO)rspLog.getData();
                            accessLogMap.put(row.getLoginId(), logBO);
                        }
                    }
                    if (logBO != null) {
                        row.setLoginIp(logBO.getIpAddr());
                        row.setLoginRegion(logBO.getRegion());
                        row.setLoginSip(logBO.getSip());
                    }
                }
                CsInfoBO infoBO = null;
                infoBO = (CsInfoBO)csInfoMap.get(row.getCsId());
                if (infoBO == null) {
                    infoBO = this.csmCommonService.getCsInfo(row.getCsId());
                    csInfoMap.put(row.getCsId(), infoBO);
                }
                if (infoBO == null) continue;
                row.setCsName(infoBO.getCsName());
                row.setCsCode(infoBO.getCsCode());
                row.setNickName(infoBO.getNickName());
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("\u5750\u5e2d\u72b6\u6001\u5b9e\u65f6\u76d1\u63a7\u67e5\u8be2-\u7ed3\u675f: \u7edf\u8ba1\u6570 {},\u8017\u65f6 {} ms", (Object)changeLogBORspList.getCount(), (Object)(endTime - startTime));
        return changeLogBORspList;
    }

    @MethodParamVerifyEnable
    public RspList<MonitorServiceRecordRspBO> serviceRecordMonitor(MonitorServiceRecordReqBO serviceRecordReqBO) {
        List csIds;
        log.info("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u5f00\u59cb-1:{}", (Object)serviceRecordReqBO);
        long startTime = System.currentTimeMillis();
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{serviceRecordReqBO.getStartTime()})) {
            serviceRecordReqBO.setStartTime(DateTimeUtil.DateAddDayOfYear((int)-31));
        }
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{serviceRecordReqBO.getEndTime()})) {
            serviceRecordReqBO.setEndTime(new Date());
        }
        if (serviceRecordReqBO.getLimit() < 0) {
            serviceRecordReqBO.setLimit(99999);
        }
        ESSessionDetailReqBO req = new ESSessionDetailReqBO();
        BeanUtils.copyProperties((Object)serviceRecordReqBO, (Object)req);
        req.setBeginTime(DateTimeUtil.getTimeShortString((Date)serviceRecordReqBO.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        req.setEndTime(DateTimeUtil.getTimeShortString((Date)serviceRecordReqBO.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if ("platform".equals(serviceRecordReqBO.getTenantCode())) {
            if (serviceRecordReqBO.getTenantCodeList() == null || serviceRecordReqBO.getTenantCodeList().size() > 0) {
                req.setTenantCode(null);
            } else {
                req.getTenantCodeList().add(serviceRecordReqBO.getTenantCode());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)serviceRecordReqBO.getUserId())) {
            req.setUserId(serviceRecordReqBO.getUserId());
        } else {
            req.setUserId(serviceRecordReqBO.getCsId());
        }
        req.setPageNumber(Integer.valueOf(serviceRecordReqBO.getPage()));
        req.setPageSize(Integer.valueOf(serviceRecordReqBO.getLimit()));
        if (StringUtils.isNotEmpty((CharSequence)serviceRecordReqBO.getLabelId())) {
            csIds = this.csmCommonService.getCsIdsByLabel(serviceRecordReqBO.getTenantCode(), serviceRecordReqBO.getLabelId());
            if (req.getUserIds() != null) {
                req.getUserIds().addAll(csIds);
            } else {
                req.setUserIds(csIds);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceRecordReqBO.getCsName())) {
            csIds = this.csInfoMapper.selectCsIdByName(serviceRecordReqBO.getCsName());
            if (CollectionUtils.isNotEmpty((Collection)req.getUserIds())) {
                req.getUserIds().addAll(csIds);
            } else {
                req.setUserIds(csIds);
            }
        }
        ArrayList queryNameAndUserPhoneList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)serviceRecordReqBO.getNickname()) || StringUtils.isNotBlank((CharSequence)serviceRecordReqBO.getUserPhone())) {
            UserQueryReqBO reqBO = new UserQueryReqBO();
            reqBO.setNickName(serviceRecordReqBO.getNickname());
            reqBO.setUserPhone(serviceRecordReqBO.getUserPhone());
            reqBO.setUserType(UserTypeField.USER.getIntCode());
            RspList userRspList = this.userManageService.getUserList(reqBO);
            if (userRspList.getRows().size() > 0) {
                List userIds = userRspList.getRows().stream().map(UserAuthInfo::getUserId).collect(Collectors.toList());
                if (req.getUserIds() != null) {
                    req.setUserId((String)userIds.get(0));
                } else {
                    req.setUserIds(userIds);
                }
            } else {
                return BaseRspUtils.createSuccessRspList(new ArrayList());
            }
            log.info("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u67e5\u8be2\u7528\u6237\u4fe1\u606f:{},{}", (Object)reqBO, (Object)queryNameAndUserPhoneList);
        }
        log.info("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u5f00\u59cb-2:{}", (Object)req);
        RspList sessionDetail = this.sessionDetailService.searchSessionDetail(req);
        ArrayList recordRspBOS = Lists.newArrayList();
        List documents = sessionDetail.getRows();
        if (sessionDetail.isSuccess()) {
            for (SessionDetailsDocument row : documents) {
                MonitorServiceRecordRspBO recordRspBO = new MonitorServiceRecordRspBO();
                BeanUtils.copyProperties((Object)row, (Object)recordRspBO);
                if (StringUtils.isNotEmpty((CharSequence)row.getSessionDetails()) && !serviceRecordReqBO.isSimplify()) {
                    try {
                        List details = JSONObject.parseArray((String)row.getSessionDetails(), SessionMsgDetail.class);
                        recordRspBO.setDetails(details);
                        if (details != null) {
                            for (SessionMsgDetail detail : details) {
                                if (detail.getMsgStatus() == null) {
                                    detail.setMsgStatus(MsgStatus.RECEIVED.getShortCode());
                                }
                                if (UserTypeField.USER.getCode().equals(detail.getFromType())) {
                                    detail.setUserName(this.maskUserName(detail.getUserName()));
                                }
                                if (StringUtils.isBlank((CharSequence)detail.getMsgReceipt())) {
                                    detail.setMsgReceipt(MsgReadStatus.READ.getCode());
                                }
                                if (!StringUtils.isBlank((CharSequence)detail.getUserName())) continue;
                                detail.setUserName(detail.getNickName());
                            }
                        }
                    }
                    catch (JSONException e) {
                        log.error("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u4f1a\u8bdd\u660e\u7ec6\u5e8f\u5217\u5316\u5f02\u5e38: details = {}", (Object)row.getSessionDetails(), (Object)e);
                    }
                }
                ArrayList<String> csNames = new ArrayList<String>();
                ArrayList<String> csCodes = new ArrayList<String>();
                if (StringUtils.isNotEmpty((CharSequence)row.getSessionMembers())) {
                    List memberBOs = JSONObject.parseArray((String)row.getSessionMembers(), ChatSessionMemberBO.class);
                    if (ObjectUtils.anyNotNull((Object[])new Object[]{memberBOs})) {
                        for (ChatSessionMemberBO memberBO : memberBOs) {
                            UserAuthInfo userInfo = memberBO.getUserAuthInfo();
                            if (userInfo == null) {
                                log.warn("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u6210\u5458\u4fe1\u606f\u5f02\u5e38:{}", (Object)row.getSessionMembers());
                                continue;
                            }
                            if (UserTypeField.COMP_USER.getCode().equals(userInfo.getUserType())) {
                                if (StringUtils.isEmpty((CharSequence)recordRspBO.getCsId())) {
                                    recordRspBO.setCsId(userInfo.getUserId());
                                    recordRspBO.setCsName(userInfo.getUserName());
                                    recordRspBO.setCsNick(userInfo.getNickName());
                                }
                                csNames.add(userInfo.getUserName());
                                csCodes.add(userInfo.getExtUid());
                            }
                            if (!UserTypeField.USER.getCode().equals(userInfo.getUserType())) continue;
                            recordRspBO.setUserNick(this.maskUserName(userInfo.getNickName()));
                            recordRspBO.setProvince(userInfo.getProvince());
                            recordRspBO.setCity(userInfo.getCity());
                            recordRspBO.setUserPhone(userInfo.getCallNum());
                        }
                    } else {
                        log.warn("\u89e3\u6790\u4f1a\u8bdd\u6210\u5458\u5f02\u5e38:memberBOs = {}", (Object)row.getSessionMembers());
                    }
                }
                recordRspBO.setCloseTypeName(SessionCloseType.getNameByCode((Integer)row.getCloseType()));
                recordRspBO.setCsNames(StringUtils.join(csNames, (String)","));
                recordRspBO.setCsCode(StringUtils.join(csCodes, (String)","));
                String skillGid = row.getSkillGid();
                CsSkillGroup skillGroup = this.csSkillGroupMapper.selectByPrimaryKey(row.getSkillGid());
                if (skillGroup != null) {
                    recordRspBO.setSkillGid(skillGid);
                    recordRspBO.setSkillGroupName(skillGroup.getSkillGroupName());
                } else {
                    log.warn("\u67e5\u8be2\u6280\u80fd\u7ec4\u5f02\u5e38:skillGid = {}", (Object)skillGid);
                }
                try {
                    String tenantName = "";
                    Rsp rspTenant = this.bladeTenantService.queryById(row.getTenantCode());
                    if (rspTenant.isSuccess()) {
                        tenantName = ((BladeTenantBO)rspTenant.getData()).getTenantName();
                    }
                    recordRspBO.setTenantName(tenantName);
                }
                catch (Exception e) {
                    log.info("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u83b7\u53d6\u79df\u6237\u5f02\u5e38: {}", (Object)e.getMessage());
                }
                recordRspBOS.add(recordRspBO);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u7ed3\u675f: \u7edf\u8ba1\u6570 {},\u8017\u65f6 {} ms", (Object)sessionDetail.getCount(), (Object)(endTime - startTime));
        return BaseRspUtils.createSuccessRspList((List)recordRspBOS, (long)sessionDetail.getCount());
    }

    public Rsp<SessionDetailsCountResult> serviceRecordHistoryByDay(MonitorServiceRecordReqBO serviceRecordReqBO) {
        RspList<MonitorServiceRecordRspBO> serviceList;
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{serviceRecordReqBO.getUserId(), serviceRecordReqBO.getUserPhone(), serviceRecordReqBO.getUserIp()})) {
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25,\u53c2\u6570\u5f02\u5e38!");
        }
        serviceRecordReqBO.setLimit(1000);
        String userPhone = serviceRecordReqBO.getUserPhone();
        String searchType = "phone";
        if (StringUtils.isNotBlank((CharSequence)userPhone)) {
            serviceRecordReqBO.setUserIp("");
            serviceList = this.serviceRecordMonitor(serviceRecordReqBO);
        } else {
            searchType = "ip";
            serviceRecordReqBO.setUserPhone("");
            serviceList = this.serviceRecordMonitor(serviceRecordReqBO);
        }
        List<Object> details = new ArrayList();
        ArrayList detailsCounts = new ArrayList();
        if (serviceList.getRows().size() > 0) {
            ArrayList sessions = new ArrayList();
            NiccCommonUtil.copyList((List)serviceList.getRows(), sessions, SessionDetailsBO.class);
            Map<String, List<SessionDetailsBO>> sessionDayCount = sessions.stream().sorted(Comparator.comparing(SessionDetailsBO::getBeginTime)).collect(Collectors.groupingBy(SessionDetailsBO::getSessionDate));
            sessionDayCount.forEach((date, list) -> detailsCounts.add(new SessionDetailsCount(date, list)));
            details = detailsCounts.stream().sorted(Comparator.comparing(SessionDetailsCount::getSessionDate).reversed()).collect(Collectors.toList());
        }
        return BaseRspUtils.createSuccessRsp((Object)new SessionDetailsCountResult(searchType, details));
    }

    private String maskUserName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        String[] startNames = this.niccCsmConfigProperties.getNoMaskPrefix().split(",");
        boolean mask = true;
        for (String startName : startNames) {
            if (!name.startsWith(startName)) continue;
            mask = false;
            break;
        }
        if (mask) {
            return DesensitizationUtil.markName((String)name);
        }
        return name;
    }
}

