/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.robot.HitContentResult;
import com.tydic.nicc.common.bo.robot.RobotMessage;
import com.tydic.nicc.common.bo.robot.RobotMessageResult;
import com.tydic.nicc.common.bo.robot.RobotWelcomeResult;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.AutoReplyType;
import com.tydic.nicc.common.eums.csm.CsAutoReplyConfigLevel;
import com.tydic.nicc.common.eums.csm.RobotQaType;
import com.tydic.nicc.common.robot.NiccRobotApi;
import com.tydic.nicc.csm.api.CsRobotManagerApi;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.robot.CsRobotSimpleQaBO;
import com.tydic.nicc.csm.api.bo.robot.CsRobotSimpleQaQueryReqBO;
import com.tydic.nicc.csm.api.bo.robot.RobotQuestionContext;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmRobotQuestionCommonService;
import com.tydic.nicc.csm.mapper.CsSkillGroupMapper;
import com.tydic.nicc.csm.mapper.po.CsSkillGroup;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DS(value="nicc-csm")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class CsmRobotServiceImpl
implements NiccRobotApi {
    private static final Logger log = LoggerFactory.getLogger(CsmRobotServiceImpl.class);
    @Resource
    private CsRobotManagerApi csRobotManagerApi;
    @Resource
    private CsSkillGroupMapper csSkillGroupMapper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmRobotQuestionCommonService csmRobotQuestionCommonService;

    @MethodParamVerifyEnable
    public Rsp sendToRobot(RobotMessage robotMessage) {
        log.info("\u6d88\u606f\u63a8\u9001\u5230robot-\u5f00\u59cb:{}", (Object)robotMessage);
        String skillGid = robotMessage.getChannelCode().replace("pc", "").replace("h5", "");
        CsSkillGroup skillGroup = this.csSkillGroupMapper.selectByPrimaryKey(skillGid);
        boolean krSwitch = false;
        Object errReplyMsg = "";
        String instanceId = "";
        if (skillGroup != null) {
            boolean isJson;
            if (ObjectUtils.anyNotNull((Object[])new Object[]{skillGroup}) && StringUtils.isNotEmpty((CharSequence)skillGroup.getExtInfo()) && (isJson = JSONValidator.from((String)skillGroup.getExtInfo()).validate())) {
                String kSwitch = JSONObject.parseObject((String)skillGroup.getExtInfo()).getString("krSwitch");
                errReplyMsg = JSONObject.parseObject((String)skillGroup.getExtInfo()).getString("errReplyMsg");
                log.info("\u6d88\u606f\u63a8\u9001\u5230robot-\u83b7\u53d6\u5173\u952e\u5b57\u56de\u590d\u914d\u7f6e:{}", (Object)skillGroup.getExtInfo());
                if ("true".equals(kSwitch)) {
                    krSwitch = true;
                } else {
                    log.info("\u6d88\u606f\u63a8\u9001\u5230robot-\u673a\u5668\u4eba\u6b22\u8fce\u8bed\u67e5\u8be2-\u5f00\u5173\u672a\u6253\u5f00.");
                }
            }
            instanceId = skillGid;
        } else {
            List<CsAutoReplyConfigBO> autoReplyUnknownsList = this.csmCommonService.getAutoReplyConfig(robotMessage.getTenantCode(), AutoReplyType.ROBOT_UNKNOWN_REPLY.getCode());
            if (!autoReplyUnknownsList.isEmpty()) {
                krSwitch = true;
                instanceId = robotMessage.getChannelCode();
                List autoReplyUnknowns = autoReplyUnknownsList.stream().filter(obj -> CsAutoReplyConfigLevel.CHANNEL.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(robotMessage.getChannelCode())).collect(Collectors.toList());
                if (autoReplyUnknowns.isEmpty()) {
                    autoReplyUnknowns = autoReplyUnknownsList.stream().filter(obj -> CsAutoReplyConfigLevel.TENANT.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(robotMessage.getTenantCode())).collect(Collectors.toList());
                    instanceId = robotMessage.getTenantCode();
                }
                if (!autoReplyUnknowns.isEmpty()) {
                    errReplyMsg = ((CsAutoReplyConfigBO)autoReplyUnknowns.get(0)).getReplyContent();
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)errReplyMsg) && !((String)errReplyMsg).contains("transfer")) {
            errReplyMsg = (String)errReplyMsg + " <a data-type='transfer' >\u8f6c\u4eba\u5de5</a>";
        }
        if (!krSwitch) {
            if (StringUtils.isEmpty((CharSequence)errReplyMsg)) {
                log.warn("\u6d88\u606f\u63a8\u9001\u5230robot-\u8bf7\u6b63\u786e\u914d\u7f6e\u5f02\u5e38\u8bdd\u672f:skill = {}", (Object)skillGid);
            }
            RobotMessageResult result = RobotMessageResult.builder().isHit(false).krSwitch(krSwitch).errorReply((String)errReplyMsg).hitResults(new ArrayList()).build();
            return BaseRspUtils.createSuccessRsp((Object)result);
        }
        if (StringUtils.isNotEmpty((CharSequence)robotMessage.getQuestion())) {
            ArrayList hitContentResults = Lists.newArrayList();
            CsRobotSimpleQaQueryReqBO queryReqBO = new CsRobotSimpleQaQueryReqBO();
            queryReqBO.setTenantCode(robotMessage.getTenantCode());
            if (skillGroup == null) {
                queryReqBO.setRobotInstanceId(robotMessage.getTenantCode());
            } else {
                queryReqBO.setRobotInstanceId(instanceId);
            }
            queryReqBO.setIsValid(EntityValidType.NORMAL.getCode());
            queryReqBO.setResultCache(true);
            queryReqBO.setLimit(9999);
            List<CsRobotSimpleQaBO> matchQas = this.questionMatch(queryReqBO, robotMessage.getQuestion());
            if (!matchQas.isEmpty()) {
                log.info("\u6d88\u606f\u63a8\u9001\u5230robot- \u547d\u4e2d\u610f\u56fe:{}", matchQas);
                HitContentResult contentResult = HitContentResult.builder().question(matchQas.get(0).getQuestion()).content(matchQas.get(0).getAnswerMsgContent()).qaType(matchQas.get(0).getQaType()).answerMsgType(matchQas.get(0).getAnswerMsgType()).build();
                hitContentResults.add(contentResult);
            }
            RobotMessageResult result = RobotMessageResult.builder().krSwitch(krSwitch).errorReply((String)errReplyMsg).hitResults((List)hitContentResults).build();
            if (hitContentResults.isEmpty()) {
                result.setHit(false);
                this.saveQuestion(robotMessage, "0", "");
            } else {
                result.setHit(true);
                this.saveQuestion(robotMessage, "1", ((HitContentResult)hitContentResults.get(0)).getQuestion());
            }
            log.info("\u6d88\u606f\u63a8\u9001\u5230robot - \u547d\u4e2d\u610f\u56fe\u5217\u8868:{}", (Object)result);
            return BaseRspUtils.createSuccessRsp((Object)result);
        }
        return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u914d\u7f6e\u4fe1\u606f!");
    }

    private void saveQuestion(RobotMessage robotMessage, String hit, String keyword) {
        RobotQuestionContext context = RobotQuestionContext.builder().tenantCode(robotMessage.getTenantCode()).userId(robotMessage.getFromNo()).question(robotMessage.getQuestion()).hit(hit).keyword(keyword).build();
        this.csmRobotQuestionCommonService.saveQuestion(context);
    }

    public Rsp sendToRobot(String imMessage) {
        return null;
    }

    public RspList matchQa(String tenantCode, String question) {
        CsRobotSimpleQaQueryReqBO queryReqBO = new CsRobotSimpleQaQueryReqBO();
        queryReqBO.setTenantCode(tenantCode);
        queryReqBO.setIsValid(EntityValidType.NORMAL.getCode());
        queryReqBO.setResultCache(true);
        queryReqBO.setLimit(9999);
        List<CsRobotSimpleQaBO> simpleQaBOS = this.questionMatch(queryReqBO, question);
        return BaseRspUtils.createSuccessRspList(simpleQaBOS);
    }

    private List<CsRobotSimpleQaBO> questionMatch(CsRobotSimpleQaQueryReqBO queryReqBO, String question) {
        RspList simpleQaBORspList = this.csRobotManagerApi.getRobotSimpleQaList(queryReqBO);
        ArrayList matchQas = Lists.newArrayList();
        if (simpleQaBORspList.getCount() > 0L) {
            log.info("\u5173\u952e\u5b57\u5339\u914d\u5f00\u59cb:{}|{}", (Object)question, (Object)simpleQaBORspList.getCount());
            for (CsRobotSimpleQaBO row : simpleQaBORspList.getRows()) {
                if (RobotQaType.QA_REG.matchCode(row.getQaType()) && this.matchByExp(question, row.getQuestion())) {
                    matchQas.add(row);
                }
                if (!RobotQaType.QA_KEYWORD.matchCode(row.getQaType())) continue;
                if (question.equals(row.getQuestion().trim())) {
                    matchQas.add(row);
                    break;
                }
                if (!question.contains(row.getQuestion().trim())) continue;
                matchQas.add(row);
            }
        }
        return matchQas;
    }

    public Rsp getRobotWelcome(String tenantCode, String channelCode) {
        log.info("\u673a\u5668\u4eba\u6b22\u8fce\u8bed\u67e5\u8be2-\u5f00\u59cb:{}-{}", (Object)tenantCode, (Object)channelCode);
        String channelKey = channelCode.replace("pc", "").replace("h5", "");
        List<CsAutoReplyConfigBO> autoReplyConfigList = this.csmCommonService.getAutoReplyConfig(tenantCode, AutoReplyType.ROBOT_WELCOME.getCode());
        if (ObjectUtils.anyNotNull((Object[])new Object[]{autoReplyConfigList})) {
            List skillReplys = autoReplyConfigList.stream().filter(obj -> CsAutoReplyConfigLevel.SKILL_GROUP.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(channelKey)).collect(Collectors.toList());
            if (skillReplys.isEmpty()) {
                skillReplys = autoReplyConfigList.stream().filter(obj -> CsAutoReplyConfigLevel.CHANNEL.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(channelKey)).collect(Collectors.toList());
            }
            if (skillReplys.isEmpty()) {
                skillReplys = autoReplyConfigList.stream().filter(obj -> CsAutoReplyConfigLevel.TENANT.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(tenantCode)).collect(Collectors.toList());
            }
            if (!skillReplys.isEmpty()) {
                ArrayList welcomeResults = Lists.newArrayList();
                for (CsAutoReplyConfigBO skillReply : skillReplys) {
                    RobotWelcomeResult welcomeResult = new RobotWelcomeResult();
                    welcomeResult.setContent(skillReply.getReplyContent());
                    welcomeResult.setMsgResolver(skillReply.getReplyMsgResolver());
                    welcomeResult.setMsgForm(skillReply.getReplyMsgForm());
                    welcomeResults.add(welcomeResult);
                }
                log.info("\u673a\u5668\u4eba\u6b22\u8fce\u8bed\u67e5\u8be2-\u5339\u914d\u6210\u529f:{}-{}", (Object)channelKey, (Object)welcomeResults);
                return BaseRspUtils.createSuccessRsp((Object)welcomeResults);
            }
        }
        log.warn("\u673a\u5668\u4eba\u6b22\u8fce\u8bed\u67e5\u8be2-\u672a\u5339\u914d\u5230:tenantCode = {},channelCode = {}", (Object)tenantCode, (Object)channelCode);
        return BaseRspUtils.createErrorRsp((String)"\u673a\u5668\u4eba\u6b22\u8fce\u8bed\u67e5\u8be2-\u672a\u5339\u914d\u5230");
    }

    private boolean matchByExp(String content, String matchExp) {
        if (StringUtils.isNotEmpty((CharSequence)matchExp)) {
            return Pattern.matches(matchExp, content);
        }
        return false;
    }
}

