/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.listener;

import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.CsAllotSubmitType;
import com.tydic.nicc.common.eums.csm.CsRouteExceptionDefine;
import com.tydic.nicc.csm.api.bo.cs.CsAllotRecordBO;
import com.tydic.nicc.csm.api.listener.CsAllotExceptionListener;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CommonCsRouteExceptionListener
implements CsAllotExceptionListener {
    private static final Logger log = LoggerFactory.getLogger(CommonCsRouteExceptionListener.class);
    @Resource
    private CsmCommonService csmCommonService;

    public String errCode() {
        return "default";
    }

    public void onAllotError(CsmCsAllotReqContext allotContext, CsRouteExceptionDefine exceptionDefine) {
        log.info("CommonCsRouteExceptionListener:{},{}", (Object)allotContext, (Object)exceptionDefine);
        String chatKey = NiccCommonUtil.getC2bChatKey((String)allotContext.getTenantCode(), (String)allotContext.getUserId());
        CsAllotRecordBO allotRecordBO = new CsAllotRecordBO();
        BeanUtils.copyProperties((Object)allotContext, (Object)allotRecordBO);
        if (StringUtils.isNotEmpty((CharSequence)allotContext.getAllotCsId())) {
            allotRecordBO.setAllotType(CsAllotSubmitType.CS.getCode());
        } else {
            allotRecordBO.setAllotType(CsAllotSubmitType.SKILL.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)allotContext.getAllotCsId())) {
            allotRecordBO.setAllotCsId("--");
        }
        if (StringUtils.isEmpty((CharSequence)allotContext.getAllotSkillGid())) {
            allotRecordBO.setAllotSkillGid("--");
        }
        allotRecordBO.setAllotId(allotContext.getAllotRequestId());
        allotRecordBO.setAllotEndTime(new Date());
        allotRecordBO.setChatKey(chatKey);
        allotRecordBO.setQueueWaitTime(Integer.valueOf(0));
        allotRecordBO.setAllotState(EntityValidType.DELETE.getCode());
        allotRecordBO.setAllotDesc(exceptionDefine.getName() + ":" + exceptionDefine.getCode());
        try {
            this.csmCommonService.saveCsAllotRecord(allotRecordBO);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5750\u5e2d\u5206\u914d\u8bb0\u5f55\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

