/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.listener;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.CsmAllotRspContext;
import com.tydic.nicc.common.bo.csm.CsmUserQueueContext;
import com.tydic.nicc.common.bo.csm.ProcessAllotListenerResult;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.bo.rocketmq.CsFreeEventContext;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.CsAllotJoinType;
import com.tydic.nicc.common.eums.csm.CsAllotSubmitType;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.csm.api.bo.cs.CsAllotRecordBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotRecordUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotTransferRecordBO;
import com.tydic.nicc.csm.api.bo.cs.CsReceivingChangeLogBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleCheck;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleCheckResult;
import com.tydic.nicc.csm.api.listener.CsAllotRouteServiceListener;
import com.tydic.nicc.csm.busi.CsWorkScheduleCommonService;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.utils.AutoReplyNoticeHelper;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.core.api.ImMessageService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DefaultCsAllotListener
implements CsAllotRouteServiceListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultCsAllotListener.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmLogCommonService csmLogCommonService;
    @Resource
    private CsWorkScheduleCommonService csWorkScheduleCommonService;
    @Resource
    private CsmItemCountService csmItemCountService;
    @Resource
    private AutoReplyNoticeHelper autoReplyNoticeHelper;

    public int order() {
        return -9999;
    }

    public ProcessAllotListenerResult onReceivedCsmFreeRequest(CsFreeEventContext csFreeEventContext) {
        return ProcessAllotListenerResult.builder().allotAllow(true).build();
    }

    public ProcessAllotListenerResult onBeforeRoute(CsmCsAllotReqContext allotContext) {
        String chatKey;
        boolean hasSession;
        CsmUserQueueContext queueContext = this.csmCsAllotHelper.getUserQueueInfo(allotContext.getUserId());
        String requestId = allotContext.getAllotRequestId();
        if (queueContext != null) {
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u8def\u7531\u524d-\u68c0\u6d4b\u5230\u6b63\u5728\u6392\u961f\u4e2d:{}", (Object)requestId, (Object)allotContext);
            ImMessage message = this.csmCsAllotHelper.packageSysQueueMessage(queueContext);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u8def\u7531\u524d-\u63a8\u9001\u6392\u961f\u6d88\u606f:{}", (Object)queueContext.getUserId(), (Object)message);
            return ProcessAllotListenerResult.builder().reason("\u7528\u6237\u6b63\u5728\u6392\u961f\u4e2d").allotAllow(false).build();
        }
        if (StringUtils.isEmpty((CharSequence)allotContext.getTransferFromCsId()) && (hasSession = this.csmCsAllotHelper.hasUserSession(chatKey = NiccCommonUtil.getC2bChatKey((String)allotContext.getTenantCode(), (String)allotContext.getUserId())))) {
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d[{}]-\u8def\u7531\u524d-\u68c0\u6d4b\u5230\u6b63\u5728\u4f1a\u8bdd\u4e2d:{}", (Object)requestId, (Object)allotContext);
            return ProcessAllotListenerResult.builder().reason("\u7528\u6237\u6b63\u5728\u4f1a\u8bdd\u4e2d").allotAllow(false).build();
        }
        return ProcessAllotListenerResult.builder().allotAllow(true).build();
    }

    public ProcessAllotListenerResult onAfterRoute(CsmCsAllotReqContext allotContext, RouteAllotRsp allotRsp) {
        CsWorkScheduleCheck scheduleCheck = CsWorkScheduleCheck.builder().tenantCode(allotContext.getTenantCode()).skillGid(allotRsp.getAllotSkillGid()).build();
        if (allotRsp.getAllotCsInfo() != null) {
            scheduleCheck.setCsId(allotRsp.getAllotCsInfo().getCsId());
        }
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u8def\u7531\u540e-\u6821\u9a8c\u5de5\u4f5c\u65f6\u95f4:{}", (Object)scheduleCheck);
        CsWorkScheduleCheckResult checkResult = this.csWorkScheduleCommonService.checkCsWorkSchedule(scheduleCheck);
        if (!checkResult.isMatch() && checkResult.isLeaveMsg()) {
            this.autoReplyNoticeHelper.pushSysNoWorkingNotice(allotContext.getTenantCode(), allotRsp.getAllotSkillGid(), allotContext.getUserId());
            return ProcessAllotListenerResult.builder().reason("\u5f53\u524d\u4e3a\u975e\u5de5\u4f5c\u65f6\u95f4").allotAllow(false).build();
        }
        return ProcessAllotListenerResult.builder().allotAllow(true).build();
    }

    public void onAfterAllotCs(CsmCsAllotReqContext allotContext, CsmAllotRspContext rspContext, String joinSessionId) {
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210-\u5ba2\u670d\u5206\u914d\u6d41\u7a0b\u5b8c\u6210:joinSessionId = {},allotContext = {},allotRsp = {}", new Object[]{joinSessionId, JSONObject.toJSONString((Object)allotContext), JSONObject.toJSONString((Object)rspContext)});
        Date allotTime = new Date();
        int queueWaitTime = 0;
        String csId = "";
        RouteAllotRsp allotRsp = rspContext.getAllotRsp();
        if (StringUtils.isNotEmpty((CharSequence)joinSessionId)) {
            this.csmItemCountService.skillAllotSuccess(allotContext.getTenantCode(), allotRsp.getAllotSkillGid(), joinSessionId);
            AllotCsInfo csInfo = rspContext.getAllotRsp().getAllotCsInfo();
            csId = csInfo.getCsId();
            if (CsAllotJoinType.TRANSFER.matchCode(allotContext.getAllotJoinType())) {
                CsAllotRecordUpdateReqBO updateReqBO = new CsAllotRecordUpdateReqBO();
                updateReqBO.setTenantCode(allotContext.getTenantCode());
                updateReqBO.setSessionId(allotContext.getSessionId());
                updateReqBO.setAllotCsId(allotContext.getTransferFromCsId());
                updateReqBO.setServiceEndTime(new Date());
                this.csmCommonService.updateCsAllotServiceEnd(updateReqBO);
            }
            int count = this.csmCommonService.receivingCount(allotContext.getTenantCode(), csId);
            CsReceivingChangeLogBO changeLogBO = new CsReceivingChangeLogBO();
            changeLogBO.setTenantCode(allotContext.getTenantCode());
            changeLogBO.setCsId(csId);
            changeLogBO.setChangeTime(new Date());
            changeLogBO.setCurrReceptionNum(Integer.valueOf(count));
            if (count > 0) {
                changeLogBO.setLastReceptionNum(Integer.valueOf(count - 1));
            } else {
                changeLogBO.setLastReceptionNum(Integer.valueOf(0));
            }
            this.csmLogCommonService.saveCsReceivingLog(changeLogBO);
            if (ObjectUtils.anyNotNull((Object[])new Object[]{allotContext.getQueueContext()})) {
                CsmUserQueueContext queueContext = allotContext.getQueueContext();
                queueWaitTime = queueContext.getWaitTime();
                List<Object> queueList = this.csmCsAllotHelper.getQueueList(queueContext.getQueueKey());
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210-\u62c9\u53d6\u5230\u7528\u6237\u6392\u961f\u5217\u8868:{}", queueList);
                if (ObjectUtils.anyNotNull((Object[])new Object[]{queueList})) {
                    int index = 0;
                    for (Object o : queueList) {
                        ++index;
                        CsmUserQueueContext csmUserQueueContext = (CsmUserQueueContext)o;
                        if (csmUserQueueContext.getUserId().equals(allotContext.getUserId())) continue;
                        csmUserQueueContext.setQueuePosition(index);
                        csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210-\u901a\u77e5\u7528\u6237\u6392\u961f\u53d8\u5316:{}", (Object)csmUserQueueContext);
                        ImMessage message = this.csmCsAllotHelper.packageSysQueueMessage(csmUserQueueContext);
                        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210-\u63a8\u9001\u7528\u6237 {} \u6392\u961f\u6d88\u606f:{}", (Object)csmUserQueueContext.getUserId(), (Object)message);
                        this.imMessageService.sendMessageToUser(message);
                    }
                }
            }
            try {
                this.autoReplyNoticeHelper.pushAllotedNotice(allotContext, rspContext.getAllotRsp(), joinSessionId);
            }
            catch (Exception e) {
                log.error("\u5750\u5e2d\u5206\u914d,\u5904\u7406\u5206\u914d\u901a\u77e5\u5f02\u5e38:", (Throwable)e);
            }
        }
        try {
            String chatKey = NiccCommonUtil.getC2bChatKey((String)allotContext.getTenantCode(), (String)allotContext.getUserId());
            if (StringUtils.isEmpty((CharSequence)csId) && allotRsp.getAllotCsInfo() != null) {
                csId = allotRsp.getAllotCsInfo().getCsId();
            }
            if (CsAllotJoinType.TRANSFER.getCode().equals(allotContext.getAllotJoinType())) {
                CsAllotTransferRecordBO transferRecordBO = new CsAllotTransferRecordBO();
                BeanUtils.copyProperties((Object)allotContext, (Object)transferRecordBO);
                transferRecordBO.setChatKey(chatKey);
                transferRecordBO.setTransferId(IdWorker.nextAutoIdStr());
                transferRecordBO.setAllotSkillGid(rspContext.getAllotRsp().getAllotSkillGid());
                transferRecordBO.setAllotCsId(csId);
                transferRecordBO.setTransferTime(allotTime);
                transferRecordBO.setTransferFrom(allotContext.getTransferFromCsId());
                transferRecordBO.setJoinType(CsAllotJoinType.TRANSFER.getCode());
                if (StringUtils.isNotEmpty((CharSequence)allotContext.getAllotCsId())) {
                    transferRecordBO.setAllotType(CsAllotSubmitType.CS.getCode());
                } else {
                    transferRecordBO.setAllotType(CsAllotSubmitType.SKILL.getCode());
                }
                this.csmCommonService.saveCsAllotTransferRecord(transferRecordBO);
            } else {
                CsAllotRecordBO allotRecordBO = new CsAllotRecordBO();
                BeanUtils.copyProperties((Object)allotContext, (Object)allotRecordBO);
                allotRecordBO.setAllotId(allotContext.getAllotRequestId());
                allotRecordBO.setSessionId(joinSessionId);
                if (StringUtils.isNotEmpty((CharSequence)allotContext.getAllotCsId())) {
                    allotRecordBO.setAllotType(CsAllotSubmitType.CS.getCode());
                } else {
                    allotRecordBO.setAllotType(CsAllotSubmitType.SKILL.getCode());
                }
                allotRecordBO.setAllotCsId(csId);
                allotRecordBO.setAllotSkillGid(allotRsp.getAllotSkillGid());
                allotRecordBO.setAllotStrategy(allotRsp.getAllotStrategy());
                allotRecordBO.setAllotEndTime(allotTime);
                allotRecordBO.setChatKey(chatKey);
                allotRecordBO.setQueueWaitTime(Integer.valueOf(queueWaitTime));
                allotRecordBO.setJoinType(allotContext.getAllotJoinType());
                if (StringUtils.isNotEmpty((CharSequence)joinSessionId)) {
                    allotRecordBO.setAllotState(EntityValidType.NORMAL.getCode());
                    allotRecordBO.setAllotDesc("\u5206\u914d\u6210\u529f");
                } else {
                    allotRecordBO.setAllotState(EntityValidType.DELETE.getCode());
                    allotRecordBO.setAllotDesc("\u4f1a\u8bdd\u521b\u5efa\u5931\u8d25");
                }
                this.csmCommonService.saveCsAllotRecord(allotRecordBO);
            }
        }
        catch (Exception e) {
            log.error("\u5750\u5e2d\u5206\u914d|\u8f6c\u63a5\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25:", (Throwable)e);
        }
    }

    public void onAfterAllotRobot(CsmCsAllotReqContext allotContext, CsmAllotRspContext rspContext, boolean success) {
        log.info("onAfterAllotRobot:{},{}", (Object)allotContext, (Object)rspContext);
    }

    public void onAfterInQueue(CsmUserQueueContext queueContext) {
        log.info("\u901a\u77e5\u7528\u6237\u8fdb\u5165\u6392\u961f\u72b6\u6001:{}", (Object)queueContext);
        ImMessage message = this.csmCsAllotHelper.packageSysQueueMessage(queueContext);
        log.info("\u63a8\u9001\u7528\u6237 {} \u6392\u961f\u6d88\u606f:{}", (Object)queueContext.getUserId(), (Object)message);
        this.imMessageService.sendMessageToUser(message);
    }
}

