/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.sentence.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.csm.api.bo.sentence.CommSentence;
import com.tydic.nicc.csm.api.bo.sentence.CommSentenceRow;
import com.tydic.nicc.csm.api.bo.sentence.QueryCommSentencePageListReqBO;
import com.tydic.nicc.csm.api.sentence.CommSentenceService;
import com.tydic.nicc.csm.mapper.CommSentenceMapper;
import com.tydic.nicc.csm.mapper.CsCommonWordsContentMapper;
import com.tydic.nicc.csm.mapper.po.CsCommonWordsContentPo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommSentenceServiceImpl
implements CommSentenceService {
    private static final Logger log = LoggerFactory.getLogger(CommSentenceServiceImpl.class);
    @Resource
    private CsCommonWordsContentMapper csCommonWordsContentMapper;
    @Resource
    private CommSentenceMapper commSentenceMapper;

    @Transactional
    public Rsp saveCommSentence(CommSentence req) {
        log.info("\u4fdd\u5b58\u5e38\u7528\u8bed : {}", (Object)JSON.toJSONString((Object)req));
        Date nowTime = new Date();
        if (req.getContent().length() > 500) {
            return BaseRspUtils.createErrorRsp((String)"\u5e38\u7528\u8bed\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7500\u5b57\u7b26");
        }
        CsCommonWordsContentPo record = new CsCommonWordsContentPo();
        BeanUtils.copyProperties((Object)req, (Object)record);
        record.setUpdateUserId(req.getCreateUserId());
        record.setUpdateTime(nowTime);
        record.setCreateTime(nowTime);
        int res = this.commSentenceMapper.insert(record);
        if (res > 0) {
            return BaseRspUtils.createSuccessRsp((Object)record, (String)"\u4fdd\u5b58\u5e38\u7528\u8bed\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5e38\u7528\u8bed\u5931\u8d25");
    }

    @Transactional
    public Rsp updateCommSentence(CommSentence req) {
        log.info("\u66f4\u65b0\u5e38\u7528\u8bed : {}", (Object)JSON.toJSONString((Object)req));
        Long sentenceId = req.getSentenceId();
        CsCommonWordsContentPo record = this.csCommonWordsContentMapper.selectByPrimaryKey(sentenceId);
        if (ObjectUtils.isEmpty((Object)record)) {
            return BaseRspUtils.createErrorRsp((String)"\u5e38\u7528\u8bed\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (req.getContent().length() > 500) {
            return BaseRspUtils.createErrorRsp((String)"\u5e38\u7528\u8bed\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7500\u5b57\u7b26");
        }
        Date nowTime = new Date();
        BeanUtils.copyProperties((Object)req, (Object)record);
        record.setUpdateTime(nowTime);
        this.csCommonWordsContentMapper.updateByPrimaryKeySelective(record);
        log.debug("\u66f4\u65b0\u5e38\u7528\u8bed\u6210\u529f, sentenceId={}", (Object)sentenceId);
        return BaseRspUtils.createSuccessRsp(null, (String)"\u4fee\u6539\u6210\u529f");
    }

    @Transactional
    public Rsp deleteCommSentence(CommSentence req) {
        log.info("\u5220\u9664\u5e38\u7528\u8bed : {}", (Object)JSON.toJSONString((Object)req));
        Long sentenceId = req.getSentenceId();
        CsCommonWordsContentPo record = this.csCommonWordsContentMapper.selectByPrimaryKey(sentenceId);
        if (record == null) {
            return BaseRspUtils.createErrorRsp((String)"\u5e38\u7528\u8bed\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u52ff\u591a\u6b21\u64cd\u4f5c");
        }
        int i = this.csCommonWordsContentMapper.deleteByPrimaryKey(sentenceId);
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp(null, (String)"\u5220\u9664\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5931\u8d25");
    }

    public RspList getCommSentencePageList(QueryCommSentencePageListReqBO req) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", req.getTenantCode());
        params.put("typeGroup", req.getTypeGroup());
        if (req.getTypeGroup() == 2) {
            params.put("csCode", req.getUserId());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getTypeId())) {
            params.put("typeId", req.getTypeId());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getContent())) {
            params.put("content", req.getContent());
        }
        Page res = PageHelper.startPage((int)req.getPage(), (int)req.getLimit());
        this.commSentenceMapper.getCommSentencePageList(params);
        ArrayList rows = new ArrayList();
        NiccCommonUtil.copyList((List)res.getResult(), rows, CommSentenceRow.class);
        return BaseRspUtils.createSuccessRspList((List)res.getResult(), (long)res.getTotal());
    }

    private Short parseShort(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) ? Short.valueOf(Short.parseShort(value)) : null;
    }

    private Integer parseInt(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    private Long parseLong(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) ? Long.valueOf(Long.parseLong(value)) : null;
    }
}

