/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.sentence.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.csm.api.bo.sentence.CommSentenceTypeBO;
import com.tydic.nicc.csm.api.bo.sentence.DelCommSentenceTypeReqBO;
import com.tydic.nicc.csm.api.bo.sentence.QueryCommSentenceTreeReqBO;
import com.tydic.nicc.csm.api.bo.sentence.SaveCommSentenceTypeReqBO;
import com.tydic.nicc.csm.api.bo.sentence.UpdateCommSentenceTypeReqBO;
import com.tydic.nicc.csm.api.bo.sentence.ValidTypeNameReqBO;
import com.tydic.nicc.csm.api.bo.sentence.ValidTypeNameRspBO;
import com.tydic.nicc.csm.api.bo.sentence.sentenceEnum.SentenceEnum;
import com.tydic.nicc.csm.api.sentence.CommSentenceTypeService;
import com.tydic.nicc.csm.mapper.CsCommonWordsClassifyMapper;
import com.tydic.nicc.csm.mapper.CsCommonWordsContentMapper;
import com.tydic.nicc.csm.mapper.po.CsCommonWordsClassifyPo;
import com.tydic.nicc.csm.mapper.po.CsCommonWordsContentPo;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CommSentenceTypeServiceImpl
implements CommSentenceTypeService {
    private static final Logger log = LoggerFactory.getLogger(CommSentenceTypeServiceImpl.class);
    @Resource
    CsCommonWordsClassifyMapper csCommonWordsClassifyMapper;
    @Resource
    private CsCommonWordsContentMapper csCommonWordsContentMapper;

    @MethodParamVerifyEnable
    public Rsp saveCommSentenceType(SaveCommSentenceTypeReqBO reqBO) {
        int res;
        log.info("\u4fdd\u5b58\u5e38\u7528\u8bed\u5206\u7c7b \uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        ValidTypeNameReqBO var = new ValidTypeNameReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)var);
        Rsp<ValidTypeNameRspBO> rsp = this.validTypeName(var);
        if (!((ValidTypeNameRspBO)rsp.getData()).getUnique().booleanValue()) {
            return BaseRspUtils.createErrorRsp((String)"\u5e38\u7528\u8bed\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (reqBO.getTypeName().length() > 100) {
            return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25,\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u5927\u4e8e100\u5b57\u7b26");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getTypeDesc()) && reqBO.getTypeDesc().length() > 200) {
            return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25\uff0c\u7c7b\u76ee\u63cf\u8ff0\u4e0d\u80fd\u5927\u4e8e200\u5b57\u7b26");
        }
        CsCommonWordsClassifyPo po = new CsCommonWordsClassifyPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setCreateUserId(reqBO.getUserId());
        po.setCreateTime(new Date());
        if (!SentenceEnum.TYPE_GROUP_PUBLIC.getCode().equals(reqBO.getTypeGroup().toString())) {
            po.setCustCode(reqBO.getUserId());
        }
        if ((res = this.csCommonWordsClassifyMapper.insertSelective(po)) > 0) {
            log.info("\u65b0\u589e\u5e38\u7528\u8bed\u5206\u7c7b\u6210\u529f");
            return BaseRspUtils.createSuccessRsp(null);
        }
        log.info("\u65b0\u589e\u5e38\u7528\u8bed\u5206\u7c7b\u5931\u8d25");
        return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5e38\u7528\u8bed\u5206\u7c7b\u5931\u8d25");
    }

    @MethodParamVerifyEnable
    public Rsp updateCommSentenceType(UpdateCommSentenceTypeReqBO reqBo) {
        log.info("\u66f4\u65b0\u5e38\u7528\u8bed\u5206\u7c7b \uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        ValidTypeNameReqBO var = new ValidTypeNameReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)var);
        var.setTypeId(reqBo.getTypeId().toString());
        var.setUpdate(true);
        Rsp<ValidTypeNameRspBO> rsp = this.validTypeName(var);
        if (!((ValidTypeNameRspBO)rsp.getData()).getUnique().booleanValue()) {
            return BaseRspUtils.createErrorRsp((String)"\u5e38\u7528\u8bed\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (reqBo.getTypeName().length() > 100) {
            return BaseRspUtils.createErrorRsp((String)"\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u5927\u4e8e100\u5b57\u7b26");
        }
        if (reqBo.getTypeDesc().length() > 200) {
            return BaseRspUtils.createErrorRsp((String)"\u7c7b\u76ee\u63cf\u8ff0\u4e0d\u80fd\u5927\u4e8e200\u5b57\u7b26");
        }
        CsCommonWordsClassifyPo po = new CsCommonWordsClassifyPo();
        po.setTenantCode(reqBo.getTenantCode());
        po.setTypeId(Long.valueOf(reqBo.getTypeId().shortValue()));
        List list = this.csCommonWordsClassifyMapper.selectByPo(po);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            CsCommonWordsClassifyPo beforeUp = (CsCommonWordsClassifyPo)list.get(0);
            beforeUp.setTypeName(reqBo.getTypeName());
            beforeUp.setTypeDesc(reqBo.getTypeDesc());
            beforeUp.setSortId(reqBo.getSortId());
            beforeUp.setUpdateTime(new Date());
            beforeUp.setUpdateUserId(reqBo.getUserId());
            int res = this.csCommonWordsClassifyMapper.updateByPrimaryKeySelective(beforeUp);
            if (res > 0) {
                log.info("\u4fee\u6539\u5e38\u7528\u8bed\u5206\u7c7b\u6210\u529f");
                return BaseRspUtils.createSuccessRsp(null, (String)"\u4fee\u6539\u5e38\u7528\u8bed\u5206\u7c7b\u6210\u529f");
            }
        }
        return BaseRspUtils.createErrorRsp((String)"\u4fee\u6539\u5e38\u7528\u8bed\u5206\u7c7b\u5931\u8d25");
    }

    @MethodParamVerifyEnable
    @Transactional(rollbackFor={Exception.class})
    public Rsp deleteCommSentenceType(DelCommSentenceTypeReqBO reqBo) {
        Long typeId = Long.parseLong(reqBo.getTypeId());
        CsCommonWordsClassifyPo po = new CsCommonWordsClassifyPo();
        po.setTenantCode(reqBo.getTenantCode());
        po.setTypeId(typeId);
        Page result = PageHelper.startPage((int)reqBo.getPage(), (int)reqBo.getLimit());
        this.csCommonWordsClassifyMapper.selectByPo(po);
        List list = result.getResult();
        if (list != null && list.size() > 0 && list.get(0) != null) {
            CsCommonWordsClassifyPo beforeDelete = (CsCommonWordsClassifyPo)list.get(0);
            CsCommonWordsClassifyPo delPO = new CsCommonWordsClassifyPo();
            delPO.setTenantCode(reqBo.getTenantCode());
            delPO.setParentId(beforeDelete.getTypeId());
            List delRes = this.csCommonWordsClassifyMapper.selectByPo(delPO);
            if (!CollectionUtils.isEmpty((Collection)delRes)) {
                return BaseRspUtils.createErrorRsp((String)"\u8be5\u7c7b\u578b\u4e0b\u6709\u5b50\u7c7b\u578b\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            CsCommonWordsContentPo contPO = new CsCommonWordsContentPo();
            contPO.setTenantCode(reqBo.getTenantCode());
            contPO.setTypeId(beforeDelete.getTypeId());
            List conRes = this.csCommonWordsContentMapper.selectByPo(contPO);
            if (!CollectionUtils.isEmpty((Collection)conRes)) {
                return BaseRspUtils.createErrorRsp((String)"\u8be5\u7c7b\u578b\u4e0b\u6709\u5185\u5bb9\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            int res = this.csCommonWordsClassifyMapper.deleteByPrimaryKey(typeId);
            if (res > 0) {
                CsCommonWordsClassifyPo commSentenceTypePo = new CsCommonWordsClassifyPo();
                commSentenceTypePo.setParentId(typeId);
                commSentenceTypePo.setTenantCode(reqBo.getTenantCode());
                List commSentenceTypePoList = this.csCommonWordsClassifyMapper.selectByPo(commSentenceTypePo);
                if (!CollectionUtils.isEmpty((Collection)commSentenceTypePoList)) {
                    List typeIdList = commSentenceTypePoList.stream().map(CsCommonWordsClassifyPo::getTypeId).collect(Collectors.toList());
                    typeIdList.add(typeId);
                    this.csCommonWordsContentMapper.deleteByTypeIds(reqBo.getTenantCode(), typeIdList);
                    this.csCommonWordsClassifyMapper.deleteByParentId(reqBo.getTenantCode(), Long.valueOf(reqBo.getTypeId()));
                }
                log.info("\u5220\u9664\u5e38\u7528\u8bed\u5206\u7c7b\u6210\u529f");
                return BaseRspUtils.createSuccessRsp(null, (String)"\u5220\u9664\u5e38\u7528\u8bed\u5206\u7c7b\u6210\u529f");
            }
        }
        return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5e38\u7528\u8bed\u5206\u7c7b\u5931\u8d25");
    }

    @MethodParamVerifyEnable
    public Rsp<ValidTypeNameRspBO> validTypeName(ValidTypeNameReqBO reqBo) {
        ValidTypeNameRspBO validTypeNameRspBo = new ValidTypeNameRspBO();
        String custCode = null;
        if (!SentenceEnum.TYPE_GROUP_PUBLIC.getCode().equals(reqBo.getTypeGroup().toString())) {
            custCode = reqBo.getUserId();
        }
        Long typeId = null;
        if (reqBo.getTypeId() != null) {
            typeId = Long.valueOf(reqBo.getTypeId());
        }
        CsCommonWordsClassifyPo condition = new CsCommonWordsClassifyPo();
        condition.setTypeName(reqBo.getTypeName());
        condition.setTenantCode(reqBo.getTenantCode());
        condition.setCustCode(custCode);
        List res = this.csCommonWordsClassifyMapper.selectByCondition(condition);
        if (res.size() > 0) {
            if (reqBo.isUpdate() && ((CsCommonWordsClassifyPo)res.get(0)).getTypeId().equals(typeId)) {
                validTypeNameRspBo.setUnique(Boolean.valueOf(true));
                return BaseRspUtils.createSuccessRsp((Object)validTypeNameRspBo);
            }
            validTypeNameRspBo.setUnique(Boolean.valueOf(false));
            return BaseRspUtils.createSuccessRsp((Object)validTypeNameRspBo);
        }
        validTypeNameRspBo.setUnique(Boolean.valueOf(true));
        return BaseRspUtils.createSuccessRsp((Object)validTypeNameRspBo);
    }

    public RspList queryCommSentenceTreeData(QueryCommSentenceTreeReqBO req) {
        List commSentenceTypePoList;
        log.info("\u67e5\u8be2\u5e38\u7528\u8bed\u6811\u5f62\u5217\u8868 \uff1a{}", (Object)JSON.toJSONString((Object)req));
        CsCommonWordsClassifyPo po = new CsCommonWordsClassifyPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        if (SentenceEnum.TYPE_GROUP_PRIVATE.getShortCode().equals(req.getTypeGroup())) {
            po.setCustCode(req.getUserId());
        }
        if (CollectionUtils.isEmpty((Collection)(commSentenceTypePoList = this.csCommonWordsClassifyMapper.selectByPo(po)))) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        ArrayList<CommSentenceTypeBO> rows = new ArrayList<CommSentenceTypeBO>();
        for (CsCommonWordsClassifyPo res : commSentenceTypePoList) {
            if (!res.getParentId().equals(0L)) continue;
            CommSentenceTypeBO row = new CommSentenceTypeBO();
            BeanUtils.copyProperties((Object)res, (Object)row);
            row.setLevel(Integer.valueOf(1));
            this.handleChildrenCommSentence(commSentenceTypePoList, row);
            rows.add(row);
        }
        return BaseRspUtils.createSuccessRspList(rows, (long)rows.size());
    }

    private void handleChildrenCommSentence(List<CsCommonWordsClassifyPo> list, CommSentenceTypeBO currRow) {
        ArrayList<CommSentenceTypeBO> childList = new ArrayList<CommSentenceTypeBO>();
        for (CsCommonWordsClassifyPo var : list) {
            if (!var.getParentId().equals(currRow.getTypeId())) continue;
            CommSentenceTypeBO row = new CommSentenceTypeBO();
            BeanUtils.copyProperties((Object)var, (Object)row);
            row.setLevel(Integer.valueOf(currRow.getLevel() + 1));
            childList.add(row);
            this.handleChildrenCommSentence(list, row);
        }
        currRow.setChildrenCommSentenceTypeList(childList);
    }
}

