/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.sentence.impl.api;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.csm.api.bo.sentence.CommSentence;
import com.tydic.nicc.csm.api.bo.sentence.DelCommSentenceReqBO;
import com.tydic.nicc.csm.api.bo.sentence.QueryCommSentencePageListReqBO;
import com.tydic.nicc.csm.api.bo.sentence.SaveCommSentenceReq;
import com.tydic.nicc.csm.api.bo.sentence.UpdateCommSentenceReq;
import com.tydic.nicc.csm.api.sentence.CommSentenceApi;
import com.tydic.nicc.csm.api.sentence.CommSentenceService;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.user.api.UserOptionService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=8000)
public class CommSentenceApiImpl
implements CommSentenceApi {
    private static final Logger log = LoggerFactory.getLogger(CommSentenceApiImpl.class);
    @Autowired
    private CommSentenceService commSentenceService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;

    @MethodParamVerifyEnable
    public Rsp saveCommSentence(SaveCommSentenceReq req) {
        Rsp userAuthInfo = this.userOptionService.getUserAuthInfo(req.getTenantCode(), req.getUserId());
        if (!userAuthInfo.isSuccess()) {
            log.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)userAuthInfo));
            return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        new CommSentence();
        CommSentence entity = CommSentence.builder().tenantCode(req.getTenantCode()).typeId(this.parseLong(req.getTypeId())).content(req.getContent()).sortId(this.parseInt(req.getSortId())).createUserId(req.getUserId()).createUserName(((UserAuthInfo)userAuthInfo.getData()).getUserName()).contentType(req.getContentType()).build();
        return this.commSentenceService.saveCommSentence(entity);
    }

    @MethodParamVerifyEnable
    public Rsp updateCommSentence(UpdateCommSentenceReq req) {
        Rsp userAuthInfo = this.userOptionService.getUserAuthInfo(req.getTenantCode(), req.getUserId());
        if (!userAuthInfo.isSuccess()) {
            return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        new CommSentence();
        CommSentence entity = CommSentence.builder().tenantCode(req.getTenantCode()).sentenceId(this.parseLong(req.getSentenceId())).content(req.getContent()).sortId(this.parseInt(req.getSortId())).createUserId(req.getUserId()).createUserName(((UserAuthInfo)userAuthInfo.getData()).getUserName()).contentType(req.getContentType()).build();
        return this.commSentenceService.updateCommSentence(entity);
    }

    @MethodParamVerifyEnable
    public RspList deleteCommSentence(DelCommSentenceReqBO req) {
        log.info("\u5e38\u7528\u8bed\u5220\u9664\uff1a{}", (Object)req);
        ArrayList<CallSite> errorList = new ArrayList<CallSite>();
        for (String id : req.getSentenceIdList()) {
            new CommSentence();
            CommSentence entity = CommSentence.builder().sentenceId(this.parseLong(id)).build();
            Rsp rsp = this.commSentenceService.deleteCommSentence(entity);
            errorList.add((CallSite)((Object)("\u5e38\u7528\u8bedid:" + id + "\u5220\u9664" + (rsp.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"))));
        }
        return BaseRspUtils.createSuccessRspList(errorList);
    }

    @MethodParamVerifyEnable
    public RspList getCommSentencePageList(QueryCommSentencePageListReqBO req) {
        return this.commSentenceService.getCommSentencePageList(req);
    }

    private Short parseShort(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) ? Short.valueOf(Short.parseShort(value)) : null;
    }

    private Integer parseInt(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    private Long parseLong(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) ? Long.valueOf(Long.parseLong(value)) : null;
    }
}

