/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.service.sentence.impl.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.tydic.nicc.common.bo.file.FileManageSaveBO;
import com.tydic.nicc.csm.api.bo.sentence.CommSentence;
import com.tydic.nicc.csm.api.bo.sentence.sentenceEnum.SentenceEnum;
import com.tydic.nicc.csm.api.bo.sentence.xlsx.ExportCommSentReqBo;
import com.tydic.nicc.csm.api.bo.sentence.xlsx.ImportCommSentReqBO;
import com.tydic.nicc.csm.api.sentence.CommSentenceBatchApi;
import com.tydic.nicc.csm.api.sentence.CommSentenceService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CommSentenceMapper;
import com.tydic.nicc.csm.mapper.CsCommonWordsClassifyMapper;
import com.tydic.nicc.csm.mapper.po.CommSentExcelBo;
import com.tydic.nicc.csm.mapper.po.CsCommonWordsClassifyPo;
import com.tydic.nicc.csm.mapper.po.CsCommonWordsContentPo;
import com.tydic.nicc.csm.utils.excel.ImportCommErrorRsp;
import com.tydic.nicc.csm.utils.excel.ImportCommentSentError;
import com.tydic.nicc.csm.utils.excel.ImportSentenceDTO;
import com.tydic.nicc.csm.utils.excel.listener.ImportCommSentListener;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.FileManagerHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.admin.api.FileManageService;
import com.tydic.nicc.im.bo.FileUploadReqBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CommSentenceBatchApiImpl
implements CommSentenceBatchApi {
    private static final Logger log = LoggerFactory.getLogger(CommSentenceBatchApiImpl.class);
    @Autowired
    private CommSentenceService commSentenceService;
    @Resource
    FileManagerHelper fileManagerHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    FileManageService fileManageService;
    @Resource
    private CsCommonWordsClassifyMapper csCommonWordsClassifyMapper;
    @Resource
    private CommSentenceMapper commSentenceMapper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;

    @MethodParamVerifyEnable
    public RspList exportCommSentList(ExportCommSentReqBo req) {
        List csCommonWordsClassifyPoList;
        List exportList;
        CsCommonWordsContentPo po = new CsCommonWordsContentPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        if (!SentenceEnum.TYPE_GROUP_PUBLIC.getCode().equals(req.getTypeGroup())) {
            po.setCsCode(req.getUserId());
        }
        if (!CollectionUtils.isEmpty((Collection)po.getSentenceIdList()) && !CollectionUtils.isEmpty((Collection)po.getTypeIdList())) {
            po.getTypeIdList().clear();
        }
        if (CollectionUtils.isEmpty((Collection)(exportList = this.commSentenceMapper.getExportList(po)))) {
            return BaseRspUtils.createSuccessRspList(null, (long)0L);
        }
        for (int i = 0; i < exportList.size(); ++i) {
            if (SentenceEnum.TYPE_GROUP_PUBLIC.getCode().equals(((CommSentExcelBo)exportList.get(i)).getTypeGroup())) {
                ((CommSentExcelBo)exportList.get(i)).setTypeGroup(SentenceEnum.TYPE_GROUP_PUBLIC.getName());
            }
            if (!SentenceEnum.TYPE_GROUP_PRIVATE.getCode().equals(((CommSentExcelBo)exportList.get(i)).getTypeGroup())) continue;
            ((CommSentExcelBo)exportList.get(i)).setTypeGroup(SentenceEnum.TYPE_GROUP_PRIVATE.getName());
        }
        List parentIdList = exportList.stream().map(CommSentExcelBo::getParentTypeId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(parentIdList) && !CollectionUtils.isEmpty((Collection)(csCommonWordsClassifyPoList = this.csCommonWordsClassifyMapper.queryCommSentenceTypeByIds(req.getTenantCode(), parentIdList)))) {
            Map<Long, String> parentNameMap = csCommonWordsClassifyPoList.stream().collect(Collectors.toMap(CsCommonWordsClassifyPo::getTypeId, CsCommonWordsClassifyPo::getTypeName));
            Iterator iterator = exportList.iterator();
            while (iterator.hasNext()) {
                CommSentExcelBo commSentExcelBo;
                commSentExcelBo.setTypeName((String)(StringUtils.isEmpty((CharSequence)parentNameMap.get((commSentExcelBo = (CommSentExcelBo)iterator.next()).getParentTypeId())) ? commSentExcelBo.getTypeName() : parentNameMap.get(commSentExcelBo.getParentTypeId()) + "->" + commSentExcelBo.getTypeName()));
            }
        }
        log.info("\u8fd4\u56de\u7ed3\u679c\u4e3a={}", (Object)JSON.toJSONString((Object)exportList));
        return this.createUploadExcel(exportList, CommSentExcelBo.class);
    }

    private RspList createUploadExcel(List<?> exportBOList, Class clazz) {
        try {
            String fileName = "\u5e38\u7528\u8bed\u5217\u8868" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xlsx";
            String tempPath = System.getProperty("java.io.tmpdir");
            File dirFile = new File(tempPath + "/" + fileName);
            EasyExcel.write((File)dirFile, (Class)clazz).sheet("\u5e38\u7528\u8bed\u5bfc\u51fa").doWrite(exportBOList);
            MockMultipartFile multipartFile = new MockMultipartFile(fileName, dirFile.getAbsolutePath(), null, (InputStream)new FileInputStream(dirFile));
            MultipartFile[] files = new MultipartFile[]{multipartFile};
            String month = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMM");
            List fileManageSaveBOS = this.fileManagerHelper.saveFiles(files, month);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fileManageSaveBOS));
            if (CollectionUtils.isEmpty((Collection)fileManageSaveBOS)) {
                return BaseRspUtils.createErrorRspList((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            }
            FileUploadReqBO fileUploadReqBO = new FileUploadReqBO();
            fileUploadReqBO.setServerIp(NiccCommonUtil.getIpAddress());
            fileUploadReqBO.setSaveResults(fileManageSaveBOS);
            this.fileManageService.fileUpload(fileUploadReqBO);
            return BaseRspUtils.createSuccessRspList((List)fileManageSaveBOS);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u521b\u5efa\u8868\u683c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7");
        }
    }

    @MethodParamVerifyEnable
    public RspList importCommSentList(ImportCommSentReqBO reqBO) throws Exception {
        log.info("\u5bfc\u5165\u5e38\u7528\u8bed\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)reqBO));
        String accessUrl = reqBO.getAccessUrl();
        String router = this.niccCsmConfigProperties.getDownRouter();
        String fileName = accessUrl.substring(accessUrl.indexOf(router) + router.length());
        InputStream inputStream = this.fileManagerHelper.downloadFile(fileName);
        ImportCommSentListener sentListener = new ImportCommSentListener();
        EasyExcel.read((InputStream)inputStream, ImportSentenceDTO.class, (ReadListener)sentListener).sheet().doRead();
        List<ImportSentenceDTO> record = sentListener.getRecord();
        if (CollectionUtils.isEmpty(record)) {
            return BaseRspUtils.createErrorRspList((String)"\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        Integer successNum = 0;
        ArrayList<ImportCommentSentError> errorList = new ArrayList<ImportCommentSentError>();
        for (ImportSentenceDTO data : record) {
            CsCommonWordsClassifyPo typePo;
            ImportCommentSentError errorRecord = new ImportCommentSentError();
            errorRecord.setCommSortId(data.getCommSortId());
            errorRecord.setContent(data.getContent());
            errorRecord.setTypeId(data.getTypeId());
            if (this.ruleCheck(data, errorRecord, errorList)) continue;
            String[] typeNameSplit = data.getTypeId().split("->");
            Long parentId = 0L;
            String typeName = data.getTypeId();
            log.info("typeNameSplit size={}", (Object)typeNameSplit.length);
            if (typeNameSplit.length > 1) {
                CsCommonWordsClassifyPo po = this.getTypeId(reqBO.getTenantCode(), typeNameSplit[0], 0L, reqBO.getTypeGroup());
                if (po == null) {
                    errorRecord.setErrorReason("\u6240\u5c5e\u5206\u7c7b[" + typeNameSplit[0] + "]\u4e0d\u5b58\u5728");
                    errorList.add(errorRecord);
                    continue;
                }
                parentId = po.getTypeId();
                typeName = typeNameSplit[1];
            }
            if (null == (typePo = this.getTypeId(reqBO.getTenantCode(), typeName, parentId, reqBO.getTypeGroup())) || typePo.getTypeId() == null) {
                errorRecord.setErrorReason("\u6240\u5c5e\u5206\u7c7b[" + typeName + "]\u4e0d\u5b58\u5728");
                errorList.add(errorRecord);
                continue;
            }
            data.setTypeId("" + typePo.getTypeId());
            this.saveCommSentence(reqBO, data);
            Integer n = successNum;
            Integer n2 = successNum = Integer.valueOf(successNum + 1);
        }
        int errorNum = errorList.size();
        ImportCommErrorRsp rsp = new ImportCommErrorRsp();
        rsp.setTips("\u5bfc\u5165\u603b\u6761\u6570[" + (successNum + errorNum) + "]\u6761,\u6210\u529f[" + successNum + "]\u6761");
        if (errorNum > 0) {
            RspList res = this.createUploadExcel(errorList, ImportCommentSentError.class);
            if (!res.isSuccess()) {
                return BaseRspUtils.createErrorRspList((String)"\u5bfc\u5165\u5931\u8d25,\u8bf7\u786e\u5b9a\u6240\u5c5e\u7c7b\u76ee\u662f\u5426\u5b58\u5728");
            }
            rsp.setFilePath(((FileManageSaveBO)res.getRows().get(0)).getAccessUrl());
            rsp.setTips("\u5bfc\u5165\u6210\u529f[" + successNum + "]\u6761; \u5931\u8d25[" + errorNum + "]\u6761\u3002");
        }
        return BaseRspUtils.createSuccessRspList(Arrays.asList(rsp));
    }

    public boolean ruleCheck(ImportSentenceDTO data, ImportCommentSentError errorRecord, List<ImportCommentSentError> errorList) {
        if (StringUtils.isEmpty((CharSequence)data.getContent())) {
            errorRecord.setErrorReason("\u5e38\u7528\u8bed\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            errorList.add(errorRecord);
            return true;
        }
        if (data.getContent().length() > 500) {
            errorRecord.setErrorReason("\u5e38\u7528\u8bed\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7500\u5b57\u7b26");
            errorList.add(errorRecord);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)data.getTypeId())) {
            errorRecord.setErrorReason("\u5e38\u7528\u8bed\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            errorList.add(errorRecord);
            return true;
        }
        try {
            if (StringUtils.isEmpty((CharSequence)data.getCommSortId())) {
                errorRecord.setErrorReason("\u6392\u5e8f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                errorList.add(errorRecord);
                return true;
            }
            Integer num = Integer.valueOf(data.getCommSortId());
            if (num <= 0 || num > 10000) {
                errorRecord.setErrorReason("\u6392\u5e8f\u6807\u8bc6\u8d85\u51fa[1-10000]\u53d6\u503c\u8303\u56f4");
                errorList.add(errorRecord);
                return true;
            }
        }
        catch (Exception e) {
            errorRecord.setErrorReason("\u6392\u5e8f\u6807\u8bc6\u5fc5\u987b\u4e3a\u963f\u62c9\u4f2f\u6570\u5b57");
            errorList.add(errorRecord);
            return true;
        }
        return false;
    }

    public CsCommonWordsClassifyPo getTypeId(String tenantCode, String typeName, Long parentId, Short typeGroup) {
        CsCommonWordsClassifyPo commSentenceTypePo = new CsCommonWordsClassifyPo();
        commSentenceTypePo.setTenantCode(tenantCode);
        commSentenceTypePo.setParentId(parentId);
        commSentenceTypePo.setTypeName(typeName);
        commSentenceTypePo.setTypeGroup(typeGroup);
        log.info("getTypeId--->{}", (Object)JSON.toJSONString((Object)commSentenceTypePo));
        return this.csCommonWordsClassifyMapper.selectTypePo(commSentenceTypePo);
    }

    public void saveCommSentence(ImportCommSentReqBO reqBO, ImportSentenceDTO data) {
        CommSentence sentence = new CommSentence();
        Integer commSortId = data.getCommSortId() == null ? null : Integer.valueOf(data.getCommSortId());
        sentence.setSortId(commSortId);
        sentence.setContent(data.getContent());
        sentence.setTenantCode(reqBO.getTenantCode());
        sentence.setTypeId(Long.valueOf(data.getTypeId()));
        sentence.setCreateUserId(reqBO.getUserId());
        this.commSentenceService.saveCommSentence(sentence);
    }
}

