/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.strategy;

import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.eums.csm.CsRouteExceptionDefine;
import com.tydic.nicc.csm.api.listener.CsAllotExceptionListener;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CsAllotExceptionStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(CsAllotExceptionStrategyFactory.class);
    @Autowired(required=false)
    private List<CsAllotExceptionListener> csAllotExceptionListeners;
    private static Map<String, CsAllotExceptionListener> csAllotRouteServiceMap;

    @PostConstruct
    public void init() {
        if (this.csAllotExceptionListeners != null) {
            log.info("\u52a0\u8f7d\u5ba2\u670d\u5206\u914d\u9519\u8bef\u76d1\u542c\u5668:{}", this.csAllotExceptionListeners);
            csAllotRouteServiceMap = this.csAllotExceptionListeners.stream().collect(Collectors.toMap(CsAllotExceptionListener::errCode, a -> a));
        }
    }

    public void handleAllotErrorListener(CsmCsAllotReqContext allotContext, CsRouteExceptionDefine exceptionDefine) {
        if (exceptionDefine != null) {
            csAllotRouteServiceMap.get("default").onAllotError(allotContext, exceptionDefine);
            if (ObjectUtils.anyNotNull((Object[])new Object[]{csAllotRouteServiceMap.get(exceptionDefine.getCode())})) {
                csAllotRouteServiceMap.get(exceptionDefine.getCode()).onAllotError(allotContext, exceptionDefine);
            }
        }
    }
}

