/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.strategy;

import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.eums.csm.CsOnlineStatus;
import com.tydic.nicc.common.eums.csm.CsRouteExceptionDefine;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoQueryReqBO;
import com.tydic.nicc.csm.api.router.CsAllotRouteService;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.exception.CsRouteException;
import com.tydic.nicc.csm.router.handler.FrequentAllotRuleHandler;
import com.tydic.nicc.csm.utils.AutoReplyNoticeHelper;
import com.tydic.nicc.framework.utils.AmountUtil;
import com.tydic.nicc.im.core.api.ImMessageService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CsRouteAllotStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(CsRouteAllotStrategyFactory.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private FrequentAllotRuleHandler frequentAllotRuleHandler;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private AutoReplyNoticeHelper autoReplyNoticeHelper;
    @Autowired(required=false)
    private List<CsAllotRouteService> csAllotRouteServices;
    private static Map<String, CsAllotRouteService> csAllotRouteServiceMap;

    @PostConstruct
    public void init() {
        if (this.csAllotRouteServices == null) {
            log.info("\u52a0\u8f7d\u5ba2\u670d\u8def\u7531\u5206\u914d\u670d\u52a1\u9519\u8bef!");
            return;
        }
        log.info("\u52a0\u8f7d\u5ba2\u670d\u8def\u7531\u5206\u914d\u670d\u52a1:{}", this.csAllotRouteServices);
        csAllotRouteServiceMap = this.csAllotRouteServices.stream().collect(Collectors.toMap(CsAllotRouteService::strategy, a -> a));
    }

    public RouteAllotRsp handleCsRouteByStrategy(RouteAllotReq routeAllot, List<CsInfoBO> csInfos) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{csAllotRouteServiceMap.get(routeAllot.getAllotStrategy())})) {
            return csAllotRouteServiceMap.get(routeAllot.getAllotStrategy()).handleCsAllotRoute(routeAllot, csInfos);
        }
        log.error("\u5ba2\u670d\u8def\u7531\u5206\u914d\u9519\u8bef:\u7b56\u7565\u670d\u52a1\u672a\u5b9e\u73b0 routeAllot = {}", (Object)routeAllot);
        throw new CsRouteException(CsRouteExceptionDefine.STRATEGY_NOT_FOUND);
    }

    public RouteAllotRsp handleCsRouteAllot(RouteAllotReq routeAllot) throws CsRouteException {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{this.csAllotRouteServices})) {
            RouteAllotRsp allotRsp;
            CsInfoQueryReqBO csInfoReqBO = new CsInfoQueryReqBO();
            csInfoReqBO.setTenantCode(routeAllot.getTenantCode());
            csInfoReqBO.setSkillGid(routeAllot.getAllotSkillGid());
            csInfoReqBO.setLiveOnlineStatus(CsOnlineStatus.CS_SIGN_IN.getCode());
            List<Object> csInfos = this.csmCommonService.getCsListBySkillId(csInfoReqBO);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u67e5\u8be2\u5230\u6280\u80fd\u7ec4\u4e0b\u53ef\u5206\u914d\u5ba2\u670d:{}->{}", (Object)routeAllot.getAllotSkillGid(), csInfos);
            if (csInfos.isEmpty()) {
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u63a8\u9001\u975e\u5de5\u4f5c\u65f6\u95f4\u63d0\u9192\u6d88\u606f(\u65e0\u5ba2\u670d\u5728\u7ebf):{}", (Object)routeAllot.getAllotSkillGid());
                this.autoReplyNoticeHelper.pushSysNoWorkingNotice(routeAllot.getTenantCode(), routeAllot.getAllotSkillGid(), routeAllot.getUserId(), true);
                RouteAllotRsp allotRsp2 = RouteAllotRsp.builder().match(false).allotDeny(true).build();
                BeanUtils.copyProperties((Object)routeAllot, (Object)allotRsp2);
                return allotRsp2;
            }
            csInfos = csInfos.stream().filter(cs -> cs.getReceiveLimit() > 0).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((CharSequence)routeAllot.getTransferFromCsId())) {
                csInfos = csInfos.stream().filter(cs -> !cs.getCsId().equals(routeAllot.getTransferFromCsId())).collect(Collectors.toList());
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u67e5\u8be2\u5230\u6280\u80fd\u7ec4\u4e0b\u53ef\u5206\u914d\u5ba2\u670d,\u6392\u9664\u81ea\u5df1:{}:{}->{}", new Object[]{routeAllot.getTransferFromCsId(), routeAllot.getAllotSkillGid(), csInfos});
            } else {
                csInfos = csInfos.stream().filter(cs -> {
                    int receiveCount = this.csmCommonService.receivingCount(routeAllot.getTenantCode(), cs.getCsId());
                    cs.setReceivedCount(receiveCount);
                    cs.setSaturationRate(AmountUtil.div((double)receiveCount, (double)cs.getReceiveLimit().intValue()));
                    return receiveCount != -1 && receiveCount < cs.getReceiveLimit();
                }).collect(Collectors.toList());
            }
            if (routeAllot.isFrequentRule() && (allotRsp = this.frequentAllotRuleHandler.allotByFrequent(routeAllot, csInfos)).isMatch()) {
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u6210\u529f[\u719f\u5ba2]:{}", (Object)allotRsp);
                return allotRsp;
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAllot.getAllotStrategy())) {
                allotRsp = this.handleCsRouteByStrategy(routeAllot, csInfos);
            } else {
                for (CsAllotRouteService csAllotRouteService : this.csAllotRouteServices) {
                    allotRsp = csAllotRouteService.handleCsAllotRoute(routeAllot, csInfos);
                    if (!allotRsp.isMatch()) continue;
                    log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u6210\u529f[{}]:{}", (Object)csAllotRouteService.strategy(), (Object)allotRsp);
                    return allotRsp;
                }
                allotRsp = RouteAllotRsp.builder().match(false).build();
                BeanUtils.copyProperties((Object)routeAllot, (Object)allotRsp);
            }
            return allotRsp;
        }
        log.error("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u9519\u8bef:\u5ba2\u670d\u8def\u7531\u670d\u52a1\u672a\u5b9e\u73b0!");
        throw new CsRouteException(CsRouteExceptionDefine.CS_ROUTERS_NOT_FOUND);
    }

    public RouteAllotRsp allotToCs(RouteAllotReq routeAllot) {
        log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u76f4\u63a5\u5206\u914d\u5ba2\u670d-\u5f00\u59cb:{}", (Object)routeAllot);
        AllotCsInfo csInfo = new AllotCsInfo();
        CsInfoBO csInfoBO = this.csmCommonService.getCsInfo(routeAllot.getAllotCsId());
        boolean match = false;
        if (csInfoBO != null) {
            BeanUtils.copyProperties((Object)csInfoBO, (Object)csInfo);
            if (routeAllot.isFetchQueue()) {
                int receivingCount = this.csmCommonService.receivingCount(routeAllot.getTenantCode(), routeAllot.getAllotCsId());
                if (receivingCount < csInfoBO.getReceiveLimit()) {
                    match = true;
                }
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u76f4\u63a5\u5206\u914d\u5ba2\u670d-\u63a5\u5f85\u4e0a\u9650\u5df2\u6ee1: {}/{}", (Object)receivingCount, (Object)csInfoBO.getReceiveLimit());
            } else {
                match = true;
            }
        }
        return RouteAllotRsp.builder().allotCsInfo(csInfo).allotUserType(UserTypeField.COMP_USER.getCode()).match(match).build();
    }
}

