/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.strategy;

import com.tydic.nicc.common.bo.csm.RouteAllotReq;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.csm.api.router.RobotAllotRouteService;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RobotRouteAllotStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(RobotRouteAllotStrategyFactory.class);
    @Autowired(required=false)
    private List<RobotAllotRouteService> robotAllotRouteServices;
    private static Map<String, RobotAllotRouteService> csAllotRouteServiceMap;

    @PostConstruct
    public void init() {
        if (this.robotAllotRouteServices == null) {
            log.error("\u673a\u5668\u4eba\u5206\u914d\u8def\u7531\u670d\u52a1\u52a0\u8f7d\u5931\u8d25!");
            return;
        }
        log.info("\u52a0\u8f7d\u673a\u5668\u4eba\u5206\u914d\u8def\u7531\u670d\u52a1:{}", this.robotAllotRouteServices);
        csAllotRouteServiceMap = this.robotAllotRouteServices.stream().collect(Collectors.toMap(RobotAllotRouteService::strategy, a -> a));
    }

    public RouteAllotRsp handleRobotRouteAllot(RouteAllotReq routeAllot) throws DcBusinessException {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{this.robotAllotRouteServices})) {
            for (RobotAllotRouteService robotAllotRouteService : this.robotAllotRouteServices) {
                RouteAllotRsp allotRsp = robotAllotRouteService.handleRobotAllotRoute(routeAllot);
                if (!allotRsp.isMatch()) continue;
                return allotRsp;
            }
        }
        return RouteAllotRsp.builder().match(false).build();
    }
}

