/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.strategy;

import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.bo.csm.SkillGroupRouteReq;
import com.tydic.nicc.common.bo.csm.SkillGroupRouteRsp;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.eums.csm.CsRouteExceptionDefine;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.api.router.SkillGroupRouteService;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.exception.CsRouteException;
import com.tydic.nicc.csm.router.skill.DefaultSkillGroupRouter;
import com.tydic.nicc.csm.router.skill.SkillGroupCommonRouterHandler;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SkillGroupStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(SkillGroupStrategyFactory.class);
    @Autowired(required=false)
    private List<SkillGroupRouteService> skillGroupRouteServices;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private SkillGroupCommonRouterHandler skillGroupCommonRouterHandler;

    @PostConstruct
    public void init() {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{this.skillGroupRouteServices})) {
            this.skillGroupRouteServices = this.skillGroupRouteServices.stream().filter(obj -> {
                if ("*".equals(this.niccCsmConfigProperties.getCsSkillRoutePkg())) {
                    return true;
                }
                return obj.getClass().getName().contains(this.niccCsmConfigProperties.getCsSkillRoutePkg()) && !obj.getClass().getName().equals(DefaultSkillGroupRouter.class.getName());
            }).sorted(Comparator.comparing(listener -> listener.order())).collect(Collectors.toList());
            for (SkillGroupRouteService skillGroupRouteService : this.skillGroupRouteServices) {
                log.info("\u52a0\u8f7d\u6280\u80fd\u7ec4\u8def\u7531\u5206\u914d\u76d1\u542c\u5668\uff1a\u6307\u5b9a\u5305 = {}, \u76d1\u542c\u5668\u7c7b = {}", (Object)this.niccCsmConfigProperties.getCsSkillRoutePkg(), (Object)skillGroupRouteService.getClass().getName());
            }
        }
    }

    public RouteAllotRsp processSkillGroupRoute(CsmCsAllotReqContext csmCsAllotContext) throws CsRouteException {
        RouteAllotRsp allotRsp = null;
        if (StringUtils.isNotEmpty((CharSequence)csmCsAllotContext.getAllotSkillGid())) {
            CsSkillGroupBO skillGroupBO = this.csmCommonService.getSkillGroupInfo(csmCsAllotContext.getAllotSkillGid());
            if (ObjectUtils.anyNotNull((Object[])new Object[]{skillGroupBO})) {
                String strategy = skillGroupBO.getAllotStrategy();
                allotRsp = RouteAllotRsp.builder().match(true).allotSkillType(skillGroupBO.getSkillGroupType()).allotSkillGid(skillGroupBO.getSkillGid()).isFrequentRule(this.skillGroupCommonRouterHandler.isFrequentRule(strategy)).allotStrategy(this.skillGroupCommonRouterHandler.parseStrategy(strategy)).build();
                log.info("\u5904\u7406\u6280\u80fd\u7ec4\u8def\u7531-\u6307\u5b9a\u6280\u80fd\u7ec4\u5206\u914d:{}", (Object)allotRsp);
                return allotRsp;
            }
        }
        if (this.skillGroupRouteServices != null) {
            for (SkillGroupRouteService skillGroupRouteService : this.skillGroupRouteServices) {
                SkillGroupRouteReq skillGroupRoute = new SkillGroupRouteReq();
                BeanUtils.copyProperties((Object)csmCsAllotContext, (Object)skillGroupRoute);
                SkillGroupRouteRsp routeRsp = skillGroupRouteService.handleSkillGroupRoute(skillGroupRoute);
                if (routeRsp.isMatch()) {
                    String strategy = routeRsp.getAllotStrategy();
                    allotRsp = RouteAllotRsp.builder().match(true).allotSkillType(routeRsp.getSkillType()).allotSkillGid(routeRsp.getSkillGid()).isFrequentRule(this.skillGroupCommonRouterHandler.isFrequentRule(strategy)).allotStrategy(this.skillGroupCommonRouterHandler.parseStrategy(strategy)).build();
                    log.info("\u5904\u7406\u6280\u80fd\u7ec4\u8def\u7531-\u7b56\u7565\u5339\u914d\u6280\u80fd\u7ec4:{}", (Object)allotRsp);
                    return allotRsp;
                }
                if (!routeRsp.isAllotDeny()) continue;
                return RouteAllotRsp.builder().match(false).allotDeny(true).build();
            }
        }
        throw new CsRouteException(CsRouteExceptionDefine.ROUTE_ERROR);
    }
}

