/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.task;

import com.tydic.nicc.common.api.ChatSessionService;
import com.tydic.nicc.common.bo.session.CloseSessionReqBO;
import com.tydic.nicc.common.eums.csm.CsOnlineStatus;
import com.tydic.nicc.common.eums.session.SessionCloseType;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsOfflineQueueContext;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.utils.CsOfflineQueueManagerUtil;
import com.tydic.nicc.dc.base.bo.Rsp;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class CsOfflineTimoutCheckTimer {
    private static final Logger log = LoggerFactory.getLogger(CsOfflineTimoutCheckTimer.class);
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private CsmCommonService csmCommonService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ChatSessionService chatSessionService;

    @Scheduled(fixedRate=5000L)
    public void doTaskTimer() {
        int timout = this.niccCsmConfigProperties.getCsOfflineTimout();
        if (timout > 0) {
            long start = System.currentTimeMillis();
            log.info("\u5ba2\u670d\u79bb\u7ebf\u8d85\u65f6\u68c0\u6d4b-\u5f00\u59cb: timout = {}, queue = {}", (Object)timout, CsOfflineQueueManagerUtil.list());
            boolean hasNext = true;
            while (hasNext && !CsOfflineQueueManagerUtil.isEmpty()) {
                hasNext = this.handleOfflineTimoutCheck(timout * 1000);
            }
            long end = System.currentTimeMillis();
            log.info("\u5ba2\u670d\u79bb\u7ebf\u8d85\u65f6\u68c0\u6d4b-\u5b8c\u6210: {} ms", (Object)(end - start));
        }
    }

    private boolean handleOfflineTimoutCheck(int timout) {
        CsInfoBO csInfo;
        long nowTime = System.currentTimeMillis();
        CsOfflineQueueContext context = CsOfflineQueueManagerUtil.peek();
        log.info("\u5ba2\u670d\u79bb\u7ebf\u8d85\u65f6\u68c0\u6d4b-context:{}", (Object)context);
        long check = nowTime - context.getOfflineTime().getTime();
        if (check >= (long)timout && CsOnlineStatus.CS_OFFLINE.matchCode((csInfo = this.csmCommonService.getCsInfo(context.getCsId())).getLiveOnlineStatus())) {
            List<String> sessions = this.csmCommonService.receivingSessions(context.getTenantCode(), context.getCsId());
            for (String session : sessions) {
                CloseSessionReqBO closeSession = new CloseSessionReqBO();
                closeSession.setTenantCode(context.getTenantCode());
                closeSession.setOperUser(context.getCsId());
                closeSession.setSessionId(session);
                closeSession.setCloseType(SessionCloseType.CS_OFFLINE_LEAVE_CLOSE.getCode());
                Rsp rsp = this.chatSessionService.sessionClose(closeSession);
                log.info("\u5ba2\u670d\u79bb\u7ebf\u8d85\u65f6\u68c0\u6d4b-\u4f1a\u8bdd\u5173\u95ed:closeSession = {},rsp = {},context = {}", new Object[]{session, rsp, context});
            }
            CsOfflineQueueManagerUtil.remove(context);
            return true;
        }
        return false;
    }
}

