/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.task;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.im.ImOnlineStatus;
import com.tydic.nicc.csm.api.CsInfoApi;
import com.tydic.nicc.csm.api.bo.cs.CsInfoUpdateReqBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.po.CsInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class CsOnlineSyncTimer {
    private static final Logger log = LoggerFactory.getLogger(CsOnlineSyncTimer.class);
    private static final String CSM_CS_ONLINE_SYNC_LOCK_KEY = "CSM_CS_ONLINE_SYNC_LOCK";
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsInfoApi csInfoApi;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=10000L)
    public void doTaskTimer() {
        RedisLockEntity redisLockEntity;
        boolean locked;
        if (this.niccCsmConfigProperties.getCsOnlineSyncEnable().booleanValue() && (locked = this.redisHelper.lock(redisLockEntity = RedisLockEntity.builder().lockKey(CSM_CS_ONLINE_SYNC_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build()))) {
            try {
                long startTime = System.currentTimeMillis();
                log.info("\u5ba2\u670d\u72b6\u6001\u68c0\u6d4b\u4efb\u52a1,\u5f00\u59cb\u6267\u884c:{}", (Object)redisLockEntity);
                List<CsInfo> csOnlineList = this.csmCommonService.getOnlineCsList();
                for (CsInfo csInfo : csOnlineList) {
                    String status = (String)this.redisHelper.get(RedisCacheKeyConstant.getUserStatusKey((String)"", (String)csInfo.getCsId()));
                    if (ImOnlineStatus.ONLINE.getCode().equals(status)) continue;
                    String cs = JSONObject.toJSONString((Object)csInfo);
                    log.info("\u5ba2\u670d\u72b6\u6001\u68c0\u6d4b\u4efb\u52a1,\u72b6\u6001\u5f02\u5e38:{}", (Object)cs);
                    CsInfoUpdateReqBO csInfoUpdateReqBO = new CsInfoUpdateReqBO();
                    csInfoUpdateReqBO.setTenantCode(csInfo.getTenantCode());
                    csInfoUpdateReqBO.setCsId(csInfo.getCsId());
                    Rsp rsp = this.csInfoApi.updateCsOffline(csInfoUpdateReqBO);
                    log.info("\u5ba2\u670d\u72b6\u6001\u68c0\u6d4b\u4efb\u52a1,\u72b6\u6001\u5f02\u5e38-\u66f4\u65b0\u72b6\u6001:{}|{}", (Object)cs, (Object)rsp);
                }
                long endTime = System.currentTimeMillis();
                log.info("\u5ba2\u670d\u72b6\u6001\u68c0\u6d4b\u4efb\u52a1,\u6267\u884c\u5b8c\u6210:{} ms", (Object)(endTime - startTime));
            }
            catch (Exception e) {
                log.error("\u5ba2\u670d\u72b6\u6001\u68c0\u6d4b\u4efb\u52a1,\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }
}

