/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.task;

import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class CsmItemCountTimer {
    private static final Logger log = LoggerFactory.getLogger(CsmItemCountTimer.class);
    private static final String CSM_ITEM_COUNT_LOCK_KEY = "CSM_ITEM_COUNT_LOCK";
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private CsmItemCountService csmItemCountService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0 2 * * ?")
    public void doTaskTimer() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(CSM_ITEM_COUNT_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            try {
                log.info("\u5ba2\u670d\u6307\u6807\u7edf\u8ba1\u4efb\u52a1,\u5f00\u59cb\u6267\u884c:{}", (Object)redisLockEntity);
                long startTime = System.currentTimeMillis();
                this.csmItemCountService.countAllSkillReceivedTotal();
                this.csmItemCountService.countAllCsAllotItems(null, null, true);
                long endTime = System.currentTimeMillis();
                log.info("\u5ba2\u670d\u6307\u6807\u7edf\u8ba1\u4efb\u52a1,\u6267\u884c\u5b8c\u6210:{} ms", (Object)(endTime - startTime));
            }
            catch (Exception e) {
                log.error("\u5ba2\u670d\u6307\u6807\u7edf\u8ba1\u4efb\u52a1,\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }
}

