/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.utils;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.csm.AllotCsInfo;
import com.tydic.nicc.common.bo.csm.RouteAllotRsp;
import com.tydic.nicc.common.bo.csm.SkillGroupRouteReq;
import com.tydic.nicc.common.bo.im.core.ImUpdateMessageReqBO;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.common.bo.rocketmq.SessionIdleCheckContext;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.constants.ImCoreConstants;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.csm.AutoReplyType;
import com.tydic.nicc.common.eums.csm.CsAllotJoinType;
import com.tydic.nicc.common.eums.im.ImMsgType;
import com.tydic.nicc.common.eums.im.MsgChatType;
import com.tydic.nicc.common.eums.im.MsgFormType;
import com.tydic.nicc.common.eums.im.SysMsgCode;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.common.msg.ImMessageBody;
import com.tydic.nicc.common.msg.ImSysMessageBody;
import com.tydic.nicc.common.msg.ImUserMessageBody;
import com.tydic.nicc.common.msg.system.SysChooseSkillNotice;
import com.tydic.nicc.common.msg.system.SysCsmAllotNotice;
import com.tydic.nicc.common.msg.system.SysMsgContent;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.cs.CsConfigMatcher;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.framework.utils.ImMessageBuilder;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.core.api.ImMessageService;
import com.tydic.nicc.user.api.UserOptionService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class AutoReplyNoticeHelper {
    private static final Logger log = LoggerFactory.getLogger(AutoReplyNoticeHelper.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private RedisHelper redisHelper;

    public void pushUserWaitingNotice(SessionIdleCheckContext context, String configType, long msgTime) {
        String key = RedisCacheKeyConstant.getCsmAutoReplyPushedKey((String)context.getSessionId(), (String)configType);
        Long lastMsgTime = (Long)this.redisHelper.get(key);
        if (lastMsgTime == null || !lastMsgTime.equals(msgTime)) {
            CsConfigMatcher csConfigMatcher = CsConfigMatcher.builder().tenantCode(context.getTenantCode()).channelCode(context.getChannelCode()).skillGid(context.getSkillGid()).build();
            List<CsAutoReplyConfigBO> replyConfigs = this.csmCommonService.getAutoReplyConfig(context.getTenantCode(), configType);
            CsAutoReplyConfigBO csAutoReplyConfig = this.csmCsAllotHelper.matchAutoReplyConfig(replyConfigs, csConfigMatcher);
            String replyContent = "";
            if (csAutoReplyConfig != null) {
                replyContent = csAutoReplyConfig.getReplyContent();
            }
            if (StringUtils.isNotBlank((CharSequence)replyContent)) {
                ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.AUTO_REPLY.getCode(), (String)MsgChatType.C2B.getCode());
                message.setTenantCode(context.getTenantCode());
                message.setFromNo(ImCoreConstants.getSystemUser((String)context.getTenantCode()));
                message.setToNo(context.getUserId());
                message.setSessionId(context.getSessionId());
                ImUserMessageBody messageBody = new ImUserMessageBody(MsgFormType.NOTICE_MSG.getCode(), replyContent);
                message.setMsgBody((ImMessageBody)messageBody);
                String chatKey = NiccCommonUtil.getC2bChatKey((String)context.getTenantCode(), (String)context.getUserId());
                log.info("\u4f1a\u8bdd\u7a7a\u95f2\u68c0\u6d4b-\u63a8\u9001\u7528\u6237\u7b49\u5f85\u63d0\u793a\u8bed:{}|{}", (Object)configType, (Object)message);
                this.imMessageService.sendMessageToUser(message, chatKey);
                this.redisHelper.set(key, (Object)msgTime, TimeUnit.HOURS.toSeconds(1L));
            }
        }
    }

    public void pushSysSkillChooseNotice(SkillGroupRouteReq skillGroupRoute, List<CsSkillGroupBO> skills) {
        CsConfigMatcher csConfigMatcher;
        String replyContent = "";
        List<CsAutoReplyConfigBO> replyConfigs = this.csmCommonService.getAutoReplyConfig(skillGroupRoute.getTenantCode(), AutoReplyType.SKILL_CHOOSE.getCode());
        CsAutoReplyConfigBO csAutoReplyConfig = this.csmCsAllotHelper.matchAutoReplyConfig(replyConfigs, csConfigMatcher = CsConfigMatcher.builder().tenantCode(skillGroupRoute.getTenantCode()).build());
        if (csAutoReplyConfig != null) {
            replyContent = csAutoReplyConfig.getReplyContent();
        }
        if (StringUtils.isBlank((CharSequence)replyContent)) {
            replyContent = AutoReplyType.checkReplyText((String)AutoReplyType.SKILL_CHOOSE.getCode(), (String)replyContent);
        }
        ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.SYSTEM.getCode());
        message.setTenantCode(skillGroupRoute.getTenantCode());
        message.setToNo(skillGroupRoute.getUserId());
        message.setFromNo(ImCoreConstants.getSystemUser((String)skillGroupRoute.getTenantCode()));
        SysMsgContent sysMsgContent = new SysMsgContent();
        SysChooseSkillNotice notice = new SysChooseSkillNotice(replyContent, JSONObject.toJSONString(skills));
        sysMsgContent.setChooseSkillNotice(notice);
        ImSysMessageBody messageBody = new ImSysMessageBody(SysMsgCode.SKILL_CHOOSE.getCode(), sysMsgContent);
        message.setMsgBody((ImMessageBody)messageBody);
        log.info("\u6280\u80fd\u7ec4\u8def\u7531-\u6839\u636e\u6e20\u9053\u5339\u914d\u6280\u80fd\u7ec4-\u63a8\u9001\u6280\u80fd\u7ec4\u9009\u62e9\u6d88\u606f:{}", (Object)message);
        this.imMessageService.sendMessageToUser(message);
    }

    public void pushSysNoWorkingNotice(String tenantCode, String skillGid, String userId, boolean noCsOnline) {
        CsConfigMatcher csConfigMatcher = CsConfigMatcher.builder().tenantCode(tenantCode).skillGid(skillGid).build();
        if (noCsOnline && this.niccCsmConfigProperties.getNoWorkingAllotPlatform().booleanValue() && !"platform".equals(tenantCode)) {
            List<CsAutoReplyConfigBO> replyConfigs = this.csmCommonService.getAutoReplyConfig(tenantCode, AutoReplyType.SYS_NO_WORKING_ALLOT_NOTICE.getCode());
            CsAutoReplyConfigBO csAutoReplyConfig = this.csmCsAllotHelper.matchAutoReplyConfig(replyConfigs, csConfigMatcher);
            String alterContent = this.niccCsmConfigProperties.getNoWorkingAllotContent();
            if (csAutoReplyConfig != null && StringUtils.isNotBlank((CharSequence)csAutoReplyConfig.getReplyContent())) {
                alterContent = csAutoReplyConfig.getReplyContent();
            }
            ImMessage message = ImMessageBuilder.buildAllotPlatformMessage((String)tenantCode, (String)userId, (String)alterContent);
            String msg = JSONObject.toJSONString((Object)message);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u63a8\u9001\u975e\u5de5\u4f5c\u65f6\u95f4\u8f6c\u63a5\u5e73\u53f0\u63d0\u9192\u6d88\u606f:{}", (Object)msg);
            this.imMessageService.sendMessageToUser(message);
        } else if (this.niccCsmConfigProperties.getNoWorkingTimeLeaveMsg().booleanValue()) {
            List<CsAutoReplyConfigBO> replyConfigs = this.csmCommonService.getAutoReplyConfig(tenantCode, AutoReplyType.SYS_NO_WORKING_NOTICE.getCode());
            CsAutoReplyConfigBO csAutoReplyConfig = this.csmCsAllotHelper.matchAutoReplyConfig(replyConfigs, csConfigMatcher);
            String alterContent = this.niccCsmConfigProperties.getNoWorkingTimeContent();
            if (csAutoReplyConfig != null && StringUtils.isNotBlank((CharSequence)csAutoReplyConfig.getReplyContent())) {
                alterContent = csAutoReplyConfig.getReplyContent();
            }
            log.debug("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u63a8\u9001\u975e\u5de5\u4f5c\u65f6\u95f4\u63d0\u9192\u6d88\u606f-\u914d\u7f6e\u4fe1\u606f:{},{},{}", new Object[]{replyConfigs, csConfigMatcher, csAutoReplyConfig});
            ImMessage message = ImMessageBuilder.buildNoWorkingTimeMessage((String)tenantCode, (String)userId, (String)alterContent);
            String msg = JSONObject.toJSONString((Object)message);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u63a8\u9001\u975e\u5de5\u4f5c\u65f6\u95f4\u63d0\u9192\u6d88\u606f:{}", (Object)msg);
            this.imMessageService.sendMessageToUser(message);
        }
    }

    public void pushSysNoWorkingNotice(String tenantCode, String skillGid, String userId) {
        this.pushSysNoWorkingNotice(tenantCode, skillGid, userId, false);
    }

    public void pushAllotedNotice(CsmCsAllotReqContext allotContext, RouteAllotRsp allotRsp, String joinSessionId) {
        List<CsAutoReplyConfigBO> replyConfigs;
        CsAutoReplyConfigBO replyConfigBO;
        CsAutoReplyConfigBO replyAllotNoticeConfig;
        ImUserMessageBody messageBody;
        AllotCsInfo csInfo = allotRsp.getAllotCsInfo();
        String csId = csInfo.getCsId();
        String nickName = csInfo.getNickName();
        String csCode = csInfo.getCsCode();
        CsConfigMatcher csConfigMatcher = new CsConfigMatcher();
        csConfigMatcher.setTenantCode(allotContext.getTenantCode());
        csConfigMatcher.setChannelCode(allotContext.getChannelCode());
        csConfigMatcher.setSkillGid(allotRsp.getAllotSkillGid());
        String chatKey = NiccCommonUtil.getC2bChatKey((String)allotContext.getTenantCode(), (String)allotContext.getUserId());
        int countAllot = this.csmCommonService.countRecentlyAllot(allotContext.getTenantCode(), csId, allotContext.getUserId(), this.niccCsmConfigProperties.getAllotLatelyMinutes());
        List<CsAutoReplyConfigBO> userInSessionReplyConfigs = countAllot == 0 ? this.csmCommonService.getAutoReplyConfig(allotContext.getTenantCode(), AutoReplyType.USER_IN_SESSION.getCode()) : this.csmCommonService.getAutoReplyConfig(allotContext.getTenantCode(), AutoReplyType.USER_IN_AGAIN_SESSION.getCode());
        CsAutoReplyConfigBO replyUserInSessionConfig = this.csmCsAllotHelper.matchAutoReplyConfig(userInSessionReplyConfigs, csConfigMatcher);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{replyUserInSessionConfig}) && ObjectUtils.allNotNull((Object[])new Object[]{replyUserInSessionConfig.getReplyContent()})) {
            String joinType = CsAllotJoinType.getNameByCode((String)allotContext.getAllotJoinType());
            Rsp userRsp = this.userOptionService.getUserAuthInfo(allotContext.getTenantCode(), allotContext.getUserId());
            String userName = "";
            if (userRsp.isSuccess() && StringUtils.isEmpty((CharSequence)(userName = ((UserAuthInfo)userRsp.getData()).getUserName()))) {
                userName = ((UserAuthInfo)userRsp.getData()).getNickName();
            }
            String replyContent = replyUserInSessionConfig.getReplyContent().replace("#userName", userName).replace("#nickName", ((UserAuthInfo)userRsp.getData()).getNickName());
            replyContent = AutoReplyNoticeHelper.parseUserAllotTemplate(replyContent, allotContext);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210-\u63a8\u9001\u63a5\u5165\u63d0\u793a:{} -> {}, content = {}", new Object[]{allotContext.getUserId(), csId, replyContent});
            if (replyContent.startsWith(",") || replyContent.startsWith("\uff0c") || replyContent.startsWith("||")) {
                replyContent = replyContent.substring(1);
            }
            ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.AUTO_REPLY.getCode(), (String)MsgChatType.C2B.getCode());
            message.setTenantCode(allotContext.getTenantCode());
            message.setFromNo(ImCoreConstants.getSystemUser((String)allotContext.getTenantCode()));
            message.setToNo(csId);
            message.setSessionId(joinSessionId);
            messageBody = new ImUserMessageBody(MsgFormType.NOTICE_MSG.getCode(), replyContent);
            message.setMsgBody((ImMessageBody)messageBody);
            this.imMessageService.sendMessageToUser(message, message.getToNo(), chatKey);
            String firstMsgId = allotContext.getFirstMsgId();
            if (StringUtils.isNotEmpty((CharSequence)firstMsgId)) {
                ImUpdateMessageReqBO updateMessageReqBO = new ImUpdateMessageReqBO();
                updateMessageReqBO.setTenantCode(allotContext.getTenantCode());
                updateMessageReqBO.setChatKey(chatKey);
                updateMessageReqBO.setMsgId(firstMsgId);
                updateMessageReqBO.setSessionId(joinSessionId);
                log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210,\u66f4\u65b0\u63a5\u5165\u9996\u6761\u6d88\u606f\u4f1a\u8bdd:{}", (Object)updateMessageReqBO);
                this.imMessageService.updateMessage(updateMessageReqBO);
            }
        }
        List<CsAutoReplyConfigBO> allotReplyConfigs = this.csmCommonService.getAutoReplyConfig(allotContext.getTenantCode(), AutoReplyType.CS_ALLOT_NOTICE.getCode());
        if (allotRsp.getAllotCsInfo() != null) {
            BeanUtils.copyProperties((Object)allotRsp.getAllotCsInfo(), (Object)csConfigMatcher);
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{replyAllotNoticeConfig = this.csmCsAllotHelper.matchAutoReplyConfig(allotReplyConfigs, csConfigMatcher)}) && ObjectUtils.allNotNull((Object[])new Object[]{replyAllotNoticeConfig.getReplyContent()})) {
            String replyContent = replyAllotNoticeConfig.getReplyContent().replace("#csId", csId).replace("#nickName", nickName).replace("#csCode", csCode);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210,\u63a8\u9001\u5ba2\u670d\u63a5\u5165\u63d0\u793a:{} -> {} - content = {}", new Object[]{allotContext.getUserId(), csId, replyContent});
            ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.SYSTEM.getCode(), (String)MsgChatType.C2B.getCode());
            message.setTenantCode(allotContext.getTenantCode());
            message.setFromNo(csId);
            message.setToNo(allotContext.getUserId());
            SysMsgContent sysMsgContent = new SysMsgContent();
            sysMsgContent.setCsmAllotNotice(SysCsmAllotNotice.builder().userId(allotContext.getUserId()).csId(csId).content(replyContent).build());
            messageBody = new ImSysMessageBody(SysMsgCode.CSM_ALLOT.getCode(), sysMsgContent);
            message.setMsgBody((ImMessageBody)messageBody);
            this.imMessageService.sendMessageToUser(message);
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{replyConfigBO = this.csmCsAllotHelper.matchAutoReplyConfig(replyConfigs = this.csmCommonService.getAutoReplyConfig(allotContext.getTenantCode(), AutoReplyType.CS_WELCOME.getCode()), csConfigMatcher)}) && StringUtils.isNotEmpty((CharSequence)replyConfigBO.getReplyContent())) {
            String replyContent = replyConfigBO.getReplyContent().replace("#csId", csId).replace("#nickName", nickName).replace("#csCode", csCode);
            log.info("\u5ba2\u670d\u8def\u7531\u5206\u914d-\u5206\u914d\u5b8c\u6210,\u63a8\u9001\u5ba2\u670d\u81ea\u5b9a\u4e49\u6b22\u8fce\u8bed:{} -> {} - content = {}", new Object[]{allotContext.getUserId(), csId, replyContent});
            if (StringUtils.isNotEmpty((CharSequence)replyContent)) {
                ImMessage message = ImMessageBuilder.buildAutoReplyMessage((String)csId, (String)allotContext.getUserId());
                message.setTenantCode(allotContext.getTenantCode());
                ImUserMessageBody messageBody2 = new ImUserMessageBody(MsgFormType.TEXT.getCode(), replyContent);
                message.setMsgBody((ImMessageBody)messageBody2);
                this.imMessageService.sendMessageToUser(message);
            }
        }
    }

    public static String parseUserAllotTemplate(String template, CsmCsAllotReqContext allotContext) {
        if (allotContext.isFetchQueue()) {
            return template.replace("#joinType", "\u6392\u961f");
        }
        if (CsAllotJoinType.ALLOT.matchCode(allotContext.getAllotJoinType())) {
            return template.replace("#joinType", "\u673a\u5668\u4eba\u8f6c\u4eba\u5de5");
        }
        if (CsAllotJoinType.TRANSFER.matchCode(allotContext.getAllotJoinType())) {
            return template.replace("#joinType", "\u8f6c\u63a5");
        }
        return template.replace("#joinType", "").replace(",", "").replace("\uff0c", "");
    }
}

