/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.exception.DataSyncException;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormDataBO;
import com.tydic.nicc.csm.api.bo.formdata.CommonFormDataQueryReqBO;
import com.tydic.nicc.csm.api.bo.formdata.FTableFormMapBO;
import com.tydic.nicc.csm.api.bo.formdata.FTableFormMapQueryReqBO;
import com.tydic.nicc.csm.busi.FCommonTableFormService;
import com.tydic.nicc.csm.busi.ServiceSyncService;
import com.tydic.nicc.csm.mapper.FCommonTableDataMapper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CommonFormDataDriverHelper {
    private static final Logger log = LoggerFactory.getLogger(CommonFormDataDriverHelper.class);
    @Resource
    private FCommonTableDataMapper fCommonTableDataMapper;
    @Resource
    private FCommonTableFormService fCommonTableFormService;
    @Resource
    private ServiceSyncService serviceSyncService;

    public RspList commonTableQuery(CommonFormDataQueryReqBO queryReqBO) {
        FTableFormMapQueryReqBO formMapQueryReqBO = new FTableFormMapQueryReqBO();
        formMapQueryReqBO.setTenantCode(queryReqBO.getTenantCode());
        formMapQueryReqBO.setFormCode(queryReqBO.getFormCode());
        List<FTableFormMapBO> formMapList = this.fCommonTableFormService.getTableFormMap(formMapQueryReqBO);
        if (!formMapList.isEmpty()) {
            Map tableMapInfo = formMapList.parallelStream().collect(Collectors.groupingBy(FTableFormMapBO::getTableName, Collectors.toList()));
            for (Map.Entry obj : tableMapInfo.entrySet()) {
                List result;
                String sql = CommonFormDataDriverHelper.selectSqlBuilder(queryReqBO.getTenantCode(), obj.getKey(), queryReqBO.getConditions(), obj.getValue());
                if (!StringUtils.isNotEmpty((CharSequence)sql) || (result = this.fCommonTableDataMapper.executeSelectSql(sql)) == null) continue;
                return BaseRspUtils.createSuccessRspList((List)result, (long)result.size());
            }
        }
        return BaseRspUtils.createSuccessRspList(new ArrayList());
    }

    @Transactional
    public void commonTableDataAnalysis(CommonFormDataBO dataBO) {
        FTableFormMapQueryReqBO queryReqBO = new FTableFormMapQueryReqBO();
        queryReqBO.setTenantCode(dataBO.getTenantCode());
        queryReqBO.setFormCode(dataBO.getFormCode());
        JSONObject formData = dataBO.getFormData();
        Map formDataMap = (Map)JSONObject.toJavaObject((JSON)formData, Map.class);
        Rsp syncRsp = this.serviceSyncService.doServiceSync(dataBO.getTenantCode(), dataBO.getFormCode(), formDataMap);
        log.info("\u6570\u636e\u540c\u6b65\u670d\u52a1\u5b8c\u6210:{}", (Object)syncRsp);
        if (syncRsp.isSuccess()) {
            List<FTableFormMapBO> formMapList = this.fCommonTableFormService.getTableFormMap(queryReqBO);
            if (formMapList.isEmpty()) {
                log.warn("\u672a\u67e5\u8be2\u5230\u901a\u7528\u8868\u5355\u6620\u5c04\u914d\u7f6e: formCode = {}", (Object)dataBO.getFormCode());
                return;
            }
            Map tableMapInfo = formMapList.parallelStream().collect(Collectors.groupingBy(FTableFormMapBO::getTableName, Collectors.toList()));
            for (Map.Entry obj : tableMapInfo.entrySet()) {
                String sql = CommonFormDataDriverHelper.insertSqlBuilder(obj.getKey(), formData, obj.getValue());
                log.info("\u6784\u9020sql-\u5b8c\u6210: tableName = {},sql = {}", (Object)obj.getKey(), (Object)sql);
                this.fCommonTableDataMapper.executeInsertSql(sql);
            }
        } else {
            throw new DataSyncException(syncRsp.getRspCode(), syncRsp.getRspDesc());
        }
    }

    private static String selectSqlBuilder(String tenantCode, String tableName, Map<String, Object> conditions, List<FTableFormMapBO> fTableFormMap) {
        log.info("\u6784\u9020sql-\u5f00\u59cb(selectSqlBuilder):tableName = {},conditions = {}, tableMap = {}", new Object[]{tableName, conditions, fTableFormMap});
        StringBuilder builder = new StringBuilder("select ");
        Object clos = "";
        Object where = " where tenant_code='" + tenantCode + "'";
        for (FTableFormMapBO fTableFormMapBO : fTableFormMap) {
            String asKey = NiccCommonUtil.underline2Camel((String)fTableFormMapBO.getTableColumnName(), (boolean)true);
            clos = (String)clos + fTableFormMapBO.getTableColumnName() + " as " + asKey + ",";
            Object val = conditions.get(fTableFormMapBO.getTableColumnName());
            if (val == null) continue;
            if (val instanceof Integer || val instanceof Long) {
                where = (String)where + " and " + fTableFormMapBO.getTableColumnName() + "=" + val;
                continue;
            }
            where = (String)where + " and " + fTableFormMapBO.getTableColumnName() + "='" + val + "'";
        }
        int page = (Integer)conditions.get("page");
        int limit = (Integer)conditions.get("limit");
        int start = (page - 1) * limit;
        String condition = (String)conditions.get("condition");
        String sort = (String)conditions.get("sort");
        int end = page * limit;
        if (((String)where).endsWith("and")) {
            where = ((String)where).substring(0, ((String)where).length() - 3);
        }
        if (((String)clos).length() > 1) {
            clos = ((String)clos).substring(0, ((String)clos).length() - 1);
            builder.append((String)clos).append(" from ").append(tableName).append((String)where);
            if (StringUtils.isNotEmpty((CharSequence)condition)) {
                builder.append(" and ").append(condition);
            }
            if (StringUtils.isNotEmpty((CharSequence)sort)) {
                builder.append(" ").append(sort);
            }
            builder.append(" limit ").append(start).append(",").append(end).append(" ");
            log.info("\u6784\u9020sql-\u5b8c\u6210(selectSqlBuilder):tableName = {},conditions = {}, sql = {}", new Object[]{tableName, conditions, builder});
            return builder.toString();
        }
        return "";
    }

    private static String insertSqlBuilder(String tableName, JSONObject formData, List<FTableFormMapBO> fTableFormMap) {
        log.info("\u6784\u9020sql-\u5f00\u59cb(insertSqlBuilder):tableName = {},formData = {}, tableMap = {}", new Object[]{tableName, formData, fTableFormMap});
        StringBuilder builder = new StringBuilder("insert into ");
        Object clos = "";
        Object values = "";
        for (FTableFormMapBO fTableFormMapBO : fTableFormMap) {
            String key = NiccCommonUtil.underline2Camel((String)fTableFormMapBO.getTableColumnName(), (boolean)true);
            String value = formData.getString(key);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            clos = (String)clos + fTableFormMapBO.getTableColumnName() + ",";
            values = (String)values + "'" + NiccCommonUtil.filterSql((String)value) + "',";
        }
        if (((String)clos).length() > 1) {
            clos = ((String)clos).substring(0, ((String)clos).length() - 1);
            values = ((String)values).substring(0, ((String)values).length() - 1);
            builder.append(tableName).append(" ( ").append((String)clos).append(" ) values ( ").append((String)values).append(" )");
            return builder.toString();
        }
        return "";
    }
}

