/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.utils;

import com.tydic.nicc.common.bo.rocketmq.CsImStateChangeContext;
import com.tydic.nicc.csm.api.bo.cs.CsOfflineQueueContext;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CsOfflineQueueManagerUtil {
    private static final ConcurrentLinkedQueue<CsOfflineQueueContext> offlineQueue = new ConcurrentLinkedQueue();

    public static synchronized void remove(String csId) {
        for (CsOfflineQueueContext context : offlineQueue) {
            if (!context.getCsId().equals(csId)) continue;
            offlineQueue.remove(context);
        }
    }

    public static void offer(CsImStateChangeContext stateChangeContext) {
        CsOfflineQueueManagerUtil.offer(stateChangeContext.getTenantCode(), stateChangeContext.getCsId(), stateChangeContext.getChangeTime());
    }

    public static synchronized void offer(String tenantCode, String csId, Date changeTime) {
        CsOfflineQueueManagerUtil.remove(csId);
        CsOfflineQueueContext context = CsOfflineQueueContext.builder().tenantCode(tenantCode).csId(csId).offlineTime(changeTime).build();
        offlineQueue.offer(context);
    }

    public static ConcurrentLinkedQueue<CsOfflineQueueContext> list() {
        return offlineQueue;
    }

    public static boolean isEmpty() {
        return offlineQueue.isEmpty();
    }

    public static CsOfflineQueueContext peek() {
        return offlineQueue.peek();
    }

    public static synchronized boolean remove(Object obj) {
        return offlineQueue.remove(obj);
    }
}

