/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.utils;

import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.csm.CsmUserQueueContext;
import com.tydic.nicc.common.bo.csm.CsmUserQueueIndex;
import com.tydic.nicc.common.constants.ImCoreConstants;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.csm.AutoReplyType;
import com.tydic.nicc.common.eums.csm.CsAutoReplyConfigLevel;
import com.tydic.nicc.common.eums.csm.CsQueueExitType;
import com.tydic.nicc.common.eums.im.ImMsgType;
import com.tydic.nicc.common.eums.im.SysMsgCode;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.common.msg.ImMessageBody;
import com.tydic.nicc.common.msg.ImSysMessageBody;
import com.tydic.nicc.common.msg.system.SysCsmQueueNotice;
import com.tydic.nicc.common.msg.system.SysMsgContent;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.cs.CsConfigMatcher;
import com.tydic.nicc.csm.api.bo.eum.QueueAllotType;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupInfo;
import com.tydic.nicc.csm.api.bo.skill.FetchQueueCount;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.ImMessageBuilder;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CsmCsAllotHelper {
    private static final Logger log = LoggerFactory.getLogger(CsmCsAllotHelper.class);
    private final Object $lock = new Object[0];
    public static final String QUEUE_FETCH_ALLOT_KEY = "QUEUE_FETCH_ALLOT_LOCK";
    public static final String IN_QUEUE_DEFAULT_TEXT = "\u6b63\u5728\u4e3a\u60a8\u8f6c\u63a5\u5ba2\u670d\uff0c\u8bf7\u7a0d\u7b49..\u5f53\u524d\u6392\u5728\u7b2c #position \u4f4d,\u5df2\u7b49\u5f85 #waitTime \u79d2";
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private CsmLogCommonService csmLogCommonService;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private NiccCsmConfigProperties csmConfigProperties;

    public List<CsmUserQueueContext> getSystemQueueList() {
        ArrayList list = Lists.newArrayList();
        List objects = this.redisHelper.lGet("csm:queue:list", 0L, -1L);
        if (objects != null) {
            for (Object object : objects) {
                list.add((CsmUserQueueContext)object);
            }
        }
        return list;
    }

    public FetchQueueCount fetchQueueSkill(String tenantCode, List<CsSkillGroupInfo> skills) {
        FetchQueueCount fetchQueueCount = this.csmConfigProperties.getQueueAllotType().equals(QueueAllotType.queue_count.name()) ? this.fetchQueueByQueueCount(tenantCode, skills) : this.fetchQueueByQueueTime(tenantCode, skills);
        return fetchQueueCount;
    }

    public FetchQueueCount fetchQueueByQueueCount(String tenantCode, List<CsSkillGroupInfo> skills) {
        for (CsSkillGroupInfo csSkillGroupInfo : skills) {
            long queueCount = this.getQueueCount(tenantCode, csSkillGroupInfo.getSkillGid());
            csSkillGroupInfo.setQueueCount(queueCount);
        }
        String skillId = "";
        long l = 0L;
        if (!(skills = skills.stream().sorted(Comparator.comparing(CsSkillGroupInfo::getQueueCount).reversed()).collect(Collectors.toList())).isEmpty()) {
            log.info("\u8ba1\u7b97\u6392\u961f\u6280\u80fd\u7ec4-\u6309\u6392\u961f\u4eba\u6570\u4f18\u5148:{}", skills);
            skillId = ((CsSkillGroupInfo)skills.get(0)).getSkillGid();
        }
        l = skills.stream().mapToLong(CsSkillGroupInfo::getQueueCount).sum();
        return FetchQueueCount.builder().queueCount(l).skillId(skillId).build();
    }

    public FetchQueueCount fetchQueueByQueueTime(String tenantCode, List<CsSkillGroupInfo> skills) {
        List<Object> queueContexts = Lists.newArrayList();
        for (CsSkillGroupInfo skill : skills) {
            CsmUserQueueContext queueContext = this.getQueueFirstItem(tenantCode, skill.getSkillGid());
            if (queueContext == null) continue;
            queueContexts.add(queueContext);
            skill.setQueueCount(1L);
        }
        String skillId = "";
        long count = 0L;
        if (!(queueContexts = queueContexts.stream().sorted(Comparator.comparing(CsmUserQueueContext::getQueueInTime).thenComparing(CsmUserQueueContext::getQueuePosition, Comparator.reverseOrder())).collect(Collectors.toList())).isEmpty()) {
            log.info("\u8ba1\u7b97\u6392\u961f\u6280\u80fd\u7ec4-\u6309\u6392\u961f\u65f6\u957f\u4f18\u5148:{}", queueContexts);
            skillId = ((CsmUserQueueContext)queueContexts.get(0)).getAllotSkillGid();
        }
        count = skills.stream().mapToLong(CsSkillGroupInfo::getQueueCount).sum();
        return FetchQueueCount.builder().queueCount(count).skillId(skillId).build();
    }

    public void clearAllotRequestFlag(String tenantCode, String userId) {
        String key = RedisCacheKeyConstant.getAllotRequestKey((String)tenantCode, (String)userId);
        try {
            this.redisHelper.del(new String[]{key});
        }
        catch (Exception e) {
            log.error("\u8f6c\u4eba\u5de5\u6d88\u606f\u5904\u7406-clearAllotRequestFlag,\u5f02\u5e38:", (Object)e.getMessage());
        }
    }

    public CsAutoReplyConfigBO matchAutoReplyConfig(AutoReplyType replyType, List<CsAutoReplyConfigBO> replyConfigs, CsConfigMatcher csConfigMatcher) {
        CsAutoReplyConfigBO csAutoReplyConfig = this.matchAutoReplyConfig(replyConfigs, csConfigMatcher);
        if (null == csAutoReplyConfig) {
            csAutoReplyConfig = new CsAutoReplyConfigBO();
            csAutoReplyConfig.setReplyContent(AutoReplyType.checkReplyText((String)replyType.getCode(), (String)""));
        }
        return csAutoReplyConfig;
    }

    public CsAutoReplyConfigBO matchAutoReplyConfig(List<CsAutoReplyConfigBO> replyConfigs, CsConfigMatcher csConfigMatcher) {
        List configs = null;
        if (StringUtils.isNotEmpty((CharSequence)csConfigMatcher.getCsId()) && (configs = replyConfigs.stream().filter(obj -> CsAutoReplyConfigLevel.CS.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(csConfigMatcher.getCsId())).collect(Collectors.toList())) != null && !configs.isEmpty()) {
            return (CsAutoReplyConfigBO)configs.get(0);
        }
        if (StringUtils.isNotEmpty((CharSequence)csConfigMatcher.getCsType()) && (configs = replyConfigs.stream().filter(obj -> CsAutoReplyConfigLevel.CS_TYPE.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(csConfigMatcher.getCsType())).collect(Collectors.toList())) != null && !configs.isEmpty()) {
            return (CsAutoReplyConfigBO)configs.get(0);
        }
        if (StringUtils.isNotEmpty((CharSequence)csConfigMatcher.getSkillGid()) && (configs = replyConfigs.stream().filter(obj -> CsAutoReplyConfigLevel.SKILL_GROUP.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(csConfigMatcher.getSkillGid())).collect(Collectors.toList())) != null && !configs.isEmpty()) {
            return (CsAutoReplyConfigBO)configs.get(0);
        }
        if (StringUtils.isNotEmpty((CharSequence)csConfigMatcher.getChannelCode()) && (configs = replyConfigs.stream().filter(obj -> CsAutoReplyConfigLevel.CHANNEL.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(csConfigMatcher.getChannelCode())).collect(Collectors.toList())) != null && !configs.isEmpty()) {
            return (CsAutoReplyConfigBO)configs.get(0);
        }
        if (StringUtils.isNotEmpty((CharSequence)csConfigMatcher.getTenantCode()) && (configs = replyConfigs.stream().filter(obj -> CsAutoReplyConfigLevel.TENANT.matchCode(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(csConfigMatcher.getTenantCode())).collect(Collectors.toList())) != null && !configs.isEmpty()) {
            return (CsAutoReplyConfigBO)configs.get(0);
        }
        return null;
    }

    public boolean hasQueue(String tenantCode, String skillGid) {
        String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)tenantCode, (String)skillGid);
        return this.redisHelper.hasKey(queueCacheKey);
    }

    public boolean hasUserQueue(String userId) {
        String queueCacheKey = RedisCacheKeyConstant.getUserQueueIndexCacheKey((String)userId);
        return this.redisHelper.hasKey(queueCacheKey);
    }

    public boolean hasUserSession(String chatKey) {
        String sessionIdCacheKey = RedisCacheKeyConstant.getSessionIdCacheKey((String)chatKey);
        return this.redisHelper.hasKey(sessionIdCacheKey);
    }

    public long getQueueCount(String tenantCode, String skillGid) {
        String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)tenantCode, (String)skillGid);
        return this.redisHelper.lGetListSize(queueCacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cancelQueue(String userId, String exitType) {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            log.error("\u53d6\u6d88\u7528\u6237\u6392\u961f\u5931\u8d25:\u7528\u6237id\u4e0d\u5f97\u4e3a\u7a7a!");
            return false;
        }
        CsmUserQueueIndex queueIndex = this.getUserQueueIndex(userId);
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{queueIndex})) return false;
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NiccCommonUtil.getAllotLockKey((String)queueIndex.getSkillGid())).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity, 1L, 2L);
        if (locked) {
            try {
                List<Object> queueList = this.getQueueList(queueIndex.getQueueKey());
                if (!ObjectUtils.anyNotNull((Object[])new Object[]{queueList})) return false;
                for (Object o : queueList) {
                    CsmUserQueueContext csmUserQueueContext = (CsmUserQueueContext)o;
                    if (!csmUserQueueContext.getUserId().equals(userId)) continue;
                    log.info("\u7528\u6237\u53d6\u6d88\u6392\u961f,\u79fb\u51fa\u7528\u6237:{}", (Object)csmUserQueueContext);
                    this.redisHelper.lRemove(queueIndex.getQueueKey(), 1L, o);
                    this.redisHelper.lRemove("csm:queue:list", 1L, o);
                    this.removeUserQueueIndex(userId);
                    csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                    csmUserQueueContext.setQueuePosition(queueList.size() - 1);
                    this.csmLogCommonService.saveCsSkillQueueLog(csmUserQueueContext, exitType);
                    boolean bl = true;
                    return bl;
                }
                return false;
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u53d6\u6d88\u6392\u961f,\u64cd\u4f5c\u5f02\u5e38:", (Throwable)e);
                return false;
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.cancelQueue(userId, exitType);
        return false;
    }

    public List<Object> getQueueList(String queueKey) {
        return this.redisHelper.lGet(queueKey, 0L, -1L);
    }

    public long getQueueCount(String queueKey) {
        return this.redisHelper.lGetListSize(queueKey);
    }

    public CsmUserQueueContext getUserQueueInfo(String userId) {
        String queueIndexKey = RedisCacheKeyConstant.getUserQueueIndexCacheKey((String)userId);
        CsmUserQueueIndex queueIndex = (CsmUserQueueIndex)this.redisHelper.get(queueIndexKey);
        if (queueIndex != null) {
            List<Object> queueList = this.getQueueList(queueIndex.getQueueKey());
            if (ObjectUtils.anyNotNull((Object[])new Object[]{queueList})) {
                int index = 0;
                for (Object o : queueList) {
                    CsmUserQueueContext csmUserQueueContext = (CsmUserQueueContext)o;
                    ++index;
                    if (!csmUserQueueContext.getUserId().equals(userId)) continue;
                    csmUserQueueContext.setQueuePosition(index);
                    csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                    log.info("\u67e5\u8be2\u7528\u6237\u6392\u961f\u4fe1\u606f:{}", (Object)csmUserQueueContext);
                    return csmUserQueueContext;
                }
            }
        }
        return null;
    }

    public CsmUserQueueIndex getUserQueueIndex(String userId) {
        String queueIndexKey = RedisCacheKeyConstant.getUserQueueIndexCacheKey((String)userId);
        CsmUserQueueIndex queueIndex = (CsmUserQueueIndex)this.redisHelper.get(queueIndexKey);
        return queueIndex;
    }

    public void removeUserQueueIndex(String userId) {
        String queueIndexKey = RedisCacheKeyConstant.getUserQueueIndexCacheKey((String)userId);
        this.redisHelper.del(new String[]{queueIndexKey});
    }

    public boolean isEmptyQueue(String tenantCode, String skillGid) {
        String vipQueueCacheKey = RedisCacheKeyConstant.getUserVipQueueCacheKey((String)tenantCode, (String)skillGid);
        String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)tenantCode, (String)skillGid);
        return this.redisHelper.lGetListSize(vipQueueCacheKey) <= 0L && this.redisHelper.lGetListSize(queueCacheKey) <= 0L;
    }

    public CsmUserQueueContext matchUserInQueue(String tenantCode, String skillGid, String usrId) {
        CsmUserQueueContext csmUserQueueContext = null;
        String vipQueueCacheKey = RedisCacheKeyConstant.getUserVipQueueCacheKey((String)tenantCode, (String)skillGid);
        String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)tenantCode, (String)skillGid);
        List<Object> queueContexts = this.getQueueList(queueCacheKey);
        log.info("\u83b7\u53d6\u6392\u961f\u961f\u5217:queueKey = {},queueList = {}", (Object)queueCacheKey, queueContexts);
        if (queueContexts != null && !queueContexts.isEmpty()) {
            int index = 0;
            for (Object queueContext : queueContexts) {
                ++index;
                csmUserQueueContext = (CsmUserQueueContext)queueContext;
                if (!usrId.equals(csmUserQueueContext.getUserId())) continue;
                csmUserQueueContext.setQueuePosition(index);
                csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                return csmUserQueueContext;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmUserQueueContext getQueueFirstItem(String tenantCode, String skillGid) {
        Object object = this.$lock;
        synchronized (object) {
            CsmUserQueueContext csmUserQueueContext = null;
            String vipQueueCacheKey = RedisCacheKeyConstant.getUserVipQueueCacheKey((String)tenantCode, (String)skillGid);
            String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)tenantCode, (String)skillGid);
            log.info("\u62c9\u53d6\u6392\u961f\u666e\u901a\u7528\u6237-key:{}", (Object)queueCacheKey);
            if (this.redisHelper.lGetListSize(queueCacheKey) > 0L && (csmUserQueueContext = (CsmUserQueueContext)this.redisHelper.lGetIndex(queueCacheKey, 0L)) != null) {
                csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                csmUserQueueContext.setQueueKey(queueCacheKey);
                log.info("\u62c9\u53d6\u6392\u961f\u666e\u901a\u7528\u6237:{}", (Object)csmUserQueueContext);
                return csmUserQueueContext;
            }
            return null;
        }
    }

    public void popQueue(String queueKey, String userId, String exitType) {
        this.popQueue(queueKey, userId, null, exitType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popQueue(String queueKey, String userId, String sessionId, String exitType) {
        Object object = this.$lock;
        synchronized (object) {
            log.info("\u4ece\u6392\u961f\u961f\u5217\u79fb\u9664\u7528\u6237:queueKey = {},userId = {}, exitType = {}", new Object[]{queueKey, userId, exitType});
            CsmUserQueueContext csmUserQueueContext = (CsmUserQueueContext)this.redisHelper.lLPop(queueKey);
            if (ObjectUtils.anyNotNull((Object[])new Object[]{csmUserQueueContext}) && csmUserQueueContext.getUserId().equals(userId)) {
                this.redisHelper.lRemove("csm:queue:list", 1L, (Object)csmUserQueueContext);
                csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                List<Object> list = this.getQueueList(queueKey);
                int position = 0;
                if (list != null) {
                    position = list.size();
                }
                csmUserQueueContext.setQueuePosition(position);
                if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                    csmUserQueueContext.setSessionId(sessionId);
                }
                this.csmLogCommonService.saveCsSkillQueueLog(csmUserQueueContext, exitType);
                this.removeUserQueueIndex(csmUserQueueContext.getUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmUserQueueContext popQueueAndReturn(String tenantCode, String skillGid) {
        Object object = this.$lock;
        synchronized (object) {
            CsmUserQueueContext csmUserQueueContext = null;
            String vipQueueCacheKey = RedisCacheKeyConstant.getUserVipQueueCacheKey((String)tenantCode, (String)skillGid);
            String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)tenantCode, (String)skillGid);
            if (this.redisHelper.lGetListSize(vipQueueCacheKey) > 0L) {
                csmUserQueueContext = (CsmUserQueueContext)this.redisHelper.lLPop(vipQueueCacheKey);
                csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                log.info("\u62c9\u53d6\u6392\u961fvip\u7528\u6237:{}", (Object)csmUserQueueContext);
            }
            if (this.redisHelper.lGetListSize(queueCacheKey) > 0L) {
                csmUserQueueContext = (CsmUserQueueContext)this.redisHelper.lLPop(queueCacheKey);
                csmUserQueueContext.setQueueOutTime(System.currentTimeMillis());
                log.info("\u62c9\u53d6\u6392\u961f\u666e\u901a\u7528\u6237:{}", (Object)csmUserQueueContext);
            }
            if (ObjectUtils.anyNotNull((Object[])new Object[]{csmUserQueueContext})) {
                this.removeUserQueueIndex(csmUserQueueContext.getUserId());
            }
            return csmUserQueueContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(CsmUserQueueContext queueContext) {
        Object object = this.$lock;
        synchronized (object) {
            String queueIndexKey = RedisCacheKeyConstant.getUserQueueIndexCacheKey((String)queueContext.getUserId());
            queueContext.setQueueLogId(IdWorker.nextAutoIdStr());
            try {
                CsmUserQueueIndex queueIndex;
                if (queueContext.isVipQueue()) {
                    String vipQueueCacheKey = RedisCacheKeyConstant.getUserVipQueueCacheKey((String)queueContext.getTenantCode(), (String)queueContext.getAllotSkillGid());
                    queueContext.setQueuePosition(Math.toIntExact(this.redisHelper.lGetListSize(vipQueueCacheKey)) + 1);
                    queueContext.setQueueKey(vipQueueCacheKey);
                    queueContext.setQueueOutTime(System.currentTimeMillis());
                    this.redisHelper.lSet(vipQueueCacheKey, (Object)queueContext);
                    queueIndex = CsmUserQueueIndex.builder().skillGid(queueContext.getAllotSkillGid()).queueKey(vipQueueCacheKey).build();
                } else {
                    String queueCacheKey = RedisCacheKeyConstant.getUserQueueCacheKey((String)queueContext.getTenantCode(), (String)queueContext.getAllotSkillGid());
                    queueContext.setQueuePosition(Math.toIntExact(this.redisHelper.lGetListSize(queueCacheKey)) + 1);
                    queueContext.setQueueKey(queueCacheKey);
                    queueContext.setQueueOutTime(System.currentTimeMillis());
                    this.redisHelper.lSet(queueCacheKey, (Object)queueContext);
                    queueIndex = CsmUserQueueIndex.builder().skillGid(queueContext.getAllotSkillGid()).queueKey(queueCacheKey).build();
                }
                this.csmLogCommonService.saveCsSkillQueueLog(queueContext, CsQueueExitType.QUEUE.getCode());
                this.redisHelper.set(queueIndexKey, (Object)queueIndex, (long)RedisCacheKeyConstant.ONE_DAY.intValue());
                this.redisHelper.lSet("csm:queue:list", (Object)queueContext, (long)RedisCacheKeyConstant.ONE_DAY.intValue());
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u8fdb\u5165\u6392\u961f\u5f02\u5e38: queueContext = {}", (Object)queueContext, (Object)e);
            }
        }
    }

    public ImMessage packageSysQueueMessage(CsmUserQueueContext queueContext) {
        String defaultText = IN_QUEUE_DEFAULT_TEXT.replace("#position", String.valueOf(queueContext.getQueuePosition())).replace("#waitTime", String.valueOf(queueContext.getWaitTime()));
        List<CsAutoReplyConfigBO> allotReplyConfigs = this.csmCommonService.getAutoReplyConfig(queueContext.getTenantCode(), AutoReplyType.IN_QUEUE.getCode());
        log.info("\u67e5\u8be2\u5ba2\u670d\u6392\u961f\u8bf4\u8f9e\u914d\u7f6e:{}", allotReplyConfigs);
        CsConfigMatcher csConfigMatcher = new CsConfigMatcher();
        csConfigMatcher.setTenantCode(queueContext.getTenantCode());
        csConfigMatcher.setChannelCode(queueContext.getChannelCode());
        csConfigMatcher.setSkillGid(queueContext.getAllotSkillGid());
        CsAutoReplyConfigBO replyConfigBO = this.matchAutoReplyConfig(allotReplyConfigs, csConfigMatcher);
        if (replyConfigBO != null) {
            long queueTotal = this.getQueueCount(queueContext.getQueueKey());
            defaultText = replyConfigBO.getReplyContent().replace("#queueCount", String.valueOf(queueTotal)).replace("#position", String.valueOf(queueContext.getQueuePosition())).replace("#waitTime", String.valueOf(queueContext.getWaitTime()));
        }
        ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.SYSTEM.getCode());
        message.setTenantCode(queueContext.getTenantCode());
        message.setToNo(queueContext.getUserId());
        message.setFromNo(ImCoreConstants.getSystemUser((String)queueContext.getTenantCode()));
        SysMsgContent sysMsgContent = new SysMsgContent();
        SysCsmQueueNotice csmQueueNotice = new SysCsmQueueNotice();
        csmQueueNotice.setFirstInQueue(true);
        csmQueueNotice.setQueueKey(queueContext.getQueueKey());
        csmQueueNotice.setAllotStrategy(queueContext.getAllotStrategy());
        csmQueueNotice.setPosition(Integer.valueOf(queueContext.getQueuePosition()));
        csmQueueNotice.setWaitTime(Integer.valueOf(queueContext.getWaitTime()));
        csmQueueNotice.setNoticeText(defaultText);
        sysMsgContent.setCsmQueueNotice(csmQueueNotice);
        ImSysMessageBody messageBody = new ImSysMessageBody(SysMsgCode.USER_QUEUE.getCode(), sysMsgContent);
        message.setMsgBody((ImMessageBody)messageBody);
        return message;
    }
}

