/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.utils;

import com.tydic.nicc.csm.api.bo.eum.LocalCacheType;
import com.tydic.nicc.csm.api.bo.mq.LocalCacheSyncContext;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LocalCacheSyncHelper {
    private static final Logger log = LoggerFactory.getLogger(LocalCacheSyncHelper.class);
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;

    public void clearAutoReplyCache(String tenantCode, String key) {
        try {
            LocalCacheSyncContext context = LocalCacheSyncContext.builder().type(LocalCacheType.autoReply).tenantCode(tenantCode).key(key).build();
            this.kkMqProducerHelper.sendMsg("CSM_LOCAL_CACHE_SYNC", (Object)context);
        }
        catch (Exception e) {
            log.error("clearAutoReplyCache error:{}", (Object)e.getMessage());
        }
    }

    public void clearRobotQaCache(String tenantCode, String key) {
        try {
            LocalCacheSyncContext context = LocalCacheSyncContext.builder().type(LocalCacheType.robotQa).tenantCode(tenantCode).key(key).build();
            this.kkMqProducerHelper.sendMsg("CSM_LOCAL_CACHE_SYNC", (Object)context);
        }
        catch (Exception e) {
            log.error("clearRobotQaCache error:{}", (Object)e.getMessage());
        }
    }
}

